/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Method;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import jetbrains.buildServer.util.Disposable;
import jetbrains.buildServer.util.TimeUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NamedThreadUtil {
    private static final String tc_prefix = "TC: ";
    private static final ConcurrentHashMap<Long, AtomicLong[]> ourInitialThreadStats;
    private static final int ALLOC_MEM_POS = 0;
    private static final int USED_CPU_POS = 1;
    private static final int THREAD_NAME_UPDATE_TIME_POS = 2;
    private static final int DATA_UPDATE_TIME_POS = 3;
    @Nullable
    private static final ThreadMXBean ourThreadMXBean;
    private static Method ourThreadAllocatedSizeMethod;

    @NotNull
    public static ThreadNameCookie updateThreadName(@NotNull String newDetails) {
        if (newDetails == null) {
            NamedThreadUtil.$$$reportNull$$$0(0);
        }
        ThreadNameCookie threadNameCookie = new ThreadNameCookie().setNewName(newDetails);
        if (threadNameCookie == null) {
            NamedThreadUtil.$$$reportNull$$$0(1);
        }
        return threadNameCookie;
    }

    @NotNull
    public static Disposable updateThreadName(@NotNull String newDetails, boolean rememberThreadStatistics) {
        if (newDetails == null) {
            NamedThreadUtil.$$$reportNull$$$0(2);
        }
        ThreadNameCookie threadNameCookie = NamedThreadUtil.updateThreadName(newDetails);
        if (threadNameCookie == null) {
            NamedThreadUtil.$$$reportNull$$$0(3);
        }
        return threadNameCookie;
    }

    public static String getTcThreadPrefix() {
        return tc_prefix + TimeUtil.getCurrentTimeString();
    }

    @Nullable
    public static long[] getThreadStatistics(@NotNull Thread thread) {
        AtomicLong[] initial;
        if (thread == null) {
            NamedThreadUtil.$$$reportNull$$$0(4);
        }
        if ((initial = ourInitialThreadStats.get(thread.getId())) == null) {
            return null;
        }
        PerfStat currentStats = PerfStat.createFromThread(thread.getId());
        if (initial[2].get() > initial[3].get()) {
            return new long[]{-1L, -1L, initial[2].get(), initial[3].get(), currentStats.allocatedMemory, currentStats.cpuUsage};
        }
        return new long[]{currentStats.allocatedMemory - initial[0].get(), currentStats.cpuUsage - initial[1].get(), initial[2].get(), initial[3].get(), currentStats.allocatedMemory, currentStats.cpuUsage};
    }

    private static void putThreadData(@NotNull Thread thread, @NotNull PerfStat result) {
        if (thread == null) {
            NamedThreadUtil.$$$reportNull$$$0(5);
        }
        if (result == null) {
            NamedThreadUtil.$$$reportNull$$$0(6);
        }
        if (result.notEmptyDataOrNull() == null) {
            return;
        }
        AtomicLong[] atomicLongs = ourInitialThreadStats.get(thread.getId());
        long now = System.nanoTime();
        if (atomicLongs == null) {
            ourInitialThreadStats.put(thread.getId(), new AtomicLong[]{new AtomicLong(result.allocatedMemory), new AtomicLong(result.cpuUsage), new AtomicLong(now), new AtomicLong(now)});
        } else {
            atomicLongs[0].set(result.allocatedMemory);
            atomicLongs[1].set(result.cpuUsage);
            atomicLongs[2].set(now);
            atomicLongs[3].set(now);
        }
    }

    @NotNull
    private static AtomicLong[] emptyData() {
        AtomicLong[] atomicLongArray = new AtomicLong[]{new AtomicLong(-1L), new AtomicLong(-1L), new AtomicLong(0L), new AtomicLong(-1L)};
        if (atomicLongArray == null) {
            NamedThreadUtil.$$$reportNull$$$0(7);
        }
        return atomicLongArray;
    }

    @Nullable
    public static PerfStat getCurrentStats(@NotNull Thread thread, boolean updateCachedThreadStat) {
        if (thread == null) {
            NamedThreadUtil.$$$reportNull$$$0(8);
        }
        PerfStat result = PerfStat.createFromThread(thread.getId());
        if (updateCachedThreadStat) {
            NamedThreadUtil.putThreadData(thread, result);
        }
        return result.notEmptyDataOrNull();
    }

    private static void resetThreadStatistics(Thread thread) {
        ourInitialThreadStats.remove(thread.getId());
    }

    private static long getThreadAllocatedBytes(long threadId) {
        if (ourThreadMXBean == null) {
            return -1L;
        }
        try {
            return (Long)ourThreadAllocatedSizeMethod.invoke((Object)ourThreadMXBean, threadId);
        }
        catch (Exception exception) {
            return -1L;
        }
    }

    private static long getThreadCpuUsage(long threadId) {
        if (ourThreadMXBean == null) {
            return -1L;
        }
        try {
            return ourThreadMXBean.isThreadCpuTimeSupported() ? ourThreadMXBean.getThreadCpuTime(threadId) : -1L;
        }
        catch (Exception exception) {
            return -1L;
        }
    }

    @Nullable
    private static ThreadMXBean getThreadsBean() {
        try {
            return ManagementFactory.getThreadMXBean();
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static void updateThreadStatistics() {
        long[] ids;
        if (ourThreadMXBean == null) {
            return;
        }
        for (long id : ids = ourThreadMXBean.getAllThreadIds()) {
            AtomicLong[] longs = ourInitialThreadStats.get(id);
            if (longs == null) {
                longs = NamedThreadUtil.emptyData();
                AtomicLong[] stored = ourInitialThreadStats.putIfAbsent(id, longs);
                if (stored != null) {
                    longs = stored;
                }
            }
            AtomicLong c = longs[3];
            if (longs[2].get() < c.get()) continue;
            PerfStat perf = PerfStat.createFromThread(id);
            longs[0].set(perf.allocatedMemory);
            longs[1].set(perf.cpuUsage);
            c.set(System.nanoTime());
        }
    }

    static {
        block4: {
            ourInitialThreadStats = new ConcurrentHashMap();
            ourThreadMXBean = NamedThreadUtil.getThreadsBean();
            if (ourThreadMXBean != null) {
                try {
                    ourThreadAllocatedSizeMethod = ourThreadMXBean.getClass().getMethod("getThreadAllocatedBytes", Long.TYPE);
                    ourThreadAllocatedSizeMethod.setAccessible(true);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                }
                catch (RuntimeException e) {
                    if ("java.lang.reflect.InaccessibleObjectException".equals(e.getClass().getName())) break block4;
                    throw e;
                }
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newDetails";
                break;
            }
            case 1: 
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/util/NamedThreadUtil";
                break;
            }
            case 4: 
            case 5: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "thread";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/util/NamedThreadUtil";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "updateThreadName";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "emptyData";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "updateThreadName";
                break;
            }
            case 1: 
            case 3: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getThreadStatistics";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "putThreadData";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentStats";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class PerfStat {
        private static final AtomicLong ourTime = new AtomicLong(0L);
        private static final AtomicLong ourCount = new AtomicLong(0L);
        public long allocatedMemory;
        public long cpuUsage;

        @NotNull
        static PerfStat createFromThread(long threadId) {
            ourCount.incrementAndGet();
            PerfStat result = new PerfStat();
            long start = System.nanoTime();
            result.allocatedMemory = NamedThreadUtil.getThreadAllocatedBytes(threadId);
            result.cpuUsage = NamedThreadUtil.getThreadCpuUsage(threadId);
            ourTime.addAndGet(System.nanoTime() - start);
            PerfStat perfStat = result;
            if (perfStat == null) {
                PerfStat.$$$reportNull$$$0(0);
            }
            return perfStat;
        }

        PerfStat diffToState(@NotNull PerfStat toPerfStat) {
            if (toPerfStat == null) {
                PerfStat.$$$reportNull$$$0(1);
            }
            PerfStat result = new PerfStat();
            result.allocatedMemory = toPerfStat.allocatedMemory == -1L || this.allocatedMemory == -1L ? -1L : toPerfStat.allocatedMemory - this.allocatedMemory;
            result.cpuUsage = toPerfStat.cpuUsage == -1L || this.cpuUsage == -1L ? -1L : toPerfStat.cpuUsage - this.cpuUsage;
            return result;
        }

        PerfStat diffToCurrentState() {
            return this.diffToState(PerfStat.createFromThread(Thread.currentThread().getId()));
        }

        PerfStat notEmptyDataOrNull() {
            if (this.allocatedMemory == -1L && this.cpuUsage == -1L) {
                return null;
            }
            return this;
        }

        public static long getTotalRetrievalTime() {
            return ourTime.get();
        }

        public static long getTotalCount() {
            return ourCount.get();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "jetbrains/buildServer/util/NamedThreadUtil$PerfStat";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "toPerfStat";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "createFromThread";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "jetbrains/buildServer/util/NamedThreadUtil$PerfStat";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "diffToState";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static final class ThreadNameCookie
    implements Disposable {
        private final Thread myThread = Thread.currentThread();
        private final String myOldName;

        private ThreadNameCookie() {
            String name = this.myThread.getName();
            if (name == null) {
                name = "";
            }
            this.myOldName = name;
        }

        @NotNull
        public String getOldName() {
            String string = this.myOldName;
            if (string == null) {
                ThreadNameCookie.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public ThreadNameCookie setNewName(@NotNull String newDetails) {
            if (newDetails == null) {
                ThreadNameCookie.$$$reportNull$$$0(1);
            }
            newDetails = newDetails.replace('\"', '\'');
            String currentName = this.getOldName();
            String namePrefix = NamedThreadUtil.getTcThreadPrefix();
            if (!newDetails.isEmpty()) {
                namePrefix = namePrefix + newDetails + "; ";
            }
            if (currentName.startsWith(NamedThreadUtil.tc_prefix)) {
                this.myThread.setName(namePrefix + currentName.substring(NamedThreadUtil.tc_prefix.length()));
            } else {
                this.myThread.setName(namePrefix + currentName);
            }
            ThreadNameCookie threadNameCookie = this;
            if (threadNameCookie == null) {
                ThreadNameCookie.$$$reportNull$$$0(2);
            }
            return threadNameCookie;
        }

        public void dispose() {
            this.myThread.setName(this.myOldName);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
                case 1: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 2;
                    break;
                }
                case 1: {
                    n2 = 3;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "jetbrains/buildServer/util/NamedThreadUtil$ThreadNameCookie";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newDetails";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOldName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "jetbrains/buildServer/util/NamedThreadUtil$ThreadNameCookie";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "setNewName";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "setNewName";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

