/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util.PEReader;

import java.io.IOException;
import java.io.RandomAccessFile;

public class BinaryUtils {
    public static long readUInt32(RandomAccessFile raf) throws IOException {
        long byte1 = BinaryUtils.readUInt8(raf);
        long byte2 = BinaryUtils.readUInt8(raf);
        long byte3 = BinaryUtils.readUInt8(raf);
        long byte4 = BinaryUtils.readUInt8(raf);
        return byte1 | byte2 << 8 | byte3 << 16 | byte4 << 24;
    }

    public static int readUInt16(RandomAccessFile raf) throws IOException {
        int byte1 = BinaryUtils.readUInt8(raf);
        int byte2 = BinaryUtils.readUInt8(raf);
        return byte1 | byte2 << 8;
    }

    public static String readFixedByteChars(RandomAccessFile raf, int count) throws IOException {
        StringBuffer buf = new StringBuffer(count);
        for (int i = 0; i < count; ++i) {
            buf.append((char)raf.read());
        }
        return buf.toString();
    }

    public static String readWCHAR(RandomAccessFile raf, int maxLen) throws IOException {
        int i;
        int pos = 0;
        StringBuffer buf = new StringBuffer();
        while ((i = BinaryUtils.readUInt16(raf)) != 0) {
            buf.append((char)i);
            if (maxLen <= 0 || ++pos < maxLen) continue;
            break;
        }
        return buf.toString();
    }

    public static int readUInt8(RandomAccessFile raf) throws IOException {
        return raf.read();
    }

    public static long dwordAlign(long off) {
        return off + 3L - (off + 3L) % 4L;
    }
}

