/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util.PEReader;

import java.io.IOException;
import java.io.RandomAccessFile;
import jetbrains.buildServer.util.PEReader.BinaryUtils;
import jetbrains.buildServer.util.PEReader.PEImageResourceDirectoryEntry;

public class PEImageResourceDirectory {
    private long myCharacteristics;
    private long myTimeDateStamp;
    private int myMajorVersion;
    private int myMinorVersion;
    private int myNumberOfNamedEntries;
    private int myNumberOfIdEntries;
    private PEImageResourceDirectoryEntry[] myEntries;

    private PEImageResourceDirectory() {
    }

    public static PEImageResourceDirectory read(RandomAccessFile raf) throws IOException {
        PEImageResourceDirectory res = new PEImageResourceDirectory();
        res.myCharacteristics = BinaryUtils.readUInt32(raf);
        res.myTimeDateStamp = BinaryUtils.readUInt32(raf);
        res.myMajorVersion = BinaryUtils.readUInt16(raf);
        res.myMinorVersion = BinaryUtils.readUInt16(raf);
        res.myNumberOfNamedEntries = BinaryUtils.readUInt16(raf);
        res.myNumberOfIdEntries = BinaryUtils.readUInt16(raf);
        int totalEntries = res.myNumberOfNamedEntries + res.myNumberOfIdEntries;
        res.myEntries = new PEImageResourceDirectoryEntry[totalEntries];
        for (int i = 0; i < totalEntries; ++i) {
            res.myEntries[i] = PEImageResourceDirectoryEntry.read(raf);
        }
        return res;
    }

    public long getCharacteristics() {
        return this.myCharacteristics;
    }

    public long getTimeDateStamp() {
        return this.myTimeDateStamp;
    }

    public int getMajorVersion() {
        return this.myMajorVersion;
    }

    public int getMinorVersion() {
        return this.myMinorVersion;
    }

    public int getNumberOfNamedEntries() {
        return this.myNumberOfNamedEntries;
    }

    public int getNumberOfIdEntries() {
        return this.myNumberOfIdEntries;
    }

    public PEImageResourceDirectoryEntry[] getEntries() {
        return this.myEntries;
    }
}

