/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util.PEReader;

import java.io.IOException;
import java.io.RandomAccessFile;
import jetbrains.buildServer.util.PEReader.BinaryUtils;

public class PEImageSectionHeader {
    private String myName;
    private long myVirtualAddress;
    private long mySizeOfRawData;
    private long myPointerToRawData;

    private PEImageSectionHeader() {
    }

    public static PEImageSectionHeader read(RandomAccessFile raf) throws IOException {
        PEImageSectionHeader res = new PEImageSectionHeader();
        res.myName = BinaryUtils.readFixedByteChars(raf, 8);
        BinaryUtils.readUInt32(raf);
        res.myVirtualAddress = BinaryUtils.readUInt32(raf);
        res.mySizeOfRawData = BinaryUtils.readUInt32(raf);
        res.myPointerToRawData = BinaryUtils.readUInt32(raf);
        BinaryUtils.readUInt32(raf);
        BinaryUtils.readUInt32(raf);
        BinaryUtils.readUInt16(raf);
        BinaryUtils.readUInt16(raf);
        BinaryUtils.readUInt32(raf);
        return res;
    }

    public String getName() {
        return this.myName;
    }

    public long getVirtualAddress() {
        return this.myVirtualAddress;
    }

    public long getSizeOfRawData() {
        return this.mySizeOfRawData;
    }

    public long getPointerToRawData() {
        return this.myPointerToRawData;
    }
}

