/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.Nullable;

public class PooledProperties
extends Properties {
    private Map<Object, Object> valuesPool = new HashMap<Object, Object>();

    private <T> T pool(@Nullable T s) {
        Map<Object, Object> pool = this.valuesPool;
        if (pool == null || s == null) {
            return s;
        }
        Object p = pool.get(s);
        if (p != null) {
            return (T)p;
        }
        pool.put(s, s);
        return s;
    }

    @Override
    public Object setProperty(String key, String value) {
        return super.setProperty(key, this.pool(value));
    }

    @Override
    public Object put(Object key, Object value) {
        return super.put(key, this.pool(value));
    }

    @Override
    public void load(Reader reader) throws IOException {
        this.valuesPool = new HashMap<Object, Object>();
        try {
            super.load(reader);
        }
        finally {
            this.valuesPool = null;
        }
    }

    @Override
    public void load(InputStream inStream) throws IOException {
        this.valuesPool = new HashMap<Object, Object>();
        try {
            super.load(inStream);
        }
        finally {
            this.valuesPool = null;
        }
    }

    @Override
    public void loadFromXML(InputStream in) throws IOException {
        this.valuesPool = new HashMap<Object, Object>();
        try {
            super.loadFromXML(in);
        }
        finally {
            this.valuesPool = null;
        }
    }
}

