/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import com.intellij.openapi.util.Pair;
import com.intellij.util.text.LineReader;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import jetbrains.buildServer.util.FileUtil;
import jetbrains.buildServer.util.StringUtil;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropertiesUtil {
    private PropertiesUtil() {
    }

    @Contract(value="null -> false")
    public static boolean getBoolean(@Nullable String value) {
        return "true".equalsIgnoreCase(value) || "yes".equalsIgnoreCase(value);
    }

    @Contract(value="null -> true")
    public static boolean isEmptyOrNull(@Nullable String value) {
        return value == null || value.trim().length() == 0;
    }

    @Contract(value="null -> null")
    @Nullable
    public static Integer parseInt(@Nullable String value) {
        if (value == null) {
            return null;
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    @Contract(value="null -> null")
    @Nullable
    public static Long parseLong(@Nullable String value) {
        if (value == null) {
            return null;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            return null;
        }
    }

    public static int compareProperties(@NotNull Map<String, String> props1, @NotNull Map<String, String> props2) {
        if (props1 == null) {
            PropertiesUtil.$$$reportNull$$$0(0);
        }
        if (props2 == null) {
            PropertiesUtil.$$$reportNull$$$0(1);
        }
        int commonProps = 0;
        for (String name : props1.keySet()) {
            if (!props1.get(name).equals(props2.get(name))) continue;
            ++commonProps;
        }
        if (props1.size() == commonProps) {
            return commonProps - props2.size();
        }
        if (props2.size() == commonProps) {
            return props1.size() - commonProps;
        }
        return 0;
    }

    @NotNull
    public static Properties loadProperties(File propertiesFile) throws IOException {
        if (propertiesFile == null || !propertiesFile.exists()) {
            Properties properties = new Properties();
            if (properties == null) {
                PropertiesUtil.$$$reportNull$$$0(2);
            }
            return properties;
        }
        Properties properties = PropertiesUtil.loadProperties(new FileInputStream(propertiesFile));
        if (properties == null) {
            PropertiesUtil.$$$reportNull$$$0(3);
        }
        return properties;
    }

    @NotNull
    public static Properties loadPropertiesZipped(File propertiesFile) throws IOException {
        if (propertiesFile == null) {
            Properties properties = new Properties();
            if (properties == null) {
                PropertiesUtil.$$$reportNull$$$0(4);
            }
            return properties;
        }
        Properties properties = PropertiesUtil.loadProperties(new GZIPInputStream(new BufferedInputStream(new FileInputStream(propertiesFile))));
        if (properties == null) {
            PropertiesUtil.$$$reportNull$$$0(5);
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static Properties loadProperties(@Nullable InputStream inputStream) throws IOException {
        Properties properties;
        if (inputStream == null) {
            Properties properties2 = new Properties();
            if (properties2 == null) {
                PropertiesUtil.$$$reportNull$$$0(6);
            }
            return properties2;
        }
        BufferedInputStream inStream = null;
        try {
            inStream = new BufferedInputStream(inputStream);
            Properties properties3 = new Properties();
            properties3.load(inStream);
            properties = properties3;
        }
        catch (Throwable throwable) {
            PropertiesUtil.close(inStream);
            throw throwable;
        }
        PropertiesUtil.close(inStream);
        Properties properties4 = properties;
        if (properties4 == null) {
            PropertiesUtil.$$$reportNull$$$0(7);
        }
        return properties4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static Properties loadPropertiesXml(File propertiesFile) throws IOException {
        Properties properties;
        if (propertiesFile == null) {
            Properties properties2 = new Properties();
            if (properties2 == null) {
                PropertiesUtil.$$$reportNull$$$0(8);
            }
            return properties2;
        }
        BufferedInputStream inStream = null;
        try {
            inStream = new BufferedInputStream(new FileInputStream(propertiesFile));
            Properties properties3 = new Properties();
            properties3.loadFromXML(inStream);
            properties = properties3;
        }
        catch (Throwable throwable) {
            PropertiesUtil.close(inStream);
            throw throwable;
        }
        PropertiesUtil.close(inStream);
        Properties properties4 = properties;
        if (properties4 == null) {
            PropertiesUtil.$$$reportNull$$$0(9);
        }
        return properties4;
    }

    @NotNull
    public static Map<String, String> toMap(@NotNull Properties properties) {
        if (properties == null) {
            PropertiesUtil.$$$reportNull$$$0(10);
        }
        HashMap<String, String> map = new HashMap<String, String>(properties.size());
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            map.put((String)entry.getKey(), (String)entry.getValue());
        }
        HashMap<String, String> hashMap = map;
        if (hashMap == null) {
            PropertiesUtil.$$$reportNull$$$0(11);
        }
        return hashMap;
    }

    public static void storeProperties(@NotNull Properties properties, @Nullable File propertiesFile, @Nullable String comment) throws IOException {
        if (properties == null) {
            PropertiesUtil.$$$reportNull$$$0(12);
        }
        if (propertiesFile == null) {
            return;
        }
        PropertiesUtil.storeProperties(properties, new FileOutputStream(propertiesFile), comment);
    }

    public static void storePropertiesZipped(@NotNull Properties properties, @Nullable File propertiesFile, @Nullable String comment) throws IOException {
        if (properties == null) {
            PropertiesUtil.$$$reportNull$$$0(13);
        }
        if (propertiesFile == null) {
            return;
        }
        PropertiesUtil.storeProperties(properties, new GZIPOutputStream(new BufferedOutputStream(new FileOutputStream(propertiesFile))), comment);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void storeProperties(@NotNull Properties properties, @Nullable OutputStream stream, @Nullable String comment) throws IOException {
        if (properties == null) {
            PropertiesUtil.$$$reportNull$$$0(14);
        }
        if (stream == null) {
            return;
        }
        BufferedOutputStream fos = new BufferedOutputStream(stream);
        try {
            properties.store(fos, comment);
        }
        finally {
            PropertiesUtil.close(fos);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void storePropertiesXml(@NotNull Properties properties, @Nullable File propertiesFile, @Nullable String comment) throws IOException {
        if (properties == null) {
            PropertiesUtil.$$$reportNull$$$0(15);
        }
        if (propertiesFile == null) {
            return;
        }
        BufferedOutputStream fos = null;
        try {
            FileUtil.createParentDirs((File)propertiesFile);
            fos = new BufferedOutputStream(new FileOutputStream(propertiesFile));
            properties.storeToXML((OutputStream)fos, comment, "utf-8");
        }
        catch (Throwable throwable) {
            PropertiesUtil.close(fos);
            throw throwable;
        }
        PropertiesUtil.close(fos);
    }

    public static boolean isDifferent(@NotNull Properties p1, @NotNull Properties p2) {
        if (p1 == null) {
            PropertiesUtil.$$$reportNull$$$0(16);
        }
        if (p2 == null) {
            PropertiesUtil.$$$reportNull$$$0(17);
        }
        return !p1.equals(p2);
    }

    private static byte[] getLineForKey(@NotNull String key, @NotNull String value) throws IOException {
        if (key == null) {
            PropertiesUtil.$$$reportNull$$$0(18);
        }
        if (value == null) {
            PropertiesUtil.$$$reportNull$$$0(19);
        }
        Properties ps = new Properties();
        ps.setProperty(key, value);
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        ps.store(bos, null);
        bos.close();
        List newLines = new LineReader((InputStream)new ByteArrayInputStream(bos.toByteArray())).readLines();
        Iterator iterator = newLines.iterator();
        while (iterator.hasNext()) {
            byte[] line = (byte[])iterator.next();
            if (line.length != 0 && line[0] != 35) continue;
            iterator.remove();
        }
        assert (newLines.size() == 1);
        return (byte[])newLines.get(0);
    }

    @NotNull
    public static Set<String> getPropertyNames(@NotNull Properties properties) {
        if (properties == null) {
            PropertiesUtil.$$$reportNull$$$0(20);
        }
        HashSet<String> names = new HashSet<String>();
        Enumeration<?> en = properties.propertyNames();
        while (en.hasMoreElements()) {
            Object o = en.nextElement();
            names.add((String)o);
        }
        HashSet<String> hashSet = names;
        if (hashSet == null) {
            PropertiesUtil.$$$reportNull$$$0(21);
        }
        return hashSet;
    }

    @Nullable
    private static Pair<String, String> getPairFromLine(@NotNull byte[] line) throws IOException {
        if (line == null) {
            PropertiesUtil.$$$reportNull$$$0(22);
        }
        Properties ps = new Properties();
        ps.load(new ByteArrayInputStream(line));
        assert (ps.size() <= 1);
        if (ps.size() == 0) {
            return null;
        }
        String key = (String)ps.keys().nextElement();
        return Pair.create((Object)key, (Object)ps.getProperty(key));
    }

    public static boolean updatePropertiesFromFile(@NotNull File propertiesFile, @NotNull Map<String, String> propertiesToUpdate, @NotNull Set<String> toRemove) throws IOException {
        if (propertiesFile == null) {
            PropertiesUtil.$$$reportNull$$$0(23);
        }
        if (propertiesToUpdate == null) {
            PropertiesUtil.$$$reportNull$$$0(24);
        }
        if (toRemove == null) {
            PropertiesUtil.$$$reportNull$$$0(25);
        }
        if (propertiesToUpdate.isEmpty() && toRemove.isEmpty()) {
            return true;
        }
        Properties properties = PropertiesUtil.loadProperties(propertiesFile);
        for (Map.Entry<String, String> entry : propertiesToUpdate.entrySet()) {
            properties.setProperty(entry.getKey(), entry.getValue());
        }
        for (String key : toRemove) {
            properties.remove(key);
        }
        return PropertiesUtil.updateProperties(propertiesFile, properties, null);
    }

    public static boolean updateProperties(@NotNull File propertiesFile, @NotNull Properties newProperties, @Nullable String commentIfFileIsRecreated) throws IOException {
        byte[] buf;
        if (propertiesFile == null) {
            PropertiesUtil.$$$reportNull$$$0(26);
        }
        if (newProperties == null) {
            PropertiesUtil.$$$reportNull$$$0(27);
        }
        if ((buf = PropertiesUtil.getUpdatedPropertiesArray(propertiesFile, newProperties, commentIfFileIsRecreated)) == null) {
            return false;
        }
        FileUtil.writeViaTmpFile(propertiesFile, new ByteArrayInputStream(buf), FileUtil.IOAction.DO_NOTHING);
        return true;
    }

    @Nullable
    public static byte[] getUpdatedPropertiesArray(@NotNull File propertiesFile, @NotNull Properties newProperties) throws IOException {
        if (propertiesFile == null) {
            PropertiesUtil.$$$reportNull$$$0(28);
        }
        if (newProperties == null) {
            PropertiesUtil.$$$reportNull$$$0(29);
        }
        return PropertiesUtil.getUpdatedPropertiesArray(propertiesFile, newProperties, null);
    }

    @Nullable
    public static byte[] getUpdatedPropertiesArray(@NotNull File propertiesFile, @NotNull Properties newProperties, @Nullable String commentIfFileIsRecreated) throws IOException {
        List lines;
        if (propertiesFile == null) {
            PropertiesUtil.$$$reportNull$$$0(30);
        }
        if (newProperties == null) {
            PropertiesUtil.$$$reportNull$$$0(31);
        }
        if (!propertiesFile.exists()) {
            try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
                PropertiesUtil.storeProperties(newProperties, outputStream, commentIfFileIsRecreated);
                byte[] byArray = outputStream.toByteArray();
                return byArray;
            }
        }
        Properties oldProperties = PropertiesUtil.loadProperties(propertiesFile);
        if (!PropertiesUtil.isDifferent(oldProperties, newProperties)) {
            return null;
        }
        try (BufferedInputStream fis = new BufferedInputStream(new FileInputStream(propertiesFile));){
            lines = new LineReader((InputStream)fis).readLines();
        }
        Set<String> oldNames = PropertiesUtil.getPropertyNames(oldProperties);
        Set<String> newNames = PropertiesUtil.getPropertyNames(newProperties);
        ArrayList<byte[]> newLines = new ArrayList<byte[]>();
        boolean isMultiline = false;
        boolean isKeepMultiline = false;
        for (byte[] line : lines) {
            Pair<String, String> pair = PropertiesUtil.getPairFromLine(line);
            if (isMultiline && pair != null && StringUtil.isNotEmpty((String)((String)pair.first)) && StringUtil.isEmpty((String)((String)pair.second)) && line[line.length - 1] != 61) {
                if (!isKeepMultiline) continue;
                newLines.add(line);
                continue;
            }
            if (pair == null) {
                if (isMultiline && !isKeepMultiline) continue;
                newLines.add(line);
                continue;
            }
            String key = (String)pair.first;
            boolean bl = isMultiline = !((String)pair.second).equals(oldProperties.getProperty(key));
            if (newProperties.containsKey(key)) {
                if (newProperties.getProperty(key).equals(oldProperties.getProperty(key))) {
                    newLines.add(line);
                    isKeepMultiline = true;
                    continue;
                }
                newLines.add(PropertiesUtil.getLineForKey(key, newProperties.getProperty(key)));
                isKeepMultiline = false;
                continue;
            }
            isKeepMultiline = false;
            byte[] commented = new byte[line.length + 2];
            commented[0] = 35;
            commented[1] = 32;
            for (byte commented[i + 2] : line) {
            }
            newLines.add(commented);
        }
        for (String newName : newNames) {
            if (oldNames.contains(newName)) continue;
            newLines.add(PropertiesUtil.getLineForKey(newName, newProperties.getProperty(newName)));
        }
        try (ByteArrayOutputStream fos = new ByteArrayOutputStream();){
            byte[] endLine = System.getProperty("line.separator").getBytes(StandardCharsets.ISO_8859_1);
            for (byte[] newLine : newLines) {
                fos.write(newLine);
                fos.write(endLine);
            }
            Object object = fos.toByteArray();
            return object;
        }
    }

    private static void close(Closeable cl) {
        if (cl != null) {
            try {
                cl.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "props1";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "props2";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/util/PropertiesUtil";
                break;
            }
            case 10: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "properties";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p1";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p2";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 23: 
            case 26: 
            case 28: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertiesFile";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertiesToUpdate";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toRemove";
                break;
            }
            case 27: 
            case 29: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newProperties";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/util/PropertiesUtil";
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "loadProperties";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "loadPropertiesZipped";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "loadPropertiesXml";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "toMap";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertyNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "compareProperties";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 21: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "toMap";
                break;
            }
            case 12: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "storeProperties";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "storePropertiesZipped";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "storePropertiesXml";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "isDifferent";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "getLineForKey";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getPropertyNames";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getPairFromLine";
                break;
            }
            case 23: 
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "updatePropertiesFromFile";
                break;
            }
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "updateProperties";
                break;
            }
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "getUpdatedPropertiesArray";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 11: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

