/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import jetbrains.buildServer.util.ItemProcessor;
import jetbrains.buildServer.util.filters.Filter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RecentEntriesCache<K, V> {
    private final Map<K, Value<V>> myEntries;
    private boolean myRememberNullValues;
    private long myAccesses;
    private long myHits;
    private final String myCacheName;
    @NotNull
    private final Value<V> myNullValue;

    public RecentEntriesCache(int maxEntries) {
        this("", maxEntries, false);
    }

    public RecentEntriesCache(int maxEntries, boolean rememberNullValues) {
        this("", maxEntries, rememberNullValues);
    }

    public RecentEntriesCache(@NotNull String cacheName, int maxEntries) {
        if (cacheName == null) {
            RecentEntriesCache.$$$reportNull$$$0(0);
        }
        this(cacheName, maxEntries, false);
    }

    public RecentEntriesCache(@NotNull String cacheName, int maxEntries, boolean rememberNullValues) {
        if (cacheName == null) {
            RecentEntriesCache.$$$reportNull$$$0(1);
        }
        this.myRememberNullValues = false;
        this.myAccesses = 0L;
        this.myHits = 0L;
        this.myNullValue = new Value(null);
        this.myCacheName = cacheName;
        this.myEntries = this.createCacheStorage(maxEntries);
        this.myRememberNullValues = rememberNullValues;
    }

    @NotNull
    protected Map<K, Value<V>> createCacheStorage(final int maxEntries) {
        LinkedHashMap linkedHashMap = new LinkedHashMap<K, Value<V>>(maxEntries, 0.8f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, Value<V>> eldest) {
                return this.size() > maxEntries;
            }
        };
        if (linkedHashMap == null) {
            RecentEntriesCache.$$$reportNull$$$0(2);
        }
        return linkedHashMap;
    }

    public synchronized int size() {
        return this.myEntries.size();
    }

    public synchronized boolean isEmpty() {
        return this.myEntries.isEmpty();
    }

    @Nullable
    public synchronized V get(@NotNull K key) {
        if (key == null) {
            RecentEntriesCache.$$$reportNull$$$0(3);
        }
        Value<V> val = this.myEntries.get(key);
        ++this.myAccesses;
        if (val == null) {
            return null;
        }
        ++this.myHits;
        return val.get();
    }

    @NotNull
    public synchronized Collection<V> getAll(@NotNull Collection<K> keys) {
        if (keys == null) {
            RecentEntriesCache.$$$reportNull$$$0(4);
        }
        ArrayList<V> res = new ArrayList<V>();
        for (K key : keys) {
            Value<V> val = this.myEntries.get(key);
            ++this.myAccesses;
            if (val == null) continue;
            ++this.myHits;
            res.add(val.get());
        }
        ArrayList<V> arrayList = res;
        if (arrayList == null) {
            RecentEntriesCache.$$$reportNull$$$0(5);
        }
        return arrayList;
    }

    public synchronized void put(@NotNull K key, V value) {
        if (key == null) {
            RecentEntriesCache.$$$reportNull$$$0(6);
        }
        if (!this.myRememberNullValues && value == null) {
            throw new NullPointerException("Null values are not accepted by this cache");
        }
        this.myEntries.put(key, value == null ? this.myNullValue : new Value(value));
    }

    @NotNull
    public synchronized Set<K> keySet() {
        LinkedHashSet<K> linkedHashSet = new LinkedHashSet<K>(this.myEntries.keySet());
        if (linkedHashSet == null) {
            RecentEntriesCache.$$$reportNull$$$0(7);
        }
        return linkedHashSet;
    }

    public synchronized void clear() {
        this.myEntries.clear();
    }

    public synchronized void remove(@NotNull K key) {
        if (key == null) {
            RecentEntriesCache.$$$reportNull$$$0(8);
        }
        this.myEntries.remove(key);
    }

    public synchronized void removeValues(@NotNull Filter<V> valueFilter) {
        if (valueFilter == null) {
            RecentEntriesCache.$$$reportNull$$$0(9);
        }
        Iterator<Map.Entry<K, Value<V>>> entryIt = this.myEntries.entrySet().iterator();
        while (entryIt.hasNext()) {
            Value<V> value = entryIt.next().getValue();
            if (value.get() == null || !valueFilter.accept(value.get())) continue;
            entryIt.remove();
        }
    }

    public synchronized void forEach(@NotNull ItemProcessor<V> processor) {
        if (processor == null) {
            RecentEntriesCache.$$$reportNull$$$0(10);
        }
        for (Value<V> value : this.myEntries.values()) {
            if (processor.processItem(value.get())) continue;
            return;
        }
    }

    public synchronized void forEachEntry(@NotNull BiItemProcessor<K, V> processor) {
        if (processor == null) {
            RecentEntriesCache.$$$reportNull$$$0(11);
        }
        for (Map.Entry<K, Value<V>> entry : this.myEntries.entrySet()) {
            Value<V> val;
            Object value;
            K key = entry.getKey();
            if (processor.process(key, value = (val = entry.getValue()) == null ? null : (Object)val.get())) continue;
            return;
        }
    }

    public synchronized Map<K, V> copyEntries() {
        HashMap<K, V> result = new HashMap<K, V>();
        for (Map.Entry<K, Value<V>> e : this.myEntries.entrySet()) {
            result.put(e.getKey(), e.getValue().get());
        }
        return result;
    }

    public synchronized V lookupOrCompute(@NotNull K key, @NotNull Function<K, V> compute) {
        V v;
        Value<V> val;
        if (key == null) {
            RecentEntriesCache.$$$reportNull$$$0(12);
        }
        if (compute == null) {
            RecentEntriesCache.$$$reportNull$$$0(13);
        }
        if ((val = this.myEntries.get(key)) == this.myNullValue) {
            return null;
        }
        V v2 = v = val == null ? null : (V)val.get();
        if (v != null) {
            return v;
        }
        v = compute.fun(key);
        if (v == null && !this.myRememberNullValues) {
            return null;
        }
        this.put(key, v);
        return v;
    }

    public synchronized float getHitRate() {
        return 1.0f * (float)this.myHits / (float)this.myAccesses;
    }

    public synchronized String toString() {
        StringBuilder descr = new StringBuilder();
        descr.append("Cache \"").append(this.myCacheName).append("\" ");
        descr.append("[size: ").append(this.myEntries.size()).append(", hit rate: ").append(this.getHitRate() * 100.0f).append("%]");
        return descr.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cacheName";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/util/RecentEntriesCache";
                break;
            }
            case 3: 
            case 6: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keys";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueFilter";
                break;
            }
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "compute";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/util/RecentEntriesCache";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createCacheStorage";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getAll";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "keySet";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAll";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "put";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "removeValues";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "forEach";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "forEachEntry";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "lookupOrCompute";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface BiItemProcessor<K, V> {
        public boolean process(K var1, V var2);
    }

    protected static class Value<V> {
        private final V myValue;

        private Value(V value) {
            this.myValue = value;
        }

        V get() {
            return this.myValue;
        }
    }

    public static interface Function<K, V> {
        public V fun(@NotNull K var1);
    }
}

