/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import com.intellij.openapi.diagnostic.Logger;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import jetbrains.buildServer.util.TCStreamUtil;
import org.jetbrains.annotations.NotNull;

public class RunCommand {
    @NotNull
    private static String streamToString(@NotNull InputStream stream) {
        if (stream == null) {
            RunCommand.$$$reportNull$$$0(0);
        }
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            TCStreamUtil.writeBinary(stream, bos);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            bos.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String string = bos.toString();
        if (string == null) {
            RunCommand.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void runCommand(@NotNull String command, @NotNull OutputProcessor processor) {
        if (command == null) {
            RunCommand.$$$reportNull$$$0(2);
        }
        if (processor == null) {
            RunCommand.$$$reportNull$$$0(3);
        }
        try {
            Process process = Runtime.getRuntime().exec(command);
            int exitCode = process.waitFor();
            processor.processExitCode(exitCode);
            processor.processOutput(RunCommand.streamToString(process.getInputStream()), RunCommand.streamToString(process.getErrorStream()));
        }
        catch (Exception e) {
            processor.processError(e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/util/RunCommand";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/util/RunCommand";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "streamToString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "streamToString";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "runCommand";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class LoggerOutputProcessor
    implements OutputProcessor {
        private final Logger myLogger;
        private final String myCommandTitle;

        public LoggerOutputProcessor(Logger logger, String commandTitle) {
            this.myLogger = logger;
            this.myCommandTitle = commandTitle;
        }

        @Override
        public void processOutput(@NotNull String stdout, @NotNull String stderr) {
            if (stdout == null) {
                LoggerOutputProcessor.$$$reportNull$$$0(0);
            }
            if (stderr == null) {
                LoggerOutputProcessor.$$$reportNull$$$0(1);
            }
            this.myLogger.info(this.myCommandTitle + " call: \n" + stdout + "\n" + stderr);
        }

        @Override
        public void processError(@NotNull Exception e) {
            if (e == null) {
                LoggerOutputProcessor.$$$reportNull$$$0(2);
            }
            this.myLogger.warn("Failed to start " + this.myCommandTitle + " command." + e.getMessage());
            this.myLogger.debug("Failed to start " + this.myCommandTitle + " command." + e.getMessage(), (Throwable)e);
        }

        @Override
        public void processExitCode(int code) {
            this.myLogger.info(this.myCommandTitle + " exit code:" + code);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stdout";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "stderr";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "jetbrains/buildServer/util/RunCommand$LoggerOutputProcessor";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processOutput";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "processError";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface OutputProcessor {
        public void processOutput(@NotNull String var1, @NotNull String var2);

        public void processError(@NotNull Exception var1);

        public void processExitCode(int var1);
    }
}

