/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;

public class SimpleObjectPool<T> {
    private final Queue<T> myPool;
    private final AtomicInteger myPoolSize;
    private final ObjectFactory<T> myFactory;
    private final int myMaxSize;

    public SimpleObjectPool(@NotNull ObjectFactory<T> factory, int maxSize) {
        if (factory == null) {
            SimpleObjectPool.$$$reportNull$$$0(0);
        }
        this.myPool = new ConcurrentLinkedQueue<T>();
        this.myPoolSize = new AtomicInteger();
        this.myFactory = factory;
        this.myMaxSize = maxSize;
        for (int i = 0; i < maxSize; ++i) {
            this.addToPool(factory.create());
        }
    }

    public T getFromPool() {
        T object = this.myPool.poll();
        if (object == null) {
            return this.myFactory.create();
        }
        this.myPoolSize.decrementAndGet();
        return object;
    }

    public void returnInPool(T object) {
        if (this.getPoolSize() < this.myMaxSize) {
            this.addToPool(object);
        }
    }

    int getPoolSize() {
        return this.myPoolSize.get();
    }

    int getQueueSize() {
        return this.myPool.size();
    }

    private void addToPool(T object) {
        this.myPool.add(object);
        this.myPoolSize.incrementAndGet();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "factory", "jetbrains/buildServer/util/SimpleObjectPool", "<init>"));
    }

    public static interface ObjectFactory<T> {
        @NotNull
        public T create();
    }
}

