/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import gnu.trove.map.hash.THashMap;
import gnu.trove.procedure.TObjectObjectProcedure;
import gnu.trove.procedure.TObjectProcedure;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jetbrains.buildServer.util.ItemProcessor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SoftValueHashMap<K, V>
implements Map<K, V> {
    private final THashMap<K, MyReference<K, V>> myMap;
    private final ReferenceQueue<MyReference<K, V>> myQueue = new ReferenceQueue();

    public SoftValueHashMap() {
        this.myMap = new THashMap();
    }

    public SoftValueHashMap(int initialCapacity, float loadFactor) {
        this.myMap = new THashMap(initialCapacity, loadFactor);
    }

    private void processQueue() {
        MyReference ref;
        while ((ref = (MyReference)this.myQueue.poll()) != null) {
            if (this.myMap.get(ref.myKey) != ref) continue;
            this.myMap.remove(ref.myKey);
            this.afterRemove(ref.myKey, ref.get());
        }
        return;
    }

    protected void afterRemove(K key, @Nullable V val) {
    }

    protected void afterPut(K key, V val) {
    }

    @Override
    public V get(Object key) {
        MyReference ref = (MyReference)this.myMap.get(key);
        if (ref == null) {
            return null;
        }
        return (V)ref.get();
    }

    @Override
    public V put(K key, V value) {
        this.processQueue();
        MyReference oldRef = (MyReference)this.myMap.put(key, new MyReference<K, V>(key, value, this.myQueue));
        if (oldRef != null) {
            this.afterRemove(oldRef.myKey, oldRef.get());
        }
        this.afterPut(key, value);
        return oldRef != null ? (V)oldRef.get() : null;
    }

    @Override
    public V remove(Object key) {
        this.processQueue();
        MyReference ref = (MyReference)this.myMap.remove(key);
        if (ref != null) {
            this.afterRemove(ref.myKey, ref.get());
        }
        return ref != null ? (V)ref.get() : null;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) {
        throw new RuntimeException("method not implemented");
    }

    @Override
    public void clear() {
        for (K key : this.keySet()) {
            this.afterRemove(key, null);
        }
        this.myMap.clear();
    }

    @Override
    public int size() {
        return this.myMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.myMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.get(key) != null;
    }

    @Override
    public boolean containsValue(Object value) {
        throw new RuntimeException("method not implemented");
    }

    @Override
    @NotNull
    public Set<K> keySet() {
        Set set = this.myMap.keySet();
        if (set == null) {
            SoftValueHashMap.$$$reportNull$$$0(0);
        }
        return set;
    }

    @Override
    @NotNull
    public Collection<V> values() {
        HashSet values = new HashSet(this.size());
        for (MyReference ref : this.myMap.values()) {
            Object val = ref.get();
            if (val == null) continue;
            values.add(val);
        }
        HashSet hashSet = values;
        if (hashSet == null) {
            SoftValueHashMap.$$$reportNull$$$0(1);
        }
        return hashSet;
    }

    @Override
    @NotNull
    public Set<Map.Entry<K, V>> entrySet() {
        final HashSet<Map.Entry<K, V>> entries = new HashSet<Map.Entry<K, V>>(this.size());
        this.myMap.forEachEntry(new TObjectObjectProcedure<K, MyReference<K, V>>(){

            public boolean execute(K k, MyReference<K, V> kvMyReference) {
                Object val = kvMyReference.get();
                if (val != null) {
                    entries.add(new AbstractMap.SimpleEntry(k, val));
                }
                return true;
            }
        });
        HashSet<Map.Entry<K, V>> hashSet = entries;
        if (hashSet == null) {
            SoftValueHashMap.$$$reportNull$$$0(2);
        }
        return hashSet;
    }

    public void forEachValue(final @NotNull ItemProcessor<V> processor) {
        if (processor == null) {
            SoftValueHashMap.$$$reportNull$$$0(3);
        }
        this.myMap.forEachValue(new TObjectProcedure<MyReference<K, V>>(){

            public boolean execute(MyReference<K, V> ref) {
                Object obj = ref.get();
                if (obj != null) {
                    return processor.processItem(obj);
                }
                return true;
            }
        });
    }

    public void compactIfNecessary(int capacityToSizeMultiplier) {
        if (this.myMap.capacity() > capacityToSizeMultiplier * this.myMap.size()) {
            this.myMap.compact();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/util/SoftValueHashMap";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "keySet";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "values";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "entrySet";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/util/SoftValueHashMap";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "forEachValue";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyReference<K, V>
    extends SoftReference<V> {
        private final K myKey;

        public MyReference(K key, V referent, ReferenceQueue q) {
            super(referent, q);
            this.myKey = key;
        }
    }
}

