/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;

public class SortedProperties
extends Properties {
    private static final Comparator<Object> COMPARATOR = new Comparator<Object>(){

        @Override
        public int compare(Object o1, Object o2) {
            return o1.toString().compareToIgnoreCase(o2.toString());
        }
    };

    @Override
    public Enumeration<Object> keys() {
        Enumeration<Object> keys = super.keys();
        Vector<Object> keysList = new Vector<Object>();
        while (keys.hasMoreElements()) {
            keysList.add(keys.nextElement());
        }
        Collections.sort(keysList, COMPARATOR);
        return keysList.elements();
    }

    @Override
    public Set<String> stringPropertyNames() {
        TreeSet<Object> res = new TreeSet<Object>(COMPARATOR);
        res.addAll(super.stringPropertyNames());
        return res;
    }

    @Override
    public Set<Object> keySet() {
        TreeSet<Object> set = new TreeSet<Object>(COMPARATOR);
        set.addAll(super.keySet());
        return set;
    }

    @Override
    public Set<Map.Entry<Object, Object>> entrySet() {
        TreeSet<Map.Entry<Object, Object>> set = new TreeSet<Map.Entry<Object, Object>>(new Comparator<Map.Entry<Object, Object>>(){

            @Override
            public int compare(Map.Entry<Object, Object> o1, Map.Entry<Object, Object> o2) {
                return COMPARATOR.compare(o1.getKey(), o2.getKey());
            }
        });
        set.addAll(super.entrySet());
        return set;
    }
}

