/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringPoolInstance {
    private static final String JAVA_SPEC_VERSION = System.getProperty("java.specification.version");
    private static final boolean OUR_USE_STRING_INTERN = !"1.6".equals(JAVA_SPEC_VERSION) && !"1.5".equals(JAVA_SPEC_VERSION) && !"1.4".equals(JAVA_SPEC_VERSION);
    private final int myCacheSize;
    private final ConcurrentMap<String, String> myPooledStrings;

    public StringPoolInstance(int cacheSize) {
        this.myCacheSize = cacheSize;
        this.myPooledStrings = new ConcurrentHashMap<String, String>(cacheSize);
    }

    @Nullable
    @Contract(value="null->null;!null->!null")
    public String getFromPool(@Nullable String value) {
        if (value == null) {
            return null;
        }
        return this.reuse(value);
    }

    @NotNull
    public String reuse(@NotNull String value) {
        String res;
        if (value == null) {
            StringPoolInstance.$$$reportNull$$$0(0);
        }
        if ((res = (String)this.myPooledStrings.get(value)) != null) {
            String string = res;
            if (string == null) {
                StringPoolInstance.$$$reportNull$$$0(1);
            }
            return string;
        }
        res = value;
        if (OUR_USE_STRING_INTERN) {
            res = value.intern();
            if (this.myPooledStrings.size() > this.myCacheSize) {
                this.myPooledStrings.clear();
            }
        }
        this.myPooledStrings.putIfAbsent(res, res);
        String string = res;
        if (string == null) {
            StringPoolInstance.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void clearPool() {
        this.myPooledStrings.clear();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/util/StringPoolInstance";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/util/StringPoolInstance";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "reuse";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "reuse";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

