/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.CharFilter;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.text.StringCharacterIterator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jetbrains.buildServer.log.Loggers;
import jetbrains.buildServer.messages.serviceMessages.MapSerializerUtil;
import jetbrains.buildServer.parameters.ReferencesResolverUtil;
import jetbrains.buildServer.util.RandomGenerator;
import jetbrains.buildServer.util.StringUtils;
import jetbrains.buildServer.util.filters.Filter;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StringUtil
extends com.intellij.openapi.util.text.StringUtil {
    public static final char[] DEFAULT_SEPARATORS = new char[]{' ', ',', '\n', '\r', '\t', ';'};
    public static final String EMPTY = "";
    @NonNls
    public static final String NA = "N/A";
    public static final Filter<String> NOT_EMPTY_STRING_FILTER = data -> !data.isEmpty();
    private static final String DEFAULT_DATE_FORMAT = "dd MMM yy HH:mm";
    public static final long KB = 1024L;
    public static final long MB = 0x100000L;
    public static final long GB = 0x40000000L;
    public static final long TB = 0x10000000000L;
    public static final String B_POSTFIX = " B";
    public static final String KB_POSTFIX = " KB";
    public static final String MB_POSTFIX = " MB";
    public static final String GB_POSTFIX = " GB";
    public static final String TB_POSTFIX = " TB";
    public static final String ENABLE_LEGACY_URL_ENCODING_PROPERTY = "teamcity.internal.legacyUrlEncoding.enable";
    private static final RandomGenerator myRandom = new RandomGenerator();
    @Deprecated
    public static final EscapeInfoProvider STD_ESCAPER = new EscapeInfoProvider(){

        public char escape(char c) {
            return MapSerializerUtil.STD_ESCAPER.escape(c);
        }

        public char unescape(char c) {
            return MapSerializerUtil.STD_ESCAPER.unescape(c);
        }

        public char escapeCharacter() {
            return MapSerializerUtil.STD_ESCAPER.escapeCharacter();
        }
    };
    public static final EscapeInfoProvider2 STD_ESCAPER2 = new EscapeInfoProvider2(){

        @Nullable
        public String escape(char c) {
            return MapSerializerUtil.STD_ESCAPER2.escape(c);
        }

        @Nullable
        public MapSerializerUtil.UnescapeResult unescape(@NotNull String str, int startPos) {
            if (str == null) {
                2.$$$reportNull$$$0(0);
            }
            return MapSerializerUtil.STD_ESCAPER2.unescape(str, startPos);
        }

        public char escapeCharacter() {
            return MapSerializerUtil.STD_ESCAPER2.escapeCharacter();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "jetbrains/buildServer/util/StringUtil$2", "unescape"));
        }
    };

    private StringUtil() {
    }

    @Contract(value="null, null -> true")
    public static boolean areEqual(@Nullable String string1, @Nullable String string2) {
        return string1 == string2 || string1 != null && string1.equals(string2);
    }

    @Contract(value="null, null -> true")
    public static boolean areEqualIgnoringCase(@Nullable String string1, @Nullable String string2) {
        return string1 == string2 || string1 != null && string1.equalsIgnoreCase(string2);
    }

    public static boolean differCaseOnly(@NotNull String string1, @NotNull String string2) {
        if (string1 == null) {
            StringUtil.$$$reportNull$$$0(0);
        }
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(1);
        }
        return string1.equalsIgnoreCase(string2) && !string1.equals(string2);
    }

    public static boolean isUpperCase(@NotNull String str) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(2);
        }
        boolean hasUppercaseLetters = false;
        int n = str.length();
        for (int i = 0; i < n; ++i) {
            char c = str.charAt(i);
            hasUppercaseLetters |= Character.isUpperCase(c);
            if (!Character.isLowerCase(c)) continue;
            return false;
        }
        return hasUppercaseLetters;
    }

    @NotNull
    public static String escapeHTML(@Nullable String text, boolean replaceQuotes) {
        if (text == null) {
            if (EMPTY == null) {
                StringUtil.$$$reportNull$$$0(3);
            }
            return EMPTY;
        }
        StringBuilder result = new StringBuilder();
        StringCharacterIterator iterator = new StringCharacterIterator(text);
        char character = iterator.current();
        while (character != '\uffff') {
            if (character == '<') {
                result.append("&lt;");
            } else if (character == '>') {
                result.append("&gt;");
            } else if (character == '\"' && replaceQuotes) {
                result.append("&quot;");
            } else if (character == '\'' && replaceQuotes) {
                result.append("&#039;");
            } else if (character == '\\') {
                result.append("&#092;");
            } else if (character == '&') {
                result.append("&amp;");
            } else {
                result.append(character);
            }
            character = iterator.next();
        }
        String string = result.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(4);
        }
        return string;
    }

    @NotNull
    public static List<String> splitCommandArgumentsAndUnquote(@NotNull String line) {
        if (line == null) {
            StringUtil.$$$reportNull$$$0(5);
        }
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        boolean inQuotes = false;
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (Character.isWhitespace(c) && !inQuotes) {
                if (builder.length() <= 0) continue;
                result.add(builder.toString());
                builder.setLength(0);
                continue;
            }
            if ((c == '\"' || c == '\'') && StringUtil.isNotEscapedQuote(line, i)) {
                inQuotes = !inQuotes;
            }
            builder.append(c);
        }
        if (builder.length() > 0) {
            result.add(builder.toString());
        }
        List<String> list = StringUtil.removeQuotes(result);
        if (list == null) {
            StringUtil.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    private static List<String> removeQuotes(@NotNull List<String> result) {
        if (result == null) {
            StringUtil.$$$reportNull$$$0(7);
        }
        for (int i = 0; i < result.size(); ++i) {
            String value = StringUtil.unquoteString((String)result.get(i));
            result.set(i, value);
        }
        List<String> list = result;
        if (list == null) {
            StringUtil.$$$reportNull$$$0(8);
        }
        return list;
    }

    private static boolean isNotEscapedQuote(@NotNull String line, int i) {
        if (line == null) {
            StringUtil.$$$reportNull$$$0(9);
        }
        if (i == 0) {
            return true;
        }
        if (line.charAt(i - 1) == '\\') {
            int j;
            for (j = i + 1; j < line.length(); ++j) {
                if (Character.isWhitespace(line.charAt(j))) continue;
                return line.charAt(j) == '-' || line.charAt(j) == '\"' && j + 1 < line.length() && line.charAt(j + 1) == '-';
            }
            return j == line.length();
        }
        return true;
    }

    @NotNull
    public static String biteOffPostfix(@NotNull String line, @NotNull String postfix) {
        if (line == null) {
            StringUtil.$$$reportNull$$$0(10);
        }
        if (postfix == null) {
            StringUtil.$$$reportNull$$$0(11);
        }
        String string = line.substring(0, line.length() - postfix.length());
        if (string == null) {
            StringUtil.$$$reportNull$$$0(12);
        }
        return string;
    }

    @NotNull
    public static String lastPartOf(@NotNull String s, char separator) {
        int i;
        if (s == null) {
            StringUtil.$$$reportNull$$$0(13);
        }
        if ((i = s.lastIndexOf(separator)) >= 0) {
            String string = s.substring(i + 1);
            if (string == null) {
                StringUtil.$$$reportNull$$$0(14);
            }
            return string;
        }
        String string = s;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(15);
        }
        return string;
    }

    @Nullable
    @Contract(value="null, _ -> null; !null, _ -> !null")
    public static String truncateStringValue(@Nullable String str, int maxLength) {
        if (str == null) {
            return null;
        }
        if (maxLength < 0) {
            throw new IllegalArgumentException("The 'maxLength' parameter must not be negative.");
        }
        int n = str.length();
        return n <= maxLength ? str : str.substring(0, maxLength);
    }

    @Nullable
    @Contract(value="null, _ -> null; !null, _ -> !null")
    public static String truncateStringValueWithDotsAtEnd(@Nullable String str, int maxLength) {
        if (str == null) {
            return null;
        }
        if (str.length() > maxLength) {
            return str.substring(0, maxLength - 3) + "...";
        }
        return str;
    }

    @Nullable
    @Contract(value="null, _ -> null; !null, _ -> !null")
    public static String truncateStringValueWithDotsAtCenter(@Nullable String str, int maxLength) {
        if (str == null) {
            return null;
        }
        if (str.length() > maxLength) {
            String start = str.substring(0, maxLength / 2);
            String dots = "...";
            String end = str.substring(str.length() - maxLength + start.length() + dots.length());
            return start + dots + end;
        }
        return str;
    }

    public static boolean isValidXMLChar(char c) {
        switch (c) {
            case '\t': 
            case '\n': 
            case '\r': {
                return true;
            }
        }
        return ' ' <= c && c <= '\ud7ff' || '\ue000' <= c && c <= '\ufffd' || '\u10000' <= c && c <= '\u10ffff';
    }

    public static int findInvalidXMLChar(@NotNull String value) {
        if (value == null) {
            StringUtil.$$$reportNull$$$0(16);
        }
        char[] chars = value.toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (StringUtil.isValidXMLChar(chars[i])) continue;
            return i;
        }
        return -1;
    }

    @NotNull
    public static String replaceInvalidXmlChars(@NotNull String str) {
        int firstInvalid;
        if (str == null) {
            StringUtil.$$$reportNull$$$0(17);
        }
        if ((firstInvalid = StringUtil.findInvalidXMLChar(str)) > -1) {
            int len = str.length();
            StringBuilder sb = new StringBuilder(len);
            sb.append(str, 0, firstInvalid);
            for (int i = firstInvalid; i < len; ++i) {
                char c = str.charAt(i);
                sb.append(StringUtil.isValidXMLChar(c) ? c : (char)' ');
            }
            String string = sb.toString();
            if (string == null) {
                StringUtil.$$$reportNull$$$0(18);
            }
            return string;
        }
        String string = str;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(19);
        }
        return string;
    }

    @NotNull
    public static String generateUniqueHash() {
        String string = StringUtil.generateUniqueHash(myRandom.getRandom());
        if (string == null) {
            StringUtil.$$$reportNull$$$0(20);
        }
        return string;
    }

    @NotNull
    public static String generateUniqueHashQuickly() {
        String string = StringUtil.generateUniqueHash(new Random(System.nanoTime()));
        if (string == null) {
            StringUtil.$$$reportNull$$$0(21);
        }
        return string;
    }

    @NotNull
    private static String generateUniqueHash(@NotNull Random random) {
        if (random == null) {
            StringUtil.$$$reportNull$$$0(22);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 32; ++i) {
            int rand;
            sb.append((char)(rand += (rand = (int)(random.nextDouble() * 62.0)) < 10 ? 48 : (rand < 36 ? 55 : 61)));
        }
        String string = sb.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(23);
        }
        return string;
    }

    @NotNull
    public static Pattern searchByKeywordPattern(@NotNull String keyword, boolean caseInsensitive) {
        if (keyword == null) {
            StringUtil.$$$reportNull$$$0(24);
        }
        String escapedKeyword = StringUtil.escapeForRegex(keyword);
        int flags = 0;
        if (caseInsensitive) {
            flags = 66;
        }
        Pattern pattern = Pattern.compile(".*\\b" + escapedKeyword + ".*", flags);
        if (pattern == null) {
            StringUtil.$$$reportNull$$$0(25);
        }
        return pattern;
    }

    @NotNull
    public static String escapeForRegex(@NotNull String str) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(26);
        }
        String string = Pattern.quote(str);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(27);
        }
        return string;
    }

    private static boolean mustEscapeInRegexp(char c) {
        switch (c) {
            case '$': 
            case '(': 
            case ')': 
            case '*': 
            case '+': 
            case '.': 
            case '?': 
            case '[': 
            case '\\': 
            case ']': 
            case '{': 
            case '}': {
                return true;
            }
        }
        return false;
    }

    @NotNull
    public static String convertWildcardToRegexp(@NotNull String pattern) {
        if (pattern == null) {
            StringUtil.$$$reportNull$$$0(28);
        }
        StringBuilder result = new StringBuilder();
        block4: for (int i = 0; i < pattern.length(); ++i) {
            char c = pattern.charAt(i);
            switch (c) {
                case '*': {
                    result.append(".*");
                    continue block4;
                }
                case '?': {
                    result.append(".");
                    continue block4;
                }
                default: {
                    if (StringUtil.mustEscapeInRegexp(c)) {
                        result.append('\\');
                    }
                    result.append(c);
                }
            }
        }
        String string = result.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(29);
        }
        return string;
    }

    @NotNull
    public static List<String> split(@NotNull String values) {
        if (values == null) {
            StringUtil.$$$reportNull$$$0(30);
        }
        List<String> list = StringUtil.split(values.trim(), true, DEFAULT_SEPARATORS);
        if (list == null) {
            StringUtil.$$$reportNull$$$0(31);
        }
        return list;
    }

    @NotNull
    public static List<String> split(@NotNull String values, boolean removeEmpty, char ... separators) {
        if (values == null) {
            StringUtil.$$$reportNull$$$0(32);
        }
        if (separators == null) {
            StringUtil.$$$reportNull$$$0(33);
        }
        ArrayList<String> result = new ArrayList<String>();
        if (values.isEmpty()) {
            ArrayList<String> arrayList = result;
            if (arrayList == null) {
                StringUtil.$$$reportNull$$$0(34);
            }
            return arrayList;
        }
        boolean hasSeparator = false;
        char[] currentWord = new char[values.length()];
        int currentEndPosition = 0;
        for (int i = 0; i < values.length(); ++i) {
            char currentChar = values.charAt(i);
            if (StringUtil.isSeparator(currentChar, separators)) {
                hasSeparator = true;
                if (!removeEmpty || currentEndPosition > 0) {
                    result.add(new String(currentWord, 0, currentEndPosition));
                }
                currentEndPosition = 0;
                continue;
            }
            currentWord[currentEndPosition] = currentChar;
            ++currentEndPosition;
        }
        if (!hasSeparator) {
            result.add(values);
        } else if (currentEndPosition > 0) {
            result.add(new String(currentWord, 0, currentEndPosition));
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            StringUtil.$$$reportNull$$$0(35);
        }
        return arrayList;
    }

    private static boolean isSeparator(char currentChar, @NotNull char[] separators) {
        if (separators == null) {
            StringUtil.$$$reportNull$$$0(36);
        }
        for (char separator : separators) {
            if (currentChar != separator) continue;
            return true;
        }
        return false;
    }

    @Contract(value="null -> false")
    public static boolean isAPositiveNumber(@Nullable String value) {
        if (value == null) {
            return false;
        }
        try {
            int intValue = Integer.parseInt(value);
            return intValue > 0;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @Contract(value="null -> false")
    public static boolean isNumber(@Nullable String value) {
        if (value == null) {
            return false;
        }
        try {
            Integer.parseInt(value);
            return true;
        }
        catch (NumberFormatException e) {
            return false;
        }
    }

    @NotNull
    public static String getOrdinal(int number) {
        String txt;
        int remains = number - 10 * (number / 10);
        switch (remains) {
            case 1: {
                txt = "st";
                break;
            }
            case 2: {
                txt = "nd";
                break;
            }
            case 3: {
                txt = "rd";
                break;
            }
            default: {
                txt = "th";
            }
        }
        String string = txt;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(37);
        }
        return string;
    }

    @NotNull
    public static String stackTrace(@NotNull Throwable exception) {
        if (exception == null) {
            StringUtil.$$$reportNull$$$0(38);
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        PrintStream printStream = new PrintStream(buffer);
        exception.printStackTrace(printStream);
        printStream.close();
        String string = buffer.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(39);
        }
        return string;
    }

    @NotNull
    public static String join(@Nullable String separator, @NotNull Iterable toJoin) {
        if (toJoin == null) {
            StringUtil.$$$reportNull$$$0(40);
        }
        StringBuilder result = new StringBuilder();
        StringUtil.join(separator, toJoin, result);
        String string = result.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(41);
        }
        return string;
    }

    public static void join(@Nullable String separator, @NotNull Iterable toJoin, @NotNull StringBuilder result) {
        if (toJoin == null) {
            StringUtil.$$$reportNull$$$0(42);
        }
        if (result == null) {
            StringUtil.$$$reportNull$$$0(43);
        }
        if (separator == null) {
            separator = EMPTY;
        }
        Iterator it = toJoin.iterator();
        while (it.hasNext()) {
            Object item = it.next();
            if (item == null) continue;
            result.append(item);
            if (!it.hasNext()) continue;
            result.append(separator);
        }
    }

    @NotNull
    public static String join(@Nullable String separator, Object ... toJoin) {
        if (toJoin == null) {
            StringUtil.$$$reportNull$$$0(44);
        }
        String string = StringUtil.join(separator, Arrays.asList(toJoin));
        if (string == null) {
            StringUtil.$$$reportNull$$$0(45);
        }
        return string;
    }

    @NotNull
    public static String doubleQuote(@NotNull String string) {
        if (string == null) {
            StringUtil.$$$reportNull$$$0(46);
        }
        String string2 = '\"' + string + '\"';
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(47);
        }
        return string2;
    }

    public static Iterator<String> createEscapedTokenizer(String string, char del) {
        return new MyTokenizerIterator(string, del);
    }

    @Deprecated
    public static int indexOf(String currentString, char findWhat, EscapeInfoProvider escaper) {
        return MapSerializerUtil.indexOf((String)currentString, (char)findWhat, (MapSerializerUtil.EscapeInfoProvider)escaper);
    }

    public static int indexOf(String currentString, char findWhat, EscapeInfoProvider2 escaper) {
        return MapSerializerUtil.indexOf((String)currentString, (char)findWhat, (MapSerializerUtil.EscapeInfoProvider2)escaper);
    }

    @Deprecated
    @NotNull
    public static Map<String, String> stringToProperties(@NotNull String string, @NotNull EscapeInfoProvider escaper) throws ParseException {
        if (string == null) {
            StringUtil.$$$reportNull$$$0(48);
        }
        if (escaper == null) {
            StringUtil.$$$reportNull$$$0(49);
        }
        Map<String, String> map = StringUtil.stringToProperties(string, escaper, true);
        if (map == null) {
            StringUtil.$$$reportNull$$$0(50);
        }
        return map;
    }

    @NotNull
    public static Map<String, String> stringToProperties(@NotNull String string, @NotNull EscapeInfoProvider2 escaper) throws ParseException {
        if (string == null) {
            StringUtil.$$$reportNull$$$0(51);
        }
        if (escaper == null) {
            StringUtil.$$$reportNull$$$0(52);
        }
        Map<String, String> map = StringUtil.stringToProperties(string, escaper, true);
        if (map == null) {
            StringUtil.$$$reportNull$$$0(53);
        }
        return map;
    }

    @Deprecated
    @NotNull
    public static Map<String, String> stringToProperties(@NotNull String string, @NotNull EscapeInfoProvider escaper, boolean strictNameCheck) throws ParseException {
        if (string == null) {
            StringUtil.$$$reportNull$$$0(54);
        }
        if (escaper == null) {
            StringUtil.$$$reportNull$$$0(55);
        }
        Map map = MapSerializerUtil.stringToProperties((String)string, (MapSerializerUtil.EscapeInfoProvider)escaper, (boolean)strictNameCheck);
        if (map == null) {
            StringUtil.$$$reportNull$$$0(56);
        }
        return map;
    }

    @NotNull
    public static Map<String, String> stringToProperties(@NotNull String string, @NotNull EscapeInfoProvider2 escaper, boolean strictNameCheck) throws ParseException {
        if (string == null) {
            StringUtil.$$$reportNull$$$0(57);
        }
        if (escaper == null) {
            StringUtil.$$$reportNull$$$0(58);
        }
        Map map = MapSerializerUtil.stringToProperties((String)string, (MapSerializerUtil.EscapeInfoProvider2)escaper, (boolean)strictNameCheck);
        if (map == null) {
            StringUtil.$$$reportNull$$$0(59);
        }
        return map;
    }

    @Deprecated
    public static String propertiesToString(Map<String, String> props, EscapeInfoProvider escaper) {
        return MapSerializerUtil.propertiesToString(props, (MapSerializerUtil.EscapeInfoProvider)escaper);
    }

    public static String propertiesToString(Map<String, String> props, EscapeInfoProvider2 escaper) {
        return MapSerializerUtil.propertiesToString(props, (MapSerializerUtil.EscapeInfoProvider2)escaper);
    }

    public static String repeat(String whatRepeat, String separator, int times) {
        StringBuilder result = new StringBuilder();
        StringUtil.repeat(whatRepeat, separator, times, result);
        return result.toString();
    }

    public static void repeat(String whatRepeat, String separator, int times, StringBuilder builder) {
        for (int i = 0; i < times; ++i) {
            if (i > 0) {
                builder.append(separator);
            }
            builder.append(whatRepeat);
        }
    }

    @Contract(value="null -> false")
    public static boolean isTrue(@Nullable String property) {
        return Boolean.parseBoolean(property) || "yes".equalsIgnoreCase(property);
    }

    public static String escapeQuotesIfWindows(String value) {
        return SystemInfo.isWindows ? StringUtil.escapeQuotes((String)value) : value;
    }

    public static void convertStringsToLowerCase(@NotNull List<String> strings) {
        if (strings == null) {
            StringUtil.$$$reportNull$$$0(60);
        }
        ListIterator<String> it = strings.listIterator();
        while (it.hasNext()) {
            String lower;
            String orig = it.next();
            if (orig == null || orig.equals(lower = orig.toLowerCase())) continue;
            it.set(lower);
        }
    }

    @Nullable
    @Contract(value="null->null;!null->!null")
    public static String removeTailingSlash(@Nullable String path) {
        return path != null ? StringUtil.removeSuffix(path, "/", true) : null;
    }

    public static String removeSuffix(@NotNull String string, @NotNull String suffix, boolean caseSensitive) {
        int m;
        int n;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(61);
        }
        if (suffix == null) {
            StringUtil.$$$reportNull$$$0(62);
        }
        if ((n = string.length()) < (m = suffix.length())) {
            return string;
        }
        boolean toRemove = caseSensitive ? string.endsWith(suffix) : string.substring(n - m).equalsIgnoreCase(suffix);
        return toRemove ? string.substring(0, n - m) : string;
    }

    @Nullable
    @Contract(value="null->null;!null->!null")
    public static String removeLeadingSlash(@Nullable String path) {
        return path != null && path.startsWith("/") ? path.substring(1) : path;
    }

    @Nullable
    @Contract(value="null->null;!null->!null")
    public static String removeLeadingAndTailingSlash(@Nullable String path) {
        return StringUtil.removeLeadingSlash(StringUtil.removeTailingSlash(path));
    }

    public static void replace(@NotNull StringBuilder buf, @NotNull String what, @NotNull String with) {
        if (buf == null) {
            StringUtil.$$$reportNull$$$0(63);
        }
        if (what == null) {
            StringUtil.$$$reportNull$$$0(64);
        }
        if (with == null) {
            StringUtil.$$$reportNull$$$0(65);
        }
        int pos = buf.indexOf(what);
        int n = what.length();
        int m = with.length();
        while (pos >= 0) {
            buf.replace(pos, pos + n, with);
            pos = buf.indexOf(what, pos + m);
        }
    }

    public static void replace(@NotNull StringBuilder buf, @NotNull Pattern pattern, @NotNull String with) {
        if (buf == null) {
            StringUtil.$$$reportNull$$$0(66);
        }
        if (pattern == null) {
            StringUtil.$$$reportNull$$$0(67);
        }
        if (with == null) {
            StringUtil.$$$reportNull$$$0(68);
        }
        Matcher matcher = pattern.matcher(buf);
        boolean found = matcher.find();
        while (found) {
            int p1 = matcher.start();
            int p2 = matcher.end();
            buf.replace(p1, p2, with);
            found = matcher.find(p1 + with.length());
        }
    }

    public static int compare(@Nullable String s1, @Nullable String s2) {
        if (s1 == s2) {
            return 0;
        }
        if (s1 == null) {
            return -1;
        }
        if (s2 == null) {
            return 1;
        }
        return s1.compareTo(s2);
    }

    @NotNull
    public static String convertAndCollapseSlashes(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(69);
        }
        StringBuilder sb = new StringBuilder(s.length());
        boolean prevIsSlash = false;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == '\\' || c == '/') {
                if (!prevIsSlash) {
                    sb.append('/');
                }
                prevIsSlash = true;
                continue;
            }
            sb.append(c);
            prevIsSlash = false;
        }
        String string = sb.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(70);
        }
        return string;
    }

    public static void processLines(@NotNull String str, @NotNull LineProcessor processor) throws IOException {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(71);
        }
        if (processor == null) {
            StringUtil.$$$reportNull$$$0(72);
        }
        try (BufferedReader reader = new BufferedReader(new StringReader(str));){
            StringUtil.processLines(reader, processor);
        }
    }

    private static void processLines(@NotNull BufferedReader reader, @NotNull LineProcessor processor) throws IOException {
        String line;
        if (reader == null) {
            StringUtil.$$$reportNull$$$0(73);
        }
        if (processor == null) {
            StringUtil.$$$reportNull$$$0(74);
        }
        while ((line = reader.readLine()) != null) {
            if (!processor.processLine(line)) continue;
            return;
        }
    }

    @NotNull
    public static String formatPercent(float numerator, long denominator) {
        if (denominator == 0L || numerator == 0.0f) {
            if ("0%" == null) {
                StringUtil.$$$reportNull$$$0(75);
            }
            return "0%";
        }
        long percent = Math.round(100.0 * (double)numerator / (double)denominator);
        if (percent == 0L) {
            if ("<1%" == null) {
                StringUtil.$$$reportNull$$$0(76);
            }
            return "<1%";
        }
        String string = percent + "%";
        if (string == null) {
            StringUtil.$$$reportNull$$$0(77);
        }
        return string;
    }

    @NotNull
    public static String formatFileSize(File file) {
        String string = StringUtil.formatFileSize(file.length());
        if (string == null) {
            StringUtil.$$$reportNull$$$0(78);
        }
        return string;
    }

    @NotNull
    public static String formatFileSize(long fileSize) {
        String string = StringUtil.formatFileSize(fileSize, 2);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(79);
        }
        return string;
    }

    @NotNull
    public static String formatFileSize(long fileSize, int maxFractionDigits) {
        DecimalFormat f = (DecimalFormat)NumberFormat.getNumberInstance(Locale.ENGLISH);
        f.setGroupingUsed(false);
        f.setRoundingMode(RoundingMode.FLOOR);
        f.setMaximumFractionDigits(maxFractionDigits);
        if (fileSize >= 0x10000000000L) {
            String string = f.format((double)fileSize / 1.099511627776E12) + TB_POSTFIX;
            if (string == null) {
                StringUtil.$$$reportNull$$$0(80);
            }
            return string;
        }
        if (fileSize >= 0x40000000L) {
            String string = f.format((double)fileSize / 1.073741824E9) + GB_POSTFIX;
            if (string == null) {
                StringUtil.$$$reportNull$$$0(81);
            }
            return string;
        }
        if (fileSize >= 0x100000L) {
            String string = f.format((double)fileSize / 1048576.0) + MB_POSTFIX;
            if (string == null) {
                StringUtil.$$$reportNull$$$0(82);
            }
            return string;
        }
        if (fileSize >= 1024L) {
            String string = f.format((double)fileSize / 1024.0) + KB_POSTFIX;
            if (string == null) {
                StringUtil.$$$reportNull$$$0(83);
            }
            return string;
        }
        String string = fileSize + B_POSTFIX;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(84);
        }
        return string;
    }

    public static long parseFileSize(@NotNull String fileSizeStr) throws NumberFormatException {
        String value;
        if (fileSizeStr == null) {
            StringUtil.$$$reportNull$$$0(85);
        }
        if ((value = fileSizeStr.replace(" ", EMPTY).trim().toLowerCase()).length() >= 3) {
            if (value.endsWith("kb")) {
                return StringUtil.parseFileSize(value.substring(0, value.length() - 2)) * 1024L;
            }
            if (value.endsWith("mb")) {
                return StringUtil.parseFileSize(value.substring(0, value.length() - 2)) * 0x100000L;
            }
            if (value.endsWith("gb")) {
                return StringUtil.parseFileSize(value.substring(0, value.length() - 2)) * 0x40000000L;
            }
            if (value.endsWith("tb")) {
                return StringUtil.parseFileSize(value.substring(0, value.length() - 2)) * 0x10000000000L;
            }
        }
        if (value.length() >= 4) {
            if (value.endsWith("kib")) {
                return StringUtil.parseFileSize(value.substring(0, value.length() - 3)) * 1024L;
            }
            if (value.endsWith("mib")) {
                return StringUtil.parseFileSize(value.substring(0, value.length() - 3)) * 0x100000L;
            }
            if (value.endsWith("gib")) {
                return StringUtil.parseFileSize(value.substring(0, value.length() - 3)) * 0x40000000L;
            }
            if (value.endsWith("tib")) {
                return StringUtil.parseFileSize(value.substring(0, value.length() - 3)) * 0x10000000000L;
            }
        }
        return Long.parseLong(fileSizeStr);
    }

    public static void processLines(@NotNull InputStream in, @NotNull LineProcessor processor) throws IOException {
        if (in == null) {
            StringUtil.$$$reportNull$$$0(86);
        }
        if (processor == null) {
            StringUtil.$$$reportNull$$$0(87);
        }
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(in));){
            StringUtil.processLines(reader, processor);
        }
    }

    public static void processLines(@NotNull File file, @NotNull LineProcessor processor) throws IOException {
        if (file == null) {
            StringUtil.$$$reportNull$$$0(88);
        }
        if (processor == null) {
            StringUtil.$$$reportNull$$$0(89);
        }
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));){
            StringUtil.processLines(in, processor);
        }
    }

    @Deprecated
    public static String escapeStr(String str, EscapeInfoProvider p) {
        return MapSerializerUtil.escapeStr((String)str, (MapSerializerUtil.EscapeInfoProvider)p);
    }

    public static String escapeStr(String str, EscapeInfoProvider2 p) {
        return MapSerializerUtil.escapeStr((String)str, (MapSerializerUtil.EscapeInfoProvider2)p);
    }

    @Deprecated
    public static String unescapeStr(String str, EscapeInfoProvider p) {
        return MapSerializerUtil.unescapeStr((String)str, (MapSerializerUtil.EscapeInfoProvider)p);
    }

    public static String unescapeStr(String str, EscapeInfoProvider2 p) {
        return MapSerializerUtil.unescapeStr((String)str, (MapSerializerUtil.EscapeInfoProvider2)p);
    }

    @Nullable
    @Contract(value="null,_->null;!null,_->!null")
    public static String encodeURLParameter(@Nullable String source, @NotNull String encoding) throws UnsupportedEncodingException {
        if (encoding == null) {
            StringUtil.$$$reportNull$$$0(90);
        }
        return StringUtil.encodeURLPart(source, encoding, UrlPart.QUERY_PARAMETER);
    }

    @Nullable
    @Contract(value="null->null;!null->!null")
    public static String encodeURLParameter(@Nullable String source) {
        try {
            return StringUtil.encodeURLParameter(source, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            Loggers.SERVER.warn("Failed to encode URL parameter: " + source);
            return source;
        }
    }

    @Nullable
    @Contract(value="null,_,_->null;!null,_,_->!null")
    private static String encodeURLPart(@Nullable String source, @NotNull String encoding, @NotNull UrlPart part) throws UnsupportedEncodingException {
        if (encoding == null) {
            StringUtil.$$$reportNull$$$0(91);
        }
        if (part == null) {
            StringUtil.$$$reportNull$$$0(92);
        }
        if (source == null) {
            return null;
        }
        if (encoding.length() <= 0) {
            throw new UnsupportedEncodingException("Encoding must not be empty");
        }
        byte[] sourceBytes = source.getBytes(encoding);
        ByteArrayOutputStream bos = new ByteArrayOutputStream(sourceBytes.length);
        for (byte b : sourceBytes) {
            if (b < 0) {
                b = (byte)(b + 256);
            }
            if (part.isAllowed(b)) {
                bos.write(b);
                continue;
            }
            bos.write(37);
            char hex1 = Character.toUpperCase(Character.forDigit(b >> 4 & 0xF, 16));
            char hex2 = Character.toUpperCase(Character.forDigit(b & 0xF, 16));
            bos.write(hex1);
            bos.write(hex2);
        }
        byte[] bytes = bos.toByteArray();
        return new String(bytes, "US-ASCII");
    }

    @Nullable
    @Contract(value="null,_->null;!null,_->!null")
    public static String decodeURL(@Nullable String source, @NotNull String encoding) throws UnsupportedEncodingException {
        if (encoding == null) {
            StringUtil.$$$reportNull$$$0(93);
        }
        if (source == null) {
            return null;
        }
        if (encoding.length() <= 0) {
            throw new UnsupportedEncodingException("Encoding must not be empty");
        }
        int length = source.length();
        ByteArrayOutputStream bos = new ByteArrayOutputStream(length);
        boolean changed = false;
        for (int i = 0; i < length; ++i) {
            char ch = source.charAt(i);
            if (ch == '%') {
                if (i + 2 < length) {
                    char hex1 = source.charAt(i + 1);
                    char hex2 = source.charAt(i + 2);
                    int u = Character.digit(hex1, 16);
                    int l = Character.digit(hex2, 16);
                    if (u == -1 || l == -1) {
                        throw new IllegalArgumentException("Invalid encoded sequence \"" + source.substring(i) + "\"");
                    }
                    bos.write((char)((u << 4) + l));
                    i += 2;
                    changed = true;
                    continue;
                }
                throw new IllegalArgumentException("Invalid encoded sequence \"" + source.substring(i) + "\"");
            }
            bos.write(ch);
        }
        return changed ? new String(bos.toByteArray(), encoding) : source;
    }

    @Nullable
    @Contract(value="null->null;!null->!null")
    public static String decodeURL(@Nullable String source) {
        try {
            return StringUtil.decodeURL(source, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            Loggers.SERVER.warn("Failed to escape URL: " + source);
            return source;
        }
    }

    @NotNull
    public static String escapeForCSV(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(94);
        }
        String string = s.indexOf(34) >= 0 || s.indexOf(44) >= 0 || s.indexOf(13) >= 0 || s.indexOf(10) >= 0 ? "\"" + s.replace("\"", "\"\"") + "\"" : s;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(95);
        }
        return string;
    }

    public static String formatTextForWeb(String txt) {
        if (txt == null) {
            return null;
        }
        return StringUtil.escapeHTML(txt, true).replaceAll("\r\n|\n\r", "\n").replace("\t", "    ");
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static String withPlural(long n, @NotNull String string) {
        void base;
        if (string == null) {
            StringUtil.$$$reportNull$$$0(96);
        }
        String string2 = String.valueOf(n) + " " + StringUtil.pluralize((String)base, (int)(n == 1L ? 1 : 2));
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(97);
        }
        return string2;
    }

    public static String replaceNonAlphaNumericChars(String originalStr, char toReplace) {
        return StringUtils.replaceNonAlphaNumericChars(originalStr, toReplace);
    }

    @Nullable
    @Contract(value="null, _, _, _ -> null; !null, _, _, _ -> !null")
    public static String peekNthDelimitedField(@Nullable String string, char separator, int nth, boolean trim) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        int pos1 = nth == 1 ? -1 : n;
        int pos2 = n;
        int k = 0;
        for (int i = 0; i < n; ++i) {
            if (string.charAt(i) != separator) continue;
            if (++k == nth - 1) {
                pos1 = i;
            }
            if (k != nth) continue;
            pos2 = i;
        }
        assert (pos1 <= pos2);
        if (pos1 >= -1 && pos1 < pos2 && pos2 <= n) {
            if (trim) {
                return string.substring(pos1 + 1, pos2).trim();
            }
            return string.substring(pos1 + 1, pos2);
        }
        return EMPTY;
    }

    public static char charAt(@Nullable String string, int position) {
        int n = string != null ? string.length() : 0;
        return position < n ? string.charAt(position) : (char)'\u0000';
    }

    @Contract(value="null -> null")
    @Nullable
    public static String nullIfEmpty(@Nullable String string) {
        return string != null && !string.isEmpty() ? string : null;
    }

    @NotNull
    public static String emptyIfNull(@Nullable String string) {
        String string2 = string != null && !string.isEmpty() ? string : EMPTY;
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(98);
        }
        return string2;
    }

    @NotNull
    public static String notEmpty(@Nullable String string, @NotNull String defaultValue) {
        if (defaultValue == null) {
            StringUtil.$$$reportNull$$$0(99);
        }
        String string2 = string != null && !string.isEmpty() ? string : defaultValue;
        if (string2 == null) {
            StringUtil.$$$reportNull$$$0(100);
        }
        return string2;
    }

    @Nullable
    @Contract(value="null->null; !null->!null")
    public static String trim(@Nullable String s) {
        return s != null ? s.trim() : null;
    }

    @Nullable
    @Contract(value="null -> null")
    public static String trimAndNull(@Nullable String string) {
        if (string != null) {
            string = string.trim();
        }
        if (string != null && !string.isEmpty()) {
            return string;
        }
        return null;
    }

    @Nullable
    @Contract(value="null->null;!null->!null")
    public static String trimRight(@Nullable String string) {
        if (string == null) {
            return null;
        }
        int n = string.length();
        if (n == 0 || !Character.isWhitespace(string.charAt(n - 1))) {
            return string;
        }
        StringBuilder buf = new StringBuilder(string);
        while (buf.length() > 0 && Character.isWhitespace(buf.charAt(buf.length() - 1))) {
            buf.delete(buf.length() - 1, buf.length());
        }
        return buf.toString();
    }

    public static void trimStringBuilderLeft(@NotNull StringBuilder buf) {
        int k;
        if (buf == null) {
            StringUtil.$$$reportNull$$$0(101);
        }
        int n = buf.length();
        for (k = 0; k < n && Character.isWhitespace(buf.charAt(k)); ++k) {
        }
        if (k > 0) {
            buf.delete(0, k);
        }
    }

    @NotNull
    public static String stripLeftAndRight(@NotNull String s, @NotNull CharFilter filter) {
        int left;
        if (s == null) {
            StringUtil.$$$reportNull$$$0(102);
        }
        if (filter == null) {
            StringUtil.$$$reportNull$$$0(103);
        }
        int length = s.length();
        for (left = 0; left < length && filter.accept(s.charAt(left)); ++left) {
        }
        if (left == length) {
            if (EMPTY == null) {
                StringUtil.$$$reportNull$$$0(104);
            }
            return EMPTY;
        }
        int right = length - 1;
        if (left > right) {
            if (EMPTY == null) {
                StringUtil.$$$reportNull$$$0(105);
            }
            return EMPTY;
        }
        while (right >= left && filter.accept(s.charAt(right))) {
            --right;
        }
        if (left > right) {
            if (EMPTY == null) {
                StringUtil.$$$reportNull$$$0(106);
            }
            return EMPTY;
        }
        String string = s.substring(left, right + 1);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(107);
        }
        return string;
    }

    @NotNull
    public static String elapsedTimeToString(@Nullable Date date) {
        if (date == null) {
            if (EMPTY == null) {
                StringUtil.$$$reportNull$$$0(108);
            }
            return EMPTY;
        }
        String string = StringUtil.elapsedTimeToString(System.currentTimeMillis() - date.getTime());
        if (string == null) {
            StringUtil.$$$reportNull$$$0(109);
        }
        return string;
    }

    @NotNull
    public static String elapsedTimeToString(long millis) {
        long seconds = millis / 1000L;
        int hour = 3600;
        int day = 86400;
        if (millis < 0L) {
            if (seconds >= -5L) {
                if ("in a moment" == null) {
                    StringUtil.$$$reportNull$$$0(110);
                }
                return "in a moment";
            }
            if (seconds > -60L) {
                if ("in several seconds" == null) {
                    StringUtil.$$$reportNull$$$0(111);
                }
                return "in several seconds";
            }
            if (seconds > -120L) {
                if ("in a minute" == null) {
                    StringUtil.$$$reportNull$$$0(112);
                }
                return "in a minute";
            }
            if (seconds > -3600L) {
                String string = "in " + -seconds / 60L + " minutes";
                if (string == null) {
                    StringUtil.$$$reportNull$$$0(113);
                }
                return string;
            }
            if ((double)seconds > -3960.0000000000005) {
                if ("in an hour" == null) {
                    StringUtil.$$$reportNull$$$0(114);
                }
                return "in an hour";
            }
            if (seconds > -7200L) {
                String string = "in 1 hour " + (-seconds - 3600L) / 60L + " min";
                if (string == null) {
                    StringUtil.$$$reportNull$$$0(115);
                }
                return string;
            }
            if (seconds > -10800L) {
                String string = "in 2 hours " + (-seconds - 7200L) / 60L + " min";
                if (string == null) {
                    StringUtil.$$$reportNull$$$0(116);
                }
                return string;
            }
            if (seconds > -86400L) {
                String string = "in " + -seconds / 3600L + " hours";
                if (string == null) {
                    StringUtil.$$$reportNull$$$0(117);
                }
                return string;
            }
            if (seconds > -172800L) {
                if ("in a day" == null) {
                    StringUtil.$$$reportNull$$$0(118);
                }
                return "in a day";
            }
            String string = "in " + -seconds / 86400L + " days";
            if (string == null) {
                StringUtil.$$$reportNull$$$0(119);
            }
            return string;
        }
        if (seconds < 5L) {
            if ("moments ago" == null) {
                StringUtil.$$$reportNull$$$0(120);
            }
            return "moments ago";
        }
        if (seconds < 20L) {
            if ("seconds ago" == null) {
                StringUtil.$$$reportNull$$$0(121);
            }
            return "seconds ago";
        }
        if (seconds < 120L) {
            if ("one minute ago" == null) {
                StringUtil.$$$reportNull$$$0(122);
            }
            return "one minute ago";
        }
        if (seconds < 3600L) {
            String string = seconds / 60L + " minutes ago";
            if (string == null) {
                StringUtil.$$$reportNull$$$0(123);
            }
            return string;
        }
        if (seconds < 7200L) {
            if ("one hour ago" == null) {
                StringUtil.$$$reportNull$$$0(124);
            }
            return "one hour ago";
        }
        if (seconds < 86400L) {
            String string = seconds / 3600L + " hours ago";
            if (string == null) {
                StringUtil.$$$reportNull$$$0(125);
            }
            return string;
        }
        if (seconds < 172800L) {
            if ("one day ago" == null) {
                StringUtil.$$$reportNull$$$0(126);
            }
            return "one day ago";
        }
        if (seconds < 2592000L) {
            String string = seconds / 86400L + " days ago";
            if (string == null) {
                StringUtil.$$$reportNull$$$0(127);
            }
            return string;
        }
        if (seconds < 5184000L) {
            if ("one month ago" == null) {
                StringUtil.$$$reportNull$$$0(128);
            }
            return "one month ago";
        }
        String string = seconds / 2592000L + " months ago";
        if (string == null) {
            StringUtil.$$$reportNull$$$0(129);
        }
        return string;
    }

    @NotNull
    public static String millisToString(long timeIntervalMs, boolean useMillis) {
        if (timeIntervalMs == 0L) {
            String string = useMillis ? "0 msec" : "0 sec";
            if (string == null) {
                StringUtil.$$$reportNull$$$0(130);
            }
            return string;
        }
        long totalMillis = Math.abs(timeIntervalMs);
        long millis = totalMillis % 1000L;
        long totalSeconds = totalMillis / 1000L;
        long seconds = totalSeconds % 60L;
        long totalMinutes = totalSeconds / 60L;
        long minutes = totalMinutes % 60L;
        long totalHours = totalMinutes / 60L;
        long hours = totalHours % 24L;
        long days = totalHours / 24L;
        StringBuilder result = new StringBuilder();
        if (days > 0L) {
            if (days == 1L) {
                result.append("1 day ");
            } else {
                result.append(days).append(" days ");
            }
        }
        if (hours > 0L) {
            if (hours == 1L) {
                result.append("1 hour ");
            } else {
                result.append(hours).append(" hours ");
            }
        }
        if (minutes > 0L) {
            result.append(minutes).append(" min ");
        }
        if (seconds > 0L) {
            result.append(seconds).append(" sec ");
        }
        if (millis > 0L && useMillis) {
            result.append(millis).append(" msec");
        }
        String string = result.toString().trim();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(131);
        }
        return string;
    }

    @NotNull
    public static String dateToString(@NotNull Date date) {
        if (date == null) {
            StringUtil.$$$reportNull$$$0(132);
        }
        String string = new SimpleDateFormat(DEFAULT_DATE_FORMAT, Locale.ENGLISH).format(date);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(133);
        }
        return string;
    }

    @NotNull
    public static String formatInt(int value, int length, char fillChar) {
        StringBuilder builder = new StringBuilder(length);
        builder.append(value);
        while (builder.length() < length) {
            builder.insert(0, fillChar);
        }
        String string = builder.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(134);
        }
        return string;
    }

    @NotNull
    public static String formatInt(int value, int length) {
        String string = StringUtil.formatInt(value, length, '0');
        if (string == null) {
            StringUtil.$$$reportNull$$$0(135);
        }
        return string;
    }

    @NotNull
    public static String formatInt(int value) {
        String string = StringUtil.formatInt(value, 2);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(136);
        }
        return string;
    }

    @NotNull
    public static List<String> splitHonorQuotes(@NotNull String s, char separator) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(137);
        }
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder builder = new StringBuilder();
        Character quoteSymbol = null;
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == separator && quoteSymbol == null) {
                if (builder.length() <= 0) continue;
                result.add(builder.toString());
                builder.setLength(0);
                continue;
            }
            if (!(c != '\"' && c != '\'' || i > 0 && s.charAt(i - 1) == '\\')) {
                if (quoteSymbol == null) {
                    quoteSymbol = Character.valueOf(c);
                } else if (quoteSymbol.charValue() == c) {
                    quoteSymbol = null;
                }
            }
            builder.append(c);
        }
        if (builder.length() > 0) {
            result.add(builder.toString());
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            StringUtil.$$$reportNull$$$0(138);
        }
        return arrayList;
    }

    public static String substringByRegex(CharSequence text, Pattern pattern, int groupNr) {
        if (pattern == null) {
            throw new IllegalArgumentException("Called substringByRegex with null pattern.");
        }
        if (text == null) {
            return null;
        }
        Matcher m = pattern.matcher(text);
        boolean found = m.find();
        if (!found) {
            return null;
        }
        return m.group(groupNr);
    }

    @NotNull
    public static List<String> splitHonorQuotes(@NotNull String s) {
        if (s == null) {
            StringUtil.$$$reportNull$$$0(139);
        }
        List<String> list = StringUtil.splitHonorQuotes(s, ' ');
        if (list == null) {
            StringUtil.$$$reportNull$$$0(140);
        }
        return list;
    }

    @NotNull
    public static String stringValueOf(@Nullable Object obj, @NotNull String defaultValue) {
        if (defaultValue == null) {
            StringUtil.$$$reportNull$$$0(141);
        }
        String string = obj == null ? defaultValue : String.valueOf(obj);
        if (string == null) {
            StringUtil.$$$reportNull$$$0(142);
        }
        return string;
    }

    public static String collapseSpaces(@NotNull String str) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(143);
        }
        Character sequenceStarted = null;
        StringBuilder result = new StringBuilder();
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            boolean isWhitespace = c == ' ' || c == '\t';
            boolean isNewline = StringUtil.isNewLineChar(c);
            if (!isWhitespace) {
                if (sequenceStarted != null && !StringUtil.isNewLineChar(sequenceStarted.charValue()) && !isNewline) {
                    result.append(' ');
                }
                result.append(c);
            }
            if (isNewline) {
                sequenceStarted = Character.valueOf(c);
                continue;
            }
            if (!isWhitespace) {
                sequenceStarted = null;
                continue;
            }
            if (sequenceStarted != null) continue;
            sequenceStarted = Character.valueOf(c);
        }
        if (sequenceStarted != null && !StringUtil.isNewLineChar(sequenceStarted.charValue())) {
            result.append(' ');
        }
        return result.toString();
    }

    public static String replaceNewLines(@NotNull String str, @NotNull String replacement) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(144);
        }
        if (replacement == null) {
            StringUtil.$$$reportNull$$$0(145);
        }
        StringBuilder sb = null;
        boolean newLineChar = false;
        int initialUnmodifiedLength = 0;
        for (int i = 0; i < str.length(); ++i) {
            char c = str.charAt(i);
            if (StringUtil.isNewLineChar(c)) {
                newLineChar = true;
                continue;
            }
            if (newLineChar) {
                if (sb == null) {
                    sb = new StringBuilder(str.length());
                    sb.append(str, 0, initialUnmodifiedLength);
                }
                sb.append(replacement);
            }
            newLineChar = false;
            if (sb != null) {
                sb.append(c);
                continue;
            }
            ++initialUnmodifiedLength;
        }
        if (newLineChar) {
            if (sb == null) {
                sb = new StringBuilder(initialUnmodifiedLength + replacement.length());
                sb.append(str, 0, initialUnmodifiedLength);
            }
            sb.append(replacement);
        }
        return sb == null ? str : sb.toString();
    }

    public static String newLineToSpaceDelimited(@NotNull String str) {
        if (str == null) {
            StringUtil.$$$reportNull$$$0(146);
        }
        return StringUtil.replaceNewLines(str, " ").trim();
    }

    private static boolean isNewLineChar(char c) {
        return c == '\r' || c == '\n';
    }

    public static boolean hasParameterReferences(@Nullable String str) {
        if (StringUtil.isEmpty((String)str)) {
            return false;
        }
        return ReferencesResolverUtil.containsReference(str, new String[0], true);
    }

    @NotNull
    public static String removeNonBMPCharacters(@NotNull String str) {
        char c;
        int k;
        if (str == null) {
            StringUtil.$$$reportNull$$$0(147);
        }
        int n = str.length();
        for (k = 0; k < n && (c = str.charAt(k)) < '\ud800'; ++k) {
        }
        if (k == n) {
            String string = str;
            if (string == null) {
                StringUtil.$$$reportNull$$$0(148);
            }
            return string;
        }
        StringBuilder buf = new StringBuilder(str);
        do {
            buf.setCharAt(k, '?');
            if (++k < n && buf.charAt(k) >= '\udb00') {
                buf.deleteCharAt(k);
                --n;
            }
            while (k < n && buf.charAt(k) < '\ud800') {
                ++k;
            }
        } while (k < n);
        String string = buf.toString();
        if (string == null) {
            StringUtil.$$$reportNull$$$0(149);
        }
        return string;
    }

    public static void escapeDataForCSV(PrintWriter writer, String ... data) {
        for (int i = 0; i < data.length; ++i) {
            String s = data[i];
            writer.append(StringUtil.escapeForCSV(s));
            if (i != data.length - 1) {
                writer.append(',');
                continue;
            }
            writer.append("\r\n");
        }
    }

    public static String escapeForCSV(String ... data) {
        if (data == null) {
            StringUtil.$$$reportNull$$$0(150);
        }
        StringBuilder builder = new StringBuilder();
        for (String str : data) {
            builder.append(StringUtil.escapeForCSV(str)).append(',');
        }
        return builder.length() > 0 ? builder.substring(0, builder.length() - 1) : EMPTY;
    }

    @Nullable
    @Contract(value="null -> null")
    public static String objectToString(@Nullable Object object) {
        return object == null ? null : object.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 12: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 34: 
            case 35: 
            case 37: 
            case 39: 
            case 41: 
            case 45: 
            case 47: 
            case 50: 
            case 53: 
            case 56: 
            case 59: 
            case 70: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 95: 
            case 97: 
            case 98: 
            case 100: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 138: 
            case 140: 
            case 142: 
            case 148: 
            case 149: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 12: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 34: 
            case 35: 
            case 37: 
            case 39: 
            case 41: 
            case 45: 
            case 47: 
            case 50: 
            case 53: 
            case 56: 
            case 59: 
            case 70: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 95: 
            case 97: 
            case 98: 
            case 100: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 138: 
            case 140: 
            case 142: 
            case 148: 
            case 149: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string1";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string2";
                break;
            }
            case 2: 
            case 17: 
            case 26: 
            case 71: 
            case 143: 
            case 144: 
            case 146: 
            case 147: {
                objectArray2 = objectArray3;
                objectArray3[0] = "str";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 12: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 34: 
            case 35: 
            case 37: 
            case 39: 
            case 41: 
            case 45: 
            case 47: 
            case 50: 
            case 53: 
            case 56: 
            case 59: 
            case 70: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 95: 
            case 97: 
            case 98: 
            case 100: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 138: 
            case 140: 
            case 142: 
            case 148: 
            case 149: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/util/StringUtil";
                break;
            }
            case 5: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "line";
                break;
            }
            case 7: 
            case 43: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "postfix";
                break;
            }
            case 13: 
            case 69: 
            case 94: 
            case 102: 
            case 137: 
            case 139: {
                objectArray2 = objectArray3;
                objectArray3[0] = "s";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "random";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyword";
                break;
            }
            case 28: 
            case 67: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 30: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "values";
                break;
            }
            case 33: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "separators";
                break;
            }
            case 38: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exception";
                break;
            }
            case 40: 
            case 42: 
            case 44: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toJoin";
                break;
            }
            case 46: 
            case 48: 
            case 51: 
            case 54: 
            case 57: 
            case 61: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 49: 
            case 52: 
            case 55: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "escaper";
                break;
            }
            case 60: {
                objectArray2 = objectArray3;
                objectArray3[0] = "strings";
                break;
            }
            case 62: {
                objectArray2 = objectArray3;
                objectArray3[0] = "suffix";
                break;
            }
            case 63: 
            case 66: 
            case 101: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buf";
                break;
            }
            case 64: {
                objectArray2 = objectArray3;
                objectArray3[0] = "what";
                break;
            }
            case 65: 
            case 68: {
                objectArray2 = objectArray3;
                objectArray3[0] = "with";
                break;
            }
            case 72: 
            case 74: 
            case 87: 
            case 89: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 73: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
            case 85: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileSizeStr";
                break;
            }
            case 86: {
                objectArray2 = objectArray3;
                objectArray3[0] = "in";
                break;
            }
            case 88: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 90: 
            case 91: 
            case 93: {
                objectArray2 = objectArray3;
                objectArray3[0] = "encoding";
                break;
            }
            case 92: {
                objectArray2 = objectArray3;
                objectArray3[0] = "part";
                break;
            }
            case 96: {
                objectArray2 = objectArray3;
                objectArray3[0] = "base";
                break;
            }
            case 99: 
            case 141: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultValue";
                break;
            }
            case 103: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 132: {
                objectArray2 = objectArray3;
                objectArray3[0] = "date";
                break;
            }
            case 145: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replacement";
                break;
            }
            case 150: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/util/StringUtil";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeHTML";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "splitCommandArgumentsAndUnquote";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "removeQuotes";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "biteOffPostfix";
                break;
            }
            case 14: 
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "lastPartOf";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "replaceInvalidXmlChars";
                break;
            }
            case 20: 
            case 23: {
                objectArray = objectArray2;
                objectArray2[1] = "generateUniqueHash";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "generateUniqueHashQuickly";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "searchByKeywordPattern";
                break;
            }
            case 27: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeForRegex";
                break;
            }
            case 29: {
                objectArray = objectArray2;
                objectArray2[1] = "convertWildcardToRegexp";
                break;
            }
            case 31: 
            case 34: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "split";
                break;
            }
            case 37: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrdinal";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "stackTrace";
                break;
            }
            case 41: 
            case 45: {
                objectArray = objectArray2;
                objectArray2[1] = "join";
                break;
            }
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "doubleQuote";
                break;
            }
            case 50: 
            case 53: 
            case 56: 
            case 59: {
                objectArray = objectArray2;
                objectArray2[1] = "stringToProperties";
                break;
            }
            case 70: {
                objectArray = objectArray2;
                objectArray2[1] = "convertAndCollapseSlashes";
                break;
            }
            case 75: 
            case 76: 
            case 77: {
                objectArray = objectArray2;
                objectArray2[1] = "formatPercent";
                break;
            }
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: {
                objectArray = objectArray2;
                objectArray2[1] = "formatFileSize";
                break;
            }
            case 95: {
                objectArray = objectArray2;
                objectArray2[1] = "escapeForCSV";
                break;
            }
            case 97: {
                objectArray = objectArray2;
                objectArray2[1] = "withPlural";
                break;
            }
            case 98: {
                objectArray = objectArray2;
                objectArray2[1] = "emptyIfNull";
                break;
            }
            case 100: {
                objectArray = objectArray2;
                objectArray2[1] = "notEmpty";
                break;
            }
            case 104: 
            case 105: 
            case 106: 
            case 107: {
                objectArray = objectArray2;
                objectArray2[1] = "stripLeftAndRight";
                break;
            }
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: {
                objectArray = objectArray2;
                objectArray2[1] = "elapsedTimeToString";
                break;
            }
            case 130: 
            case 131: {
                objectArray = objectArray2;
                objectArray2[1] = "millisToString";
                break;
            }
            case 133: {
                objectArray = objectArray2;
                objectArray2[1] = "dateToString";
                break;
            }
            case 134: 
            case 135: 
            case 136: {
                objectArray = objectArray2;
                objectArray2[1] = "formatInt";
                break;
            }
            case 138: 
            case 140: {
                objectArray = objectArray2;
                objectArray2[1] = "splitHonorQuotes";
                break;
            }
            case 142: {
                objectArray = objectArray2;
                objectArray2[1] = "stringValueOf";
                break;
            }
            case 148: 
            case 149: {
                objectArray = objectArray2;
                objectArray2[1] = "removeNonBMPCharacters";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "differCaseOnly";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isUpperCase";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 12: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 34: 
            case 35: 
            case 37: 
            case 39: 
            case 41: 
            case 45: 
            case 47: 
            case 50: 
            case 53: 
            case 56: 
            case 59: 
            case 70: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 95: 
            case 97: 
            case 98: 
            case 100: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 138: 
            case 140: 
            case 142: 
            case 148: 
            case 149: {
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "splitCommandArgumentsAndUnquote";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "removeQuotes";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isNotEscapedQuote";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "biteOffPostfix";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "lastPartOf";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "findInvalidXMLChar";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "replaceInvalidXmlChars";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "generateUniqueHash";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "searchByKeywordPattern";
                break;
            }
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "escapeForRegex";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "convertWildcardToRegexp";
                break;
            }
            case 30: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "split";
                break;
            }
            case 36: {
                objectArray = objectArray;
                objectArray[2] = "isSeparator";
                break;
            }
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "stackTrace";
                break;
            }
            case 40: 
            case 42: 
            case 43: 
            case 44: {
                objectArray = objectArray;
                objectArray[2] = "join";
                break;
            }
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "doubleQuote";
                break;
            }
            case 48: 
            case 49: 
            case 51: 
            case 52: 
            case 54: 
            case 55: 
            case 57: 
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "stringToProperties";
                break;
            }
            case 60: {
                objectArray = objectArray;
                objectArray[2] = "convertStringsToLowerCase";
                break;
            }
            case 61: 
            case 62: {
                objectArray = objectArray;
                objectArray[2] = "removeSuffix";
                break;
            }
            case 63: 
            case 64: 
            case 65: 
            case 66: 
            case 67: 
            case 68: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 69: {
                objectArray = objectArray;
                objectArray[2] = "convertAndCollapseSlashes";
                break;
            }
            case 71: 
            case 72: 
            case 73: 
            case 74: 
            case 86: 
            case 87: 
            case 88: 
            case 89: {
                objectArray = objectArray;
                objectArray[2] = "processLines";
                break;
            }
            case 85: {
                objectArray = objectArray;
                objectArray[2] = "parseFileSize";
                break;
            }
            case 90: {
                objectArray = objectArray;
                objectArray[2] = "encodeURLParameter";
                break;
            }
            case 91: 
            case 92: {
                objectArray = objectArray;
                objectArray[2] = "encodeURLPart";
                break;
            }
            case 93: {
                objectArray = objectArray;
                objectArray[2] = "decodeURL";
                break;
            }
            case 94: 
            case 150: {
                objectArray = objectArray;
                objectArray[2] = "escapeForCSV";
                break;
            }
            case 96: {
                objectArray = objectArray;
                objectArray[2] = "withPlural";
                break;
            }
            case 99: {
                objectArray = objectArray;
                objectArray[2] = "notEmpty";
                break;
            }
            case 101: {
                objectArray = objectArray;
                objectArray[2] = "trimStringBuilderLeft";
                break;
            }
            case 102: 
            case 103: {
                objectArray = objectArray;
                objectArray[2] = "stripLeftAndRight";
                break;
            }
            case 132: {
                objectArray = objectArray;
                objectArray[2] = "dateToString";
                break;
            }
            case 137: 
            case 139: {
                objectArray = objectArray;
                objectArray[2] = "splitHonorQuotes";
                break;
            }
            case 141: {
                objectArray = objectArray;
                objectArray[2] = "stringValueOf";
                break;
            }
            case 143: {
                objectArray = objectArray;
                objectArray[2] = "collapseSpaces";
                break;
            }
            case 144: 
            case 145: {
                objectArray = objectArray;
                objectArray[2] = "replaceNewLines";
                break;
            }
            case 146: {
                objectArray = objectArray;
                objectArray[2] = "newLineToSpaceDelimited";
                break;
            }
            case 147: {
                objectArray = objectArray;
                objectArray[2] = "removeNonBMPCharacters";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 12: 
            case 14: 
            case 15: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 23: 
            case 25: 
            case 27: 
            case 29: 
            case 31: 
            case 34: 
            case 35: 
            case 37: 
            case 39: 
            case 41: 
            case 45: 
            case 47: 
            case 50: 
            case 53: 
            case 56: 
            case 59: 
            case 70: 
            case 75: 
            case 76: 
            case 77: 
            case 78: 
            case 79: 
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 95: 
            case 97: 
            case 98: 
            case 100: 
            case 104: 
            case 105: 
            case 106: 
            case 107: 
            case 108: 
            case 109: 
            case 110: 
            case 111: 
            case 112: 
            case 113: 
            case 114: 
            case 115: 
            case 116: 
            case 117: 
            case 118: 
            case 119: 
            case 120: 
            case 121: 
            case 122: 
            case 123: 
            case 124: 
            case 125: 
            case 126: 
            case 127: 
            case 128: 
            case 129: 
            case 130: 
            case 131: 
            case 133: 
            case 134: 
            case 135: 
            case 136: 
            case 138: 
            case 140: 
            case 142: 
            case 148: 
            case 149: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum UrlPart {
        FULL_URL{

            @Override
            public boolean isAllowed(int c) {
                if (61 == c || 43 == c || 38 == c) {
                    return false;
                }
                return this.isPchar(c) || 47 == c || 63 == c;
            }
        }
        ,
        QUERY_PARAMETER{

            @Override
            public boolean isAllowed(int c) {
                return this.isUnreserved(c);
            }
        };


        public abstract boolean isAllowed(int var1);

        protected boolean isUnreserved(int c) {
            return this.isAlpha(c) || this.isDigit(c) || 45 == c || 46 == c || 95 == c || 126 == c;
        }

        protected boolean isPchar(int c) {
            return this.isUnreserved(c) || this.isSubDelimiter(c) || 58 == c || 64 == c;
        }

        protected boolean isAlpha(int c) {
            return c >= 97 && c <= 122 || c >= 65 && c <= 90;
        }

        protected boolean isDigit(int c) {
            return c >= 48 && c <= 57;
        }

        protected boolean isSubDelimiter(int c) {
            return 33 == c || 36 == c || 38 == c || 39 == c || 40 == c || 41 == c || 42 == c || 43 == c || 44 == c || 59 == c || 61 == c;
        }
    }

    private static class MyTokenizerIterator
    implements Iterator<String> {
        private int myNextPosition = 0;
        private final String myString;
        private final char myDel;

        MyTokenizerIterator(String string, char del) {
            this.myString = string;
            this.myDel = del;
        }

        @Override
        public boolean hasNext() {
            return this.myNextPosition < this.myString.length();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String next() {
            if (!this.hasNext()) {
                throw new ArrayIndexOutOfBoundsException();
            }
            int lastIndex = this.myNextPosition;
            while (lastIndex < this.myString.length()) {
                char nextChar = this.myString.charAt(lastIndex);
                if (nextChar == '\\') {
                    if (nextChar == this.myString.length() - 1) {
                        try {
                            String string = this.myString.substring(this.myNextPosition);
                            return string;
                        }
                        finally {
                            this.myNextPosition = lastIndex + 1;
                        }
                    }
                    ++lastIndex;
                    ++lastIndex;
                    continue;
                }
                if (nextChar == this.myDel) {
                    try {
                        String string = this.myString.substring(this.myNextPosition, lastIndex);
                        return string;
                    }
                    finally {
                        this.myNextPosition = lastIndex + 1;
                    }
                }
                ++lastIndex;
            }
            try {
                String string = this.myString.substring(this.myNextPosition);
                return string;
            }
            finally {
                this.myNextPosition = lastIndex + 1;
            }
        }

        @Override
        public void remove() {
            throw new RuntimeException("Remove not supported");
        }
    }

    public static interface EscapeInfoProvider2
    extends MapSerializerUtil.EscapeInfoProvider2 {
    }

    @Deprecated
    public static interface EscapeInfoProvider
    extends MapSerializerUtil.EscapeInfoProvider {
    }

    public static interface LineProcessor {
        public boolean processLine(String var1);
    }
}

