/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import jetbrains.buildServer.util.filters.Filter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class SynchroDictionary<K, V> {
    @NotNull
    private final Function<K, V> myDataProvider;
    @NotNull
    private final ConcurrentHashMap<K, Object> myLocks;
    @NotNull
    private final ConcurrentHashMap<K, Value<V>> myObjects;
    @NotNull
    private final ReadWriteLock myGlobalLock;
    private final Value<V> NULL_VALUE;

    public SynchroDictionary(@NotNull Function<K, V> dataProvider) {
        if (dataProvider == null) {
            SynchroDictionary.$$$reportNull$$$0(0);
        }
        this.myLocks = new ConcurrentHashMap();
        this.myObjects = new ConcurrentHashMap();
        this.myGlobalLock = new ReentrantReadWriteLock(true);
        this.NULL_VALUE = new Value(null);
        this.myDataProvider = dataProvider;
    }

    public boolean containsKey(@NotNull K key) {
        if (key == null) {
            SynchroDictionary.$$$reportNull$$$0(1);
        }
        return this.myObjects.containsKey(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public V get(@NotNull K key) {
        Value<V> valueWrapper;
        block10: {
            if (key == null) {
                SynchroDictionary.$$$reportNull$$$0(2);
            }
            if ((valueWrapper = this.myObjects.get(key)) != null) break block10;
            Object lock = this.getLock(key);
            this.myGlobalLock.readLock().lock();
            try {
                Object object = lock;
                synchronized (object) {
                    V value;
                    block9: {
                        valueWrapper = this.myObjects.get(key);
                        if (valueWrapper != null) break block10;
                        value = this.myDataProvider.apply(key);
                        if (!(value instanceof NonCacheableValue)) break block9;
                        V v = value;
                        return v;
                    }
                    valueWrapper = value != null ? new Value<V>(value) : this.NULL_VALUE;
                    this.myObjects.put(key, valueWrapper);
                }
            }
            finally {
                this.myGlobalLock.readLock().unlock();
            }
        }
        return valueWrapper.get();
    }

    public V getIfPresent(@NotNull K key) {
        Value<V> valueWrapper;
        if (key == null) {
            SynchroDictionary.$$$reportNull$$$0(3);
        }
        if ((valueWrapper = this.myObjects.get(key)) == null) {
            return null;
        }
        return valueWrapper.get();
    }

    @NotNull
    private Object getLock(@NotNull K key) {
        Object cur;
        Object lock;
        if (key == null) {
            SynchroDictionary.$$$reportNull$$$0(4);
        }
        if ((lock = this.myLocks.get(key)) == null && (cur = this.myLocks.putIfAbsent(key, lock = new Object())) != null && cur != lock) {
            Object object = cur;
            if (object == null) {
                SynchroDictionary.$$$reportNull$$$0(5);
            }
            return object;
        }
        Object object = lock;
        if (object == null) {
            SynchroDictionary.$$$reportNull$$$0(6);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidate(@NotNull K key) {
        if (key == null) {
            SynchroDictionary.$$$reportNull$$$0(7);
        }
        Object lock = this.getLock(key);
        this.myGlobalLock.readLock().lock();
        try {
            Object object = lock;
            synchronized (object) {
                this.myObjects.remove(key);
                this.myLocks.remove(key);
            }
        }
        finally {
            this.myGlobalLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public boolean replace(@NotNull K key, @Nullable V current, @NotNull V newVal) {
        block10: {
            boolean bl;
            if (key == null) {
                SynchroDictionary.$$$reportNull$$$0(8);
            }
            if (newVal == null) {
                SynchroDictionary.$$$reportNull$$$0(9);
            }
            Object lock = this.getLock(key);
            this.myGlobalLock.readLock().lock();
            try {
                Object object = lock;
                // MONITORENTER : object
                Value<V> cached = this.myObjects.get(key);
                if (cached == null && current != null) {
                    boolean bl2 = false;
                    // MONITOREXIT : object
                    this.myGlobalLock.readLock().unlock();
                    return bl2;
                }
                if (cached == null || cached.get() == current) break block10;
                bl = false;
            }
            catch (Throwable throwable) {
                this.myGlobalLock.readLock().unlock();
                throw throwable;
            }
            this.myGlobalLock.readLock().unlock();
            return bl;
        }
        this.myObjects.put(key, new Value(newVal));
        boolean bl = true;
        // MONITOREXIT : object
        this.myGlobalLock.readLock().unlock();
        return bl;
    }

    public void invalidateAll() {
        this.myGlobalLock.writeLock().lock();
        try {
            this.myObjects.clear();
            this.myLocks.clear();
        }
        finally {
            this.myGlobalLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void invalidateAll(@NotNull Filter<V> cachedDataFilter) {
        if (cachedDataFilter == null) {
            SynchroDictionary.$$$reportNull$$$0(10);
        }
        this.myGlobalLock.writeLock().lock();
        try {
            HashSet<K> keysToRemove = new HashSet<K>();
            for (Map.Entry<K, Value<V>> keyVal : this.myObjects.entrySet()) {
                V value = keyVal.getValue().get();
                if (value == null || !cachedDataFilter.accept(value)) continue;
                keysToRemove.add(keyVal.getKey());
            }
            if (!keysToRemove.isEmpty()) {
                ((ConcurrentHashMap.KeySetView)this.myObjects.keySet()).removeAll(keysToRemove);
                ((ConcurrentHashMap.KeySetView)this.myLocks.keySet()).removeAll(keysToRemove);
            }
        }
        finally {
            this.myGlobalLock.writeLock().unlock();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataProvider";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/util/SynchroDictionary";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newVal";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "cachedDataFilter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/util/SynchroDictionary";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLock";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "containsKey";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "get";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getIfPresent";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getLock";
                break;
            }
            case 5: 
            case 6: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "invalidate";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "replace";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "invalidateAll";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static interface NonCacheableValue {
    }

    private static class Value<V> {
        private final V myVal;

        private Value(V val) {
            this.myVal = val;
        }

        public V get() {
            return this.myVal;
        }
    }

    public static interface Function<K, V> {
        @Nullable
        public V apply(@NotNull K var1);
    }
}

