/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import jetbrains.buildServer.serverSide.TeamCityProperties;
import jetbrains.buildServer.util.FileUtil;
import jetbrains.buildServer.util.SystemTimeService;
import jetbrains.buildServer.util.TimeService;
import jetbrains.buildServer.util.impl.TCLogStatistic;
import org.apache.log4j.Layout;
import org.apache.log4j.RollingFileAppender;
import org.apache.log4j.helpers.CountingQuietWriter;
import org.apache.log4j.helpers.OptionConverter;
import org.apache.log4j.spi.LoggingEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joda.time.DateTime;

public class TCRollingFileAppender
extends RollingFileAppender {
    public static volatile TCLogStatistic STATISTIC = null;
    private String myStatisticPeriods;
    private final TimeService myTimeService;
    private FileInfo myFileInfo;
    private volatile boolean myInitialized;
    private volatile boolean myEnforceSetFile;
    private long myNextCheck;
    private boolean myRotateOnDayChange;
    private long myRotateOnDayMinimalFileSize;

    public TCRollingFileAppender() {
        this.myInitialized = false;
        this.myEnforceSetFile = false;
        this.myNextCheck = 0L;
        this.myTimeService = SystemTimeService.getInstance();
        this.initDefaults();
    }

    public TCRollingFileAppender(@NotNull TimeService timeService, @Nullable String statisticPeriods) {
        if (timeService == null) {
            TCRollingFileAppender.$$$reportNull$$$0(0);
        }
        this.myInitialized = false;
        this.myEnforceSetFile = false;
        this.myNextCheck = 0L;
        this.myTimeService = timeService;
        this.initDefaults();
        this.myStatisticPeriods = statisticPeriods;
    }

    public TCRollingFileAppender(Layout layout, String filename) throws IOException {
        super(layout, filename);
        this.myInitialized = false;
        this.myEnforceSetFile = false;
        this.myNextCheck = 0L;
        this.myTimeService = SystemTimeService.getInstance();
        this.initDefaults();
    }

    public TCRollingFileAppender(Layout layout, String filename, boolean append) throws IOException {
        super(layout, filename, append);
        this.myInitialized = false;
        this.myEnforceSetFile = false;
        this.myNextCheck = 0L;
        this.myTimeService = SystemTimeService.getInstance();
        this.initDefaults();
    }

    private static long getDefaultRotateOnDayMinimalFileSize() {
        String value = TeamCityProperties.isInitialized() ? TeamCityProperties.getPropertyOrNull("teamcity.logs.rotateOnDayMinimalFileSize") : System.getProperty("teamcity.logs.rotateOnDayMinimalFileSize");
        return OptionConverter.toFileSize((String)value, (long)0L);
    }

    private void initDefaults() {
        this.encoding = "UTF-8";
        this.myRotateOnDayChange = TeamCityProperties.isInitialized() ? TeamCityProperties.getBoolean("teamcity.logs.rotateOnDayChange") : Boolean.getBoolean("teamcity.logs.rotateOnDayChange");
        this.myRotateOnDayMinimalFileSize = TCRollingFileAppender.getDefaultRotateOnDayMinimalFileSize();
        this.myStatisticPeriods = null;
    }

    public void rollOver() {
        super.rollOver();
        if (STATISTIC != null) {
            STATISTIC.rollOver(this.getName(), this.fileName, this.maxBackupIndex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(LoggingEvent event) {
        if (!this.myInitialized) {
            TCRollingFileAppender tCRollingFileAppender = this;
            synchronized (tCRollingFileAppender) {
                if (!this.myInitialized) {
                    try {
                        this.myFileInfo.setFile();
                        this.myInitialized = true;
                    }
                    catch (IOException e) {
                        System.out.println("Cannot call setFile(): " + e.toString());
                    }
                }
            }
        }
        if ((STATISTIC = TCLogStatistic.init(event, this.layout, this.getName(), this.fileName, this.myTimeService, this.myStatisticPeriods)) != null) {
            STATISTIC.add(this.getName(), event, this.fileName, (Writer)this.qw);
        }
        super.append(event);
    }

    public synchronized void setFile(String fileName, boolean append, boolean bufferedIO, int bufferSize) throws IOException {
        this.myInitialized = false;
        this.myFileInfo = new FileInfo(fileName, append, bufferedIO, bufferSize);
        if (this.myEnforceSetFile) {
            this.myEnforceSetFile = false;
            this.myFileInfo.setFile();
            this.myInitialized = true;
        }
    }

    public void setRotateOnDayChange(boolean rotate) {
        this.myRotateOnDayChange = rotate;
    }

    public void setRotateOnDayMinimalFileSize(String value) {
        this.myRotateOnDayMinimalFileSize = OptionConverter.toFileSize((String)value, (long)TCRollingFileAppender.getDefaultRotateOnDayMinimalFileSize());
    }

    protected void subAppend(LoggingEvent event) {
        if (this.myRotateOnDayChange) {
            if (this.myNextCheck == 0L) {
                this.setNextUpdateCheckTime(event);
            }
            if (event.timeStamp >= this.myNextCheck && ((CountingQuietWriter)this.qw).getCount() > this.myRotateOnDayMinimalFileSize) {
                this.setNextUpdateCheckTime(event);
                this.myEnforceSetFile = true;
                this.rollOver();
            }
        }
        super.subAppend(event);
    }

    private void setNextUpdateCheckTime(LoggingEvent event) {
        this.myNextCheck = new DateTime(event.timeStamp).plusDays(1).withTimeAtStartOfDay().getMillis();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "timeService", "jetbrains/buildServer/util/TCRollingFileAppender", "<init>"));
    }

    private class FileInfo {
        private final String myFileName;
        private final boolean myAppend;
        private final boolean myBufferedIO;
        private final int myBufSize;

        private FileInfo(String fileName, boolean append, boolean bufferedIO, int bufSize) {
            this.myFileName = fileName;
            this.myAppend = append;
            this.myBufferedIO = bufferedIO;
            this.myBufSize = bufSize;
        }

        void setFile() throws IOException {
            File normalizedFile = new File(FileUtil.normalizeSeparator(this.myFileName)).getCanonicalFile();
            File parent = normalizedFile.getParentFile();
            if (parent != null) {
                parent.mkdirs();
            }
            TCRollingFileAppender.super.setFile(normalizedFile.getPath(), this.myAppend, this.myBufferedIO, this.myBufSize);
        }
    }
}

