/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import com.intellij.openapi.util.SystemInfo;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.Reader;
import jetbrains.buildServer.serverSide.TeamCityProperties;
import jetbrains.buildServer.util.FileUtil;
import jetbrains.buildServer.util.StringUtil;
import jetbrains.buildServer.vcs.patches.PatchStreamUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TCStreamUtil {
    static final int BUFFER_SIZE = 65536;

    public static void skip(@NotNull InputStream input, long size) throws IOException {
        if (input == null) {
            TCStreamUtil.$$$reportNull$$$0(0);
        }
        PatchStreamUtil.skip(input, size);
    }

    /*
     * WARNING - void declaration
     */
    public static void writeBinary(@NotNull InputStream input, long length, @NotNull OutputStream outputStream) throws IOException {
        void output;
        if (input == null) {
            TCStreamUtil.$$$reportNull$$$0(1);
        }
        if (outputStream == null) {
            TCStreamUtil.$$$reportNull$$$0(2);
        }
        PatchStreamUtil.writeBinary(input, length, (OutputStream)output);
    }

    private static byte[] getByteBuffer() {
        return new byte[TeamCityProperties.getInteger("teamcity.streamUtil.bufferSize", 65536)];
    }

    public static void writeBinary(InputStream input, OutputStream output) throws IOException {
        TCStreamUtil.writeBinary(input, output, null, 0L);
    }

    public static void writeBinary(@NotNull InputStream input, @NotNull OutputStream output, @Nullable WriteProgressListener listener, long minProgressIntervalMillis) throws IOException {
        if (input == null) {
            TCStreamUtil.$$$reportNull$$$0(3);
        }
        if (output == null) {
            TCStreamUtil.$$$reportNull$$$0(4);
        }
        byte[] buffer = TCStreamUtil.getByteBuffer();
        long totalRead = 0L;
        long reportedTime = System.nanoTime();
        long minProgressIntervalNanos = minProgressIntervalMillis * 1000000L;
        int read = 0;
        while (read != -1) {
            read = input.read(buffer, 0, buffer.length);
            if (read == -1) continue;
            output.write(buffer, 0, read);
            if (listener == null) continue;
            if (listener.isInterrupted()) {
                throw new InterruptedIOException();
            }
            totalRead += (long)read;
            long currentTime = System.nanoTime();
            if (currentTime - reportedTime < minProgressIntervalNanos) continue;
            listener.nextPortionWritten(totalRead, false);
            reportedTime = currentTime;
        }
        if (listener != null) {
            listener.nextPortionWritten(totalRead, true);
        }
        if (output instanceof BufferedOutputStream) {
            output.flush();
        }
    }

    public static boolean setFileMode(@Nullable File file, @NotNull String mode) throws IOException {
        if (mode == null) {
            TCStreamUtil.$$$reportNull$$$0(5);
        }
        if (SystemInfo.isWindows || file == null || !file.exists()) {
            return true;
        }
        try {
            return TCStreamUtil.execCommand(new String[]{"chmod", mode, file.getAbsolutePath()});
        }
        catch (Throwable th) {
            throw new IOException(th.getLocalizedMessage());
        }
    }

    private static boolean execCommand(String[] commandLine) throws Exception {
        Process process = Runtime.getRuntime().exec(commandLine);
        FileUtil.closeAll(process.getErrorStream(), process.getInputStream(), process.getOutputStream());
        return process.waitFor() == 0;
    }

    @Nullable
    public static String readString(@NotNull DataInputStream input) throws IOException {
        int length;
        if (input == null) {
            TCStreamUtil.$$$reportNull$$$0(6);
        }
        if ((length = input.readInt()) == -1) {
            return null;
        }
        char[] chars = new char[length];
        for (int i = 0; i < length; ++i) {
            chars[i] = input.readChar();
        }
        return new String(chars);
    }

    public static void writeString(@NotNull DataOutputStream outputStream, @NotNull String string) throws IOException {
        if (outputStream == null) {
            TCStreamUtil.$$$reportNull$$$0(7);
        }
        if (string == null) {
            TCStreamUtil.$$$reportNull$$$0(8);
        }
        outputStream.writeInt(string.length());
        for (int i = 0; i < string.length(); ++i) {
            outputStream.writeChar(string.charAt(i));
        }
    }

    public static boolean haveEqualContent(@NotNull InputStream stream1, @NotNull InputStream stream2) {
        if (stream1 == null) {
            TCStreamUtil.$$$reportNull$$$0(9);
        }
        if (stream2 == null) {
            TCStreamUtil.$$$reportNull$$$0(10);
        }
        int size = 4096;
        byte[] buf1 = new byte[size];
        byte[] buf2 = new byte[size];
        try {
            int count2;
            int count1;
            while ((count1 = TCStreamUtil.readFully(stream1, buf1)) == (count2 = TCStreamUtil.readFully(stream2, buf2))) {
                for (int i = 0; i < count1; ++i) {
                    if (buf1[i] == buf2[i]) continue;
                    return false;
                }
                if (count1 >= size) continue;
                return true;
            }
            return false;
        }
        catch (IOException e) {
            return false;
        }
    }

    private static int readFully(@NotNull InputStream stream, @NotNull byte[] buffer) throws IOException {
        int count;
        if (stream == null) {
            TCStreamUtil.$$$reportNull$$$0(11);
        }
        if (buffer == null) {
            TCStreamUtil.$$$reportNull$$$0(12);
        }
        int result = 0;
        for (int length = buffer.length; result < length; result += count, length -= count) {
            count = stream.read(buffer, result, length);
            if (count != -1) continue;
            return result;
        }
        return result;
    }

    public static boolean haveEqualContentIgnoringLineEndings(Reader reader1, Reader reader2) throws IOException {
        BufferedReader bufferedReader1 = new BufferedReader(reader1);
        BufferedReader bufferedReader2 = new BufferedReader(reader2);
        String line1 = bufferedReader1.readLine();
        String line2 = bufferedReader2.readLine();
        while (line1 != null && line2 != null) {
            if (!line1.equals(line2)) {
                return false;
            }
            line1 = bufferedReader1.readLine();
            line2 = bufferedReader2.readLine();
        }
        if (line1 == null && line2 == null) {
            return true;
        }
        if (line1 == null) {
            while (line2 != null) {
                if (!StringUtil.isEmptyOrSpaces((String)line2)) {
                    return false;
                }
                line2 = bufferedReader2.readLine();
            }
        }
        while (line1 != null) {
            if (!StringUtil.isEmptyOrSpaces((String)line1)) {
                return false;
            }
            line1 = bufferedReader1.readLine();
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "output";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mode";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputStream";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "string";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream1";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream2";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buffer";
                break;
            }
        }
        objectArray2[1] = "jetbrains/buildServer/util/TCStreamUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "skip";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "writeBinary";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "setFileMode";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "readString";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "writeString";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "haveEqualContent";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "readFully";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public static abstract class ProgressIncrementListener
    implements WriteProgressListener {
        private long myWrittenSoFar = 0L;

        @Override
        public void nextPortionWritten(long writtenSoFar, boolean finished) {
            if (writtenSoFar != this.myWrittenSoFar) {
                this.increment(writtenSoFar - this.myWrittenSoFar);
                this.myWrittenSoFar = writtenSoFar;
            }
        }

        @Override
        public boolean isInterrupted() {
            return false;
        }

        public abstract void increment(long var1);
    }

    public static interface WriteProgressListener {
        public void nextPortionWritten(long var1, boolean var3);

        public boolean isInterrupted();
    }
}

