/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import jetbrains.buildServer.serverSide.TeamCityProperties;
import jetbrains.buildServer.util.Disposable;
import jetbrains.buildServer.util.NoOpTraceState;
import jetbrains.buildServer.util.TraceState;
import jetbrains.buildServer.util.TraceStateImpl;
import jetbrains.buildServer.util.TraceStateWithPerf;
import org.jetbrains.annotations.NotNull;

public final class ThreadStat {
    public static final String THREAD_STAT_ENABLED_PROP = "teamcity.diagnostics.threadStatEnabled";
    public static final String THREAD_PERF_STATISTICS_ENABLED = "teamcity.diagnostics.threadPerfStat.enabled";
    public static final String THREAD_STAT_MAX_OPERATIONS_PROP = "teamcity.diagnostics.threadStat.maxOperations";
    private static final TraceState ourNoOpState = new NoOpTraceState();
    private static final ThreadLocal<TraceState> ourTraceState = new ThreadLocal<TraceState>(){

        @Override
        protected TraceState initialValue() {
            return ourNoOpState;
        }
    };

    @NotNull
    public static TraceState get() {
        TraceState traceState = ourTraceState.get();
        if (traceState == null) {
            ThreadStat.$$$reportNull$$$0(0);
        }
        return traceState;
    }

    public static void init() {
        ourTraceState.set(ThreadStat.isEnabled() ? ThreadStat.getTraceState() : ourNoOpState);
    }

    @NotNull
    public static TraceState getTraceState() {
        TraceState traceState = ThreadStat.isPerfStatEnabled() ? new TraceStateWithPerf() : new TraceStateImpl();
        if (traceState == null) {
            ThreadStat.$$$reportNull$$$0(1);
        }
        return traceState;
    }

    public static void reset() {
        ourTraceState.remove();
    }

    public static boolean isEnabled() {
        return TeamCityProperties.getBoolean(THREAD_STAT_ENABLED_PROP);
    }

    public static boolean isPerfStatEnabled() {
        if (TeamCityProperties.isInitialized()) {
            return TeamCityProperties.getBoolean(THREAD_PERF_STATISTICS_ENABLED);
        }
        return Boolean.getBoolean(THREAD_PERF_STATISTICS_ENABLED);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "jetbrains/buildServer/util/ThreadStat";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "get";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getTraceState";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    public static interface OperationDisposable
    extends Disposable {
        public int getLevel();

        @NotNull
        public String getDescription();

        public long getStartNanos();
    }

    public static interface ThreadOperation {
        public int getLevel();

        @NotNull
        public String getDescription();

        public long getStartNanos();

        public long getDurationNanos();
    }
}

