/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import jetbrains.buildServer.log.Loggers;
import org.jetbrains.annotations.NotNull;

public final class ThreadUtil {
    private ThreadUtil() {
    }

    public static void shutdownGracefully(@NotNull ExecutorService service, @NotNull String identifier) {
        if (service == null) {
            ThreadUtil.$$$reportNull$$$0(0);
        }
        if (identifier == null) {
            ThreadUtil.$$$reportNull$$$0(1);
        }
        ThreadUtil.shutdownGracefully(service, identifier, 5000L, 30000L);
    }

    /*
     * WARNING - void declaration
     */
    public static void shutdownGracefully(@NotNull ExecutorService service, @NotNull String identifier, long shutdownAwaitTimeout, long l) {
        if (service == null) {
            ThreadUtil.$$$reportNull$$$0(2);
        }
        if (identifier == null) {
            ThreadUtil.$$$reportNull$$$0(3);
        }
        if (service instanceof ThreadPoolExecutor) {
            ThreadPoolExecutor poolExecutor = (ThreadPoolExecutor)service;
            poolExecutor.getQueue().clear();
        }
        service.shutdown();
        try {
            void shutdownNowAwaitTimeout;
            service.awaitTermination(shutdownAwaitTimeout, TimeUnit.MILLISECONDS);
            if (!service.isTerminated()) {
                Loggers.SERVER.warn("Waiting for " + identifier + " to complete");
            }
            service.shutdownNow();
            service.awaitTermination((long)shutdownNowAwaitTimeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Loggers.SERVER.warn("Interrupted while waiting for " + identifier + " to terminate");
        }
        if (!service.isTerminated()) {
            Loggers.SERVER.warn("Stopped waiting for " + identifier + " to complete, some of the tasks are still running");
        }
    }

    public static void shutdownNowAndWait(@NotNull ExecutorService service, @NotNull String identifier) {
        if (service == null) {
            ThreadUtil.$$$reportNull$$$0(4);
        }
        if (identifier == null) {
            ThreadUtil.$$$reportNull$$$0(5);
        }
        try {
            service.shutdownNow();
            service.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Loggers.SERVER.warn("Interrupted while waiting for " + identifier + " to terminate");
        }
        if (!service.isTerminated()) {
            Loggers.SERVER.warn("Stopped waiting for " + identifier + " to complete, some of the tasks are still running");
        }
    }

    @NotNull
    public static Map<Future, Throwable> waitForTasks(@NotNull Collection<Future> futures) {
        if (futures == null) {
            ThreadUtil.$$$reportNull$$$0(6);
        }
        HashMap<Future, Throwable> errors = new HashMap<Future, Throwable>();
        Iterator<Future> iterator = futures.iterator();
        while (iterator.hasNext()) {
            Future f = iterator.next();
            try {
                f.get();
            }
            catch (InterruptedException e) {
                errors.put(f, e);
                while (iterator.hasNext()) {
                    errors.put(iterator.next(), e);
                }
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause() != null ? e.getCause() : e;
                errors.put(f, cause);
            }
        }
        HashMap<Future, Throwable> hashMap = errors;
        if (hashMap == null) {
            ThreadUtil.$$$reportNull$$$0(7);
        }
        return hashMap;
    }

    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public static void awaitLatch(CountDownLatch latch) {
        try {
            latch.await();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "service";
                break;
            }
            case 1: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "identifier";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "futures";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/util/ThreadUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/util/ThreadUtil";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "waitForTasks";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "shutdownGracefully";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "shutdownNowAndWait";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "waitForTasks";
                break;
            }
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

