/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import org.jetbrains.annotations.NotNull;

public final class TimePrinter {
    private final boolean myAlwaysPrintSeconds;
    private final TimeFormat myTimeFormat;

    private TimePrinter(boolean alwaysPrintSeconds, @NotNull TimeFormat timeFormat) {
        if (timeFormat == null) {
            TimePrinter.$$$reportNull$$$0(0);
        }
        this.myAlwaysPrintSeconds = alwaysPrintSeconds;
        this.myTimeFormat = timeFormat;
    }

    @NotNull
    public static TimePrinter createSecondsFormatter(boolean noRounding) {
        TimePrinter timePrinter = new TimePrinter(noRounding, TimeFormat.SECONDS);
        if (timePrinter == null) {
            TimePrinter.$$$reportNull$$$0(1);
        }
        return timePrinter;
    }

    @NotNull
    public static TimePrinter createMillisecondsFormatter() {
        TimePrinter timePrinter = new TimePrinter(true, TimeFormat.MILLISECONDS);
        if (timePrinter == null) {
            TimePrinter.$$$reportNull$$$0(2);
        }
        return timePrinter;
    }

    @Deprecated
    public void formatTime(@NotNull StringBuilder sb, long timeToFormat) {
        if (sb == null) {
            TimePrinter.$$$reportNull$$$0(3);
        }
        sb.append(this.formatTime(timeToFormat));
    }

    @NotNull
    public String formatTime(long time) {
        long processedTime;
        if (time < 0L) {
            if ("N/A" == null) {
                TimePrinter.$$$reportNull$$$0(4);
            }
            return "N/A";
        }
        if (time == 0L) {
            String string = this.myTimeFormat.isSeconds() ? "< 1s" : "< 1ms";
            if (string == null) {
                TimePrinter.$$$reportNull$$$0(5);
            }
            return string;
        }
        StringBuilder builder = new StringBuilder();
        int multiplier = this.myTimeFormat.isMillis() ? 1000 : 1;
        int maxLevel = 0;
        long timeToFormat = time;
        if (timeToFormat > (long)(172800 * multiplier)) {
            processedTime = this.process(builder, timeToFormat, 86400 * multiplier, "d");
            timeToFormat -= processedTime;
            if (processedTime > 0L) {
                maxLevel = 4;
            }
        }
        processedTime = this.process(builder, timeToFormat, 3600 * multiplier, "h");
        timeToFormat -= processedTime;
        if (maxLevel == 0 && processedTime > 0L) {
            maxLevel = 3;
        }
        if (this.myAlwaysPrintSeconds || this.myTimeFormat.isMillis() || maxLevel < 4) {
            timeToFormat -= this.process(builder, timeToFormat, 60 * multiplier, "m");
        }
        if (this.myAlwaysPrintSeconds || this.myTimeFormat.isMillis() || maxLevel < 3) {
            timeToFormat -= this.process(builder, timeToFormat, multiplier, "s");
        }
        if (this.myTimeFormat.isMillis()) {
            if (timeToFormat > 0L) {
                if (builder.length() > 0) {
                    builder.append(",");
                    if (timeToFormat < 10L) {
                        builder.append("0");
                    }
                    if (timeToFormat < 100L) {
                        builder.append("0");
                    }
                }
                builder.append(timeToFormat).append("ms");
            } else if (builder.length() > 0) {
                builder.append(",000ms");
            }
        }
        String string = builder.toString();
        if (string == null) {
            TimePrinter.$$$reportNull$$$0(6);
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private long process(@NotNull StringBuilder sb, long time, int multiplier, @NotNull String string) {
        void periodName;
        long periodTimes;
        if (sb == null) {
            TimePrinter.$$$reportNull$$$0(7);
        }
        if (string == null) {
            TimePrinter.$$$reportNull$$$0(8);
        }
        if ((periodTimes = time / (long)multiplier) > 0L) {
            if (sb.length() > 0) {
                sb.append(":");
                if (periodTimes < 10L) {
                    sb.append("0");
                }
            }
            sb.append(periodTimes).append((String)periodName);
            return periodTimes * (long)multiplier;
        }
        if (this.myAlwaysPrintSeconds && sb.length() > 0) {
            sb.append(":0").append((String)periodName);
        }
        return 0L;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timeFormat";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/util/TimePrinter";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sb";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "periodName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/util/TimePrinter";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "createSecondsFormatter";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createMillisecondsFormatter";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "formatTime";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "formatTime";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "process";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static enum TimeFormat {
        SECONDS,
        MILLISECONDS;


        boolean isSeconds() {
            return this == SECONDS;
        }

        boolean isMillis() {
            return this == MILLISECONDS;
        }
    }
}

