/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import jetbrains.buildServer.util.Dates;
import jetbrains.buildServer.util.ExceptionUtil;
import jetbrains.buildServer.util.NamedThreadFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TimedExecutor {
    @NotNull
    private final ExecutorService myExecutor;

    @NotNull
    public static TimedExecutor withCachedThreadPool(@NotNull String name) {
        if (name == null) {
            TimedExecutor.$$$reportNull$$$0(0);
        }
        TimedExecutor timedExecutor = TimedExecutor.withCachedThreadPool(name, 60L * Dates.ONE_SECOND);
        if (timedExecutor == null) {
            TimedExecutor.$$$reportNull$$$0(1);
        }
        return timedExecutor;
    }

    @NotNull
    public static TimedExecutor withCachedThreadPool(@NotNull String name, long keepAliveMilliseconds) {
        if (name == null) {
            TimedExecutor.$$$reportNull$$$0(2);
        }
        TimedExecutor timedExecutor = new TimedExecutor(0, Integer.MAX_VALUE, keepAliveMilliseconds, new SynchronousQueue<Runnable>(), name);
        if (timedExecutor == null) {
            TimedExecutor.$$$reportNull$$$0(3);
        }
        return timedExecutor;
    }

    @NotNull
    public static TimedExecutor withSingleThreadPool(@NotNull String name) {
        if (name == null) {
            TimedExecutor.$$$reportNull$$$0(4);
        }
        TimedExecutor timedExecutor = TimedExecutor.withFixedThreadPool(1, name);
        if (timedExecutor == null) {
            TimedExecutor.$$$reportNull$$$0(5);
        }
        return timedExecutor;
    }

    @NotNull
    public static TimedExecutor withFixedThreadPool(int threadCount, @NotNull String name) {
        if (name == null) {
            TimedExecutor.$$$reportNull$$$0(6);
        }
        TimedExecutor timedExecutor = new TimedExecutor(threadCount, threadCount, 0L, new LinkedBlockingQueue<Runnable>(), name);
        if (timedExecutor == null) {
            TimedExecutor.$$$reportNull$$$0(7);
        }
        return timedExecutor;
    }

    /*
     * WARNING - void declaration
     */
    private TimedExecutor(int coreThreadCount, int maxThreadCount, long keepAliveMilliseconds, @NotNull BlockingQueue<Runnable> workQueue, @NotNull String string) {
        void name;
        if (workQueue == null) {
            TimedExecutor.$$$reportNull$$$0(8);
        }
        if (string == null) {
            TimedExecutor.$$$reportNull$$$0(9);
        }
        this.myExecutor = new ThreadPoolExecutor(coreThreadCount, maxThreadCount, keepAliveMilliseconds, TimeUnit.MILLISECONDS, workQueue, new NamedThreadFactory((String)name));
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public <T> T execute(long timeoutMilliseconds, @NotNull Callable<T> callable) {
        void task;
        if (callable == null) {
            TimedExecutor.$$$reportNull$$$0(10);
        }
        return this.execute(timeoutMilliseconds, (Class)RuntimeException.class, (Callable<T>)task);
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public <T, E extends Throwable> T execute(long timeoutMilliseconds, @NotNull Class<E> exceptionClazz, @NotNull Callable<T> callable) throws E {
        if (exceptionClazz == null) {
            TimedExecutor.$$$reportNull$$$0(11);
        }
        if (callable == null) {
            TimedExecutor.$$$reportNull$$$0(12);
        }
        Future future = null;
        try {
            void task;
            future = this.myExecutor.submit(task);
            return future.get(timeoutMilliseconds, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        catch (ExecutionException e) {
            Throwable cause = e.getCause();
            if (exceptionClazz.isInstance(cause)) {
                throw (Throwable)exceptionClazz.cast(cause);
            }
            if (cause != null) {
                ExceptionUtil.rethrowAsRuntimeException(cause);
            }
            throw new RuntimeException(e);
        }
        catch (TimeoutException e) {
            future.cancel(true);
            return null;
        }
    }

    public void dispose() {
        this.myExecutor.shutdownNow();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/util/TimedExecutor";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "workQueue";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "task";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionClazz";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/util/TimedExecutor";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "withCachedThreadPool";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "withSingleThreadPool";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "withFixedThreadPool";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "withCachedThreadPool";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "withSingleThreadPool";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "withFixedThreadPool";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "execute";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

