/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import gnu.trove.TLongArrayList;
import gnu.trove.list.array.TIntArrayList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import jetbrains.buildServer.serverSide.TeamCityProperties;
import jetbrains.buildServer.util.ThreadStat;
import jetbrains.buildServer.util.TraceState;
import org.jetbrains.annotations.NotNull;

public class TraceStateImpl
implements TraceState {
    public static final String OWN_TIME_SUPPORT = "teamcity.diagnostics.threadStat.ownTimeSupport";
    private final TIntArrayList myLevels = new TIntArrayList();
    private final ArrayList<String> myDescriptions = new ArrayList();
    private final TLongArrayList myStarts = new TLongArrayList();
    private final TLongArrayList myFinishes = new TLongArrayList();
    private int myIndex = 0;
    private int myCurrentLevel = 0;
    private final int myMaxOperations = TeamCityProperties.getInteger("teamcity.diagnostics.threadStat.maxOperations", 10000);

    @Override
    @NotNull
    public ThreadStat.OperationDisposable startOperation(@NotNull String operationDescription) {
        if (operationDescription == null) {
            TraceStateImpl.$$$reportNull$$$0(0);
        }
        String description = operationDescription;
        final long nanoTime = System.nanoTime();
        if (this.myStarts.size() == this.myMaxOperations) {
            description = "Number of operations reached the limit: " + this.myMaxOperations + ", all subsequent operations are discarded";
        } else if (this.myStarts.size() > this.myMaxOperations) {
            ThreadStat.OperationDisposable operationDisposable = new ThreadStat.OperationDisposable(){

                @Override
                public int getLevel() {
                    return TraceStateImpl.this.myCurrentLevel;
                }

                @Override
                @NotNull
                public String getDescription() {
                    if ("do nothing" == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return "do nothing";
                }

                @Override
                public long getStartNanos() {
                    return nanoTime;
                }

                @Override
                public void dispose() {
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/TraceStateImpl$1", "getDescription"));
                }
            };
            if (operationDisposable == null) {
                TraceStateImpl.$$$reportNull$$$0(1);
            }
            return operationDisposable;
        }
        this.myLevels.add(this.myCurrentLevel);
        this.myDescriptions.add(description);
        this.myStarts.add(nanoTime);
        this.myFinishes.add(nanoTime);
        OperationDisposableImpl operationDisposableImpl = new OperationDisposableImpl(this.myIndex++, this.myCurrentLevel++);
        if (operationDisposableImpl == null) {
            TraceStateImpl.$$$reportNull$$$0(2);
        }
        return operationDisposableImpl;
    }

    @Override
    @NotNull
    public Iterator<ThreadStat.ThreadOperation> getOperations() {
        if (TeamCityProperties.getBooleanOrTrue(OWN_TIME_SUPPORT)) {
            OwnTimeAwareOperationIterator ownTimeAwareOperationIterator = new OwnTimeAwareOperationIterator(this.myIndex, TeamCityProperties.getInteger("teamcity.diagnostics.threadStat.ownTimeThreshold.ns", 1000));
            if (ownTimeAwareOperationIterator == null) {
                TraceStateImpl.$$$reportNull$$$0(3);
            }
            return ownTimeAwareOperationIterator;
        }
        OperationIterator operationIterator = new OperationIterator(this.myIndex);
        if (operationIterator == null) {
            TraceStateImpl.$$$reportNull$$$0(4);
        }
        return operationIterator;
    }

    @Override
    public int getNumberOfOperations() {
        return this.myStarts.size();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operationDescription";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/util/TraceStateImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/util/TraceStateImpl";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "startOperation";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOperations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "startOperation";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class OperationDisposableImpl
    implements ThreadStat.OperationDisposable {
        private final int myOperationIndex;
        private final int myOldLevel;

        public OperationDisposableImpl(int operationIndex, int oldLevel) {
            this.myOperationIndex = operationIndex;
            this.myOldLevel = oldLevel;
        }

        @Override
        public void dispose() {
            TraceStateImpl.this.myFinishes.set(this.myOperationIndex, System.nanoTime());
            if (TraceStateImpl.this.myCurrentLevel > this.myOldLevel) {
                TraceStateImpl.this.myCurrentLevel = this.myOldLevel;
            }
        }

        @Override
        public int getLevel() {
            return TraceStateImpl.this.myLevels.get(this.myOperationIndex);
        }

        @Override
        @NotNull
        public String getDescription() {
            String string = (String)TraceStateImpl.this.myDescriptions.get(this.myOperationIndex);
            if (string == null) {
                OperationDisposableImpl.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public long getStartNanos() {
            return TraceStateImpl.this.myStarts.get(this.myOperationIndex);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/TraceStateImpl$OperationDisposableImpl", "getDescription"));
        }
    }

    private class ThreadOperationImpl
    implements ThreadStat.ThreadOperation {
        private final int myLevel;
        private final String myDescription;
        private final long myStartNanos;
        private final long myDurationNanos;

        /*
         * WARNING - void declaration
         */
        public ThreadOperationImpl(@NotNull int level, String description, long startNanos, long l) {
            void finishNanos;
            if (description == null) {
                ThreadOperationImpl.$$$reportNull$$$0(0);
            }
            this.myLevel = level;
            this.myDescription = description;
            this.myStartNanos = startNanos;
            this.myDurationNanos = finishNanos - startNanos;
        }

        @Override
        public int getLevel() {
            return this.myLevel;
        }

        @Override
        @NotNull
        public String getDescription() {
            String string = this.myDescription;
            if (string == null) {
                ThreadOperationImpl.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Override
        public long getStartNanos() {
            return this.myStartNanos;
        }

        @Override
        public long getDurationNanos() {
            if (this.myDurationNanos >= 0L) {
                return this.myDurationNanos;
            }
            return System.nanoTime() - this.myStartNanos;
        }

        public String toString() {
            return "ThreadOperationImpl{level=" + this.myLevel + ", description='" + this.myDescription + '\'' + ", startNanos=" + this.myStartNanos + ", durationNanos=" + this.myDurationNanos + '}';
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 1: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 1: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "description";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "jetbrains/buildServer/util/TraceStateImpl$ThreadOperationImpl";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "jetbrains/buildServer/util/TraceStateImpl$ThreadOperationImpl";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getDescription";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 1: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 1: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    private class OwnTimeAwareOperationIterator
    implements Iterator<ThreadStat.ThreadOperation> {
        private final int myMaxIndex;
        private int myIndex = 0;
        private boolean myReportedOwnBeforeOp = true;
        private final List<ThreadOperationImpl> myNextOwnOps = new LinkedList<ThreadOperationImpl>();
        private final int myOwnOpDurationThreshold;

        public OwnTimeAwareOperationIterator(int maxIndex, int ownOpDurationThreshold) {
            this.myMaxIndex = maxIndex;
            this.myOwnOpDurationThreshold = ownOpDurationThreshold;
        }

        @Override
        public boolean hasNext() {
            return this.myIndex < this.myMaxIndex || !this.myNextOwnOps.isEmpty();
        }

        @Override
        public ThreadStat.ThreadOperation next() {
            if (!this.myNextOwnOps.isEmpty()) {
                return this.myNextOwnOps.remove(0);
            }
            if (!this.myReportedOwnBeforeOp) {
                this.myReportedOwnBeforeOp = true;
                long opStart = this.getTimeForBeforeBlock(this.myIndex);
                long opFinish = TraceStateImpl.this.myStarts.get(this.myIndex);
                if (opFinish - opStart > (long)this.myOwnOpDurationThreshold) {
                    return new ThreadOperationImpl(TraceStateImpl.this.myLevels.get(this.myIndex), "Own", opStart, opFinish);
                }
            }
            ThreadOperationImpl op = new ThreadOperationImpl(TraceStateImpl.this.myLevels.get(this.myIndex), (String)TraceStateImpl.this.myDescriptions.get(this.myIndex), TraceStateImpl.this.myStarts.get(this.myIndex), TraceStateImpl.this.myFinishes.get(this.myIndex));
            this.initNextOwnOps();
            this.myReportedOwnBeforeOp = false;
            ++this.myIndex;
            return op;
        }

        private void initNextOwnOps() {
            this.myNextOwnOps.clear();
            int nextOpLevel = this.myIndex < this.myMaxIndex - 1 ? TraceStateImpl.this.myLevels.get(this.myIndex + 1) : 0;
            int currentBlockLevel = TraceStateImpl.this.myLevels.get(this.myIndex);
            int lastAddedOwnOpIndex = this.myIndex;
            for (int i = this.myIndex - 1; currentBlockLevel > nextOpLevel && i >= 0; --i) {
                long opStart;
                if (TraceStateImpl.this.myLevels.get(i) >= currentBlockLevel) continue;
                if (this.myNextOwnOps.isEmpty()) {
                    opStart = TraceStateImpl.this.myFinishes.get(lastAddedOwnOpIndex);
                } else {
                    ThreadOperationImpl prevOwnOp = this.myNextOwnOps.get(this.myNextOwnOps.size() - 1);
                    opStart = prevOwnOp.myStartNanos + prevOwnOp.myDurationNanos;
                }
                long opFinish = TraceStateImpl.this.myFinishes.get(i);
                if (opFinish - opStart >= (long)this.myOwnOpDurationThreshold) {
                    this.myNextOwnOps.add(new ThreadOperationImpl(TraceStateImpl.this.myLevels.get(i) + 1, "Own", opStart, opFinish));
                }
                currentBlockLevel = TraceStateImpl.this.myLevels.get(i);
            }
        }

        private long getTimeForBeforeBlock(int index) {
            int currentBlockLevel;
            int prevBlockLevel = TraceStateImpl.this.myLevels.get(index - 1);
            if (prevBlockLevel >= (currentBlockLevel = TraceStateImpl.this.myLevels.get(index))) {
                return TraceStateImpl.this.myFinishes.get(index - 1);
            }
            return TraceStateImpl.this.myStarts.get(index - 1);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class OperationIterator
    implements Iterator<ThreadStat.ThreadOperation> {
        private final int myMaxIndex;
        private int myIndex = 0;

        public OperationIterator(int maxIndex) {
            this.myMaxIndex = maxIndex;
        }

        @Override
        public boolean hasNext() {
            return this.myIndex < this.myMaxIndex;
        }

        @Override
        public ThreadStat.ThreadOperation next() {
            ThreadOperationImpl op = new ThreadOperationImpl(TraceStateImpl.this.myLevels.get(this.myIndex), (String)TraceStateImpl.this.myDescriptions.get(this.myIndex), TraceStateImpl.this.myStarts.get(this.myIndex), TraceStateImpl.this.myFinishes.get(this.myIndex));
            ++this.myIndex;
            return op;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

