/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import com.intellij.openapi.diagnostic.Logger;
import java.util.Iterator;
import java.util.Locale;
import java.util.concurrent.TimeUnit;
import jetbrains.buildServer.log.LogUtil;
import jetbrains.buildServer.serverSide.TeamCityProperties;
import jetbrains.buildServer.util.NamedThreadUtil;
import jetbrains.buildServer.util.StringUtil;
import jetbrains.buildServer.util.ThreadStat;
import jetbrains.buildServer.util.TimePrinter;
import jetbrains.buildServer.util.TraceState;
import jetbrains.buildServer.util.TraceStateImpl;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TraceStateWithPerf
implements TraceState {
    public static final String THREAD_STAT_CATEGORY = "jetbrains.buildServer.diagnostic.threadStat";
    private static final Logger LOG_ALLOC = Logger.getInstance((String)"jetbrains.buildServer.diagnostic.threadStat");
    public static final String PERF_ACTIVE = "teamcity.diagnostics.threadPerfStat.active";
    public static final String PERF_STAT_MAX_LEVEL = "teamcity.diagnostics.threadPerfStat.maxLevel";
    public static final String UPDATE_CACHED = "teamcity.diagnostics.threadPerfStat.updateCached";
    public static final String THREAD_STAT_LOGGING_THRESHOLD_PROP = "teamcity.diagnostics.threadPerfStat.memoryAllocations.logThreshold";
    public static final String THREAD_STAT_LOGGING_THRESHOLD_PROP_BYTES = "teamcity.diagnostics.threadPerfStat.memoryAllocations.logThreshold.bytes";
    private final boolean myCollectPerfStat;
    private final int myMaxLevelToPerfStat;
    @NotNull
    private final TraceState myDelegate = new TraceStateImpl();
    private int myLevel = 0;
    protected static final long DEFAULT_LOG_DURATION_THRESHOLD = TimeUnit.MILLISECONDS.convert(10L, TimeUnit.MINUTES);

    public TraceStateWithPerf() {
        this.myCollectPerfStat = TeamCityProperties.getBooleanOrTrue(PERF_ACTIVE);
        this.myMaxLevelToPerfStat = TeamCityProperties.getInteger(PERF_STAT_MAX_LEVEL, 1);
    }

    @Override
    @NotNull
    public ThreadStat.OperationDisposable startOperation(@NotNull String operationDescription) {
        if (operationDescription == null) {
            TraceStateWithPerf.$$$reportNull$$$0(0);
        }
        ThreadStat.OperationDisposable operation = this.myDelegate.startOperation(operationDescription);
        boolean shouldLogPerfStat = this.myCollectPerfStat && this.myLevel <= this.myMaxLevelToPerfStat;
        ++this.myLevel;
        if (!shouldLogPerfStat) {
            CustomDisposableOperation customDisposableOperation = new CustomDisposableOperation(operation){

                @Override
                protected void beforeDispose() {
                    TraceStateWithPerf.this.myLevel--;
                }
            };
            if (customDisposableOperation == null) {
                TraceStateWithPerf.$$$reportNull$$$0(1);
            }
            return customDisposableOperation;
        }
        final NamedThreadUtil.PerfStat startPerfStat = NamedThreadUtil.getCurrentStats(Thread.currentThread(), this.isUpdateCachedPerfStat());
        final long startNanos = System.nanoTime();
        CustomDisposableOperation customDisposableOperation = new CustomDisposableOperation(operation){

            @Override
            protected void beforeDispose() {
                TraceStateWithPerf.this.myLevel--;
                TraceStateWithPerf.logIfNecessary(startPerfStat, startNanos, TraceStateWithPerf.this.myLevel);
            }
        };
        if (customDisposableOperation == null) {
            TraceStateWithPerf.$$$reportNull$$$0(2);
        }
        return customDisposableOperation;
    }

    private boolean isUpdateCachedPerfStat() {
        return TeamCityProperties.getBoolean(UPDATE_CACHED);
    }

    @Override
    @NotNull
    public Iterator<ThreadStat.ThreadOperation> getOperations() {
        Iterator<ThreadStat.ThreadOperation> iterator = this.myDelegate.getOperations();
        if (iterator == null) {
            TraceStateWithPerf.$$$reportNull$$$0(3);
        }
        return iterator;
    }

    @Override
    public int getNumberOfOperations() {
        return this.myDelegate.getNumberOfOperations();
    }

    private static void logIfNecessary(@Nullable NamedThreadUtil.PerfStat startStat, long startNanos, int level) {
        long durationNanos = System.nanoTime() - startNanos;
        boolean shouldLog = false;
        NamedThreadUtil.PerfStat diff = null;
        if (startStat != null) {
            diff = startStat.diffToCurrentState();
            if (diff.allocatedMemory != -1L && diff.allocatedMemory >= TraceStateWithPerf.getLogThreadAllocationThreshold()) {
                shouldLog = true;
            }
        }
        if (!shouldLog && durationNanos >= TimeUnit.NANOSECONDS.convert(TraceStateWithPerf.getLogDurationThreshold(), TimeUnit.MILLISECONDS)) {
            shouldLog = true;
        }
        if (shouldLog) {
            LOG_ALLOC.info(TraceStateWithPerf.getDetails(diff, level, durationNanos));
        }
    }

    @NotNull
    private static String getDetails(@Nullable NamedThreadUtil.PerfStat perfStat, int level, long durationNanos) {
        StringBuilder result = new StringBuilder();
        if (level == 0) {
            result.append("Task");
        } else {
            result.append("Sub-task level ").append(level);
        }
        result.append(" finished in ").append(TimePrinter.createMillisecondsFormatter().formatTime(TimeUnit.MILLISECONDS.convert(durationNanos, TimeUnit.NANOSECONDS)));
        if (perfStat != null) {
            result.append("; allocated memory: ").append(StringUtil.formatFileSize(perfStat.allocatedMemory));
            if (perfStat.cpuUsage != -1L && durationNanos > TraceStateWithPerf.getCpuUsageMinDurationToTrust()) {
                double cpuUsage = (double)perfStat.cpuUsage / (double)durationNanos;
                if (cpuUsage > 1.0E-4) {
                    result.append(", used CPU: ");
                    result.append(String.format(Locale.ENGLISH, "%.4f", cpuUsage));
                }
                if (TraceStateWithPerf.getCpuUsageLogAsRaw()) {
                    result.append(" (").append(perfStat.cpuUsage).append(")");
                }
            }
        }
        result.append(" - ").append(LogUtil.quote(Thread.currentThread().getName()));
        String string = result.toString();
        if (string == null) {
            TraceStateWithPerf.$$$reportNull$$$0(4);
        }
        return string;
    }

    private static long getLogThreadAllocationThreshold() {
        String property = TeamCityProperties.getPropertyOrNull(THREAD_STAT_LOGGING_THRESHOLD_PROP);
        if (property != null) {
            try {
                return StringUtil.parseFileSize(property);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return TeamCityProperties.getLong(THREAD_STAT_LOGGING_THRESHOLD_PROP_BYTES, 0x40000000L);
    }

    private static long getLogDurationThreshold() {
        return TeamCityProperties.getLong("teamcity.diagnostics.threadPerfStat.duration.logThreshold.ms", DEFAULT_LOG_DURATION_THRESHOLD);
    }

    private static long getCpuUsageMinDurationToTrust() {
        return TeamCityProperties.getLong("teamcity.diagnostics.threadPerfStat.cpuUsage.minDuration.nanos", TimeUnit.NANOSECONDS.convert(100L, TimeUnit.MILLISECONDS));
    }

    private static boolean getCpuUsageLogAsRaw() {
        String property = TeamCityProperties.getProperty("teamcity.diagnostics.threadPerfStat.cpuUsage.logFormat");
        return "raw".equals(property);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "operationDescription";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/util/TraceStateWithPerf";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/util/TraceStateWithPerf";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "startOperation";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getOperations";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getDetails";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "startOperation";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static abstract class CustomDisposableOperation
    implements ThreadStat.OperationDisposable {
        private final ThreadStat.OperationDisposable myDelegate;

        public CustomDisposableOperation(ThreadStat.OperationDisposable delegate) {
            this.myDelegate = delegate;
        }

        @Override
        public int getLevel() {
            return this.myDelegate.getLevel();
        }

        @Override
        @NotNull
        public String getDescription() {
            String string = this.myDelegate.getDescription();
            if (string == null) {
                CustomDisposableOperation.$$$reportNull$$$0(0);
            }
            return string;
        }

        @Override
        public long getStartNanos() {
            return this.myDelegate.getStartNanos();
        }

        @Override
        public void dispose() {
            this.beforeDispose();
            this.myDelegate.dispose();
        }

        protected abstract void beforeDispose();

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/TraceStateWithPerf$CustomDisposableOperation", "getDescription"));
        }
    }
}

