/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import java.util.concurrent.locks.ReentrantReadWriteLock;
import jetbrains.buildServer.util.SystemTimeService;
import jetbrains.buildServer.util.TimeService;
import org.jetbrains.annotations.NotNull;

public class UptodateValue<T> {
    private static final ValueProvider NO_PROVIDER = new ValueProvider<Object>(){

        @Override
        public Object getNewValue() {
            return null;
        }
    };
    private static final UpdateCallback NO_CALLBACK = new UpdateCallback<Object>(){

        @Override
        public void onValueChanged(Object o) {
        }
    };
    private final ValueProvider<T> myProvider;
    private final TimeToLiveProvider<T> myTtlProvider;
    private final ReentrantReadWriteLock myLock;
    @NotNull
    private final UpdateCallback<T> myUpdateCallback;
    private final TimeService myTimeService;
    private long myLastUpdateTime;
    private T myCachedValue;

    public UptodateValue(long timeToLiveMillis) {
        this(NO_PROVIDER, timeToLiveMillis);
    }

    public UptodateValue(@NotNull ValueProvider<T> provider, long timeToLiveMillis) {
        if (provider == null) {
            UptodateValue.$$$reportNull$$$0(0);
        }
        this(provider, timeToLiveMillis, SystemTimeService.getInstance());
    }

    /*
     * WARNING - void declaration
     */
    public UptodateValue(@NotNull ValueProvider<T> provider, long timeToLiveMillis, @NotNull UpdateCallback<T> updateCallback) {
        void onUpdate;
        if (provider == null) {
            UptodateValue.$$$reportNull$$$0(1);
        }
        if (updateCallback == null) {
            UptodateValue.$$$reportNull$$$0(2);
        }
        this(provider, new ConstantTTL(timeToLiveMillis), SystemTimeService.getInstance(), (UpdateCallback<T>)onUpdate);
    }

    /*
     * WARNING - void declaration
     */
    public UptodateValue(@NotNull ValueProvider<T> provider, long timeToLiveMillis, @NotNull TimeService timeService, @NotNull UpdateCallback<T> updateCallback) {
        void onUpdate;
        if (provider == null) {
            UptodateValue.$$$reportNull$$$0(3);
        }
        if (timeService == null) {
            UptodateValue.$$$reportNull$$$0(4);
        }
        if (updateCallback == null) {
            UptodateValue.$$$reportNull$$$0(5);
        }
        this(provider, new ConstantTTL(timeToLiveMillis), timeService, (UpdateCallback<T>)onUpdate);
    }

    public UptodateValue(ValueProvider<T> provider, long ttl, TimeService timeService) {
        this(provider, new ConstantTTL(ttl), timeService);
    }

    public UptodateValue(ValueProvider<T> provider, @NotNull TimeToLiveProvider<T> ttlProvider, TimeService timeService) {
        if (ttlProvider == null) {
            UptodateValue.$$$reportNull$$$0(6);
        }
        this(provider, ttlProvider, timeService, NO_CALLBACK);
    }

    private UptodateValue(ValueProvider<T> provider, @NotNull TimeToLiveProvider<T> ttlProvider, TimeService timeService, @NotNull UpdateCallback<T> onUpdate) {
        if (ttlProvider == null) {
            UptodateValue.$$$reportNull$$$0(7);
        }
        if (onUpdate == null) {
            UptodateValue.$$$reportNull$$$0(8);
        }
        this.myLock = new ReentrantReadWriteLock();
        this.myLastUpdateTime = -1L;
        this.myCachedValue = null;
        this.myProvider = provider;
        this.myTtlProvider = ttlProvider;
        this.myTimeService = timeService;
        this.myUpdateCallback = onUpdate;
    }

    public T getValue() {
        return this.fetchValue(this.myProvider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T fetchValue(ValueProvider<T> explicitProvider) {
        this.myLock.readLock().lock();
        try {
            if (this.isValid()) {
                T t = this.myCachedValue;
                return t;
            }
        }
        finally {
            this.myLock.readLock().unlock();
        }
        boolean valueUpdated = false;
        this.myLock.writeLock().lock();
        try {
            if (!this.isValid()) {
                T newValue = explicitProvider.getNewValue();
                valueUpdated = this.myLastUpdateTime == -1L || this.myUpdateCallback == NO_CALLBACK ? false : (newValue == null ? this.myCachedValue != null : !newValue.equals(this.myCachedValue));
                this.myCachedValue = newValue;
                this.myLastUpdateTime = this.myTimeService.now();
            }
        }
        finally {
            this.myLock.writeLock().unlock();
        }
        if (valueUpdated) {
            this.myUpdateCallback.onValueChanged(this.myCachedValue);
        }
        return this.myCachedValue;
    }

    public void reset() {
        boolean valueUpdated = false;
        this.myLock.writeLock().lock();
        try {
            valueUpdated = this.myCachedValue != null;
            this.myCachedValue = null;
        }
        finally {
            this.myLock.writeLock().unlock();
        }
        if (valueUpdated) {
            this.myUpdateCallback.onValueChanged(this.myCachedValue);
        }
    }

    private boolean isValid() {
        return this.myCachedValue != null && this.myTimeService.now() - this.myLastUpdateTime < this.myTtlProvider.getTimeToLiveMillis(this.myCachedValue);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "provider";
                break;
            }
            case 2: 
            case 5: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[0] = "onUpdate";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[0] = "timeService";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[0] = "ttlProvider";
                break;
            }
        }
        objectArray[1] = "jetbrains/buildServer/util/UptodateValue";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static class ConstantTTL<T>
    implements TimeToLiveProvider<T> {
        private final long myTtl;

        private ConstantTTL(long ttl) {
            this.myTtl = ttl;
        }

        @Override
        public long getTimeToLiveMillis(@NotNull T cachedValue) {
            if (cachedValue == null) {
                ConstantTTL.$$$reportNull$$$0(0);
            }
            return this.myTtl;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cachedValue", "jetbrains/buildServer/util/UptodateValue$ConstantTTL", "getTimeToLiveMillis"));
        }
    }

    public static interface UpdateCallback<T> {
        public void onValueChanged(T var1);
    }

    public static interface TimeToLiveProvider<T> {
        public long getTimeToLiveMillis(@NotNull T var1);
    }

    public static interface ValueProvider<T> {
        public T getNewValue();
    }
}

