/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import jetbrains.buildServer.util.IntervalMetric;
import jetbrains.buildServer.util.TimeService;
import org.jetbrains.annotations.NotNull;

public class Vars
implements Comparable<Vars> {
    private static final ConcurrentMap<String, IntervalMetric> ourCounters = new ConcurrentHashMap<String, IntervalMetric>();
    private static volatile TimeService ourTimeService;
    private final String myActionName;
    private IntervalMetric myCounterHolder;

    public static void inc(String actionName) {
        new Vars(actionName).increment();
    }

    public Vars(String actionName) {
        this.myActionName = actionName;
        this.myCounterHolder = ourCounters.putIfAbsent(this.myActionName, new IntervalMetric(IntervalMetric.ValueType.SIMPLE, IntervalMetric.DEFAULT_INTERVALS, this.myActionName, ourTimeService));
        if (this.myCounterHolder == null) {
            this.myCounterHolder = (IntervalMetric)ourCounters.get(this.myActionName);
        }
    }

    public static void resetCounters() {
        ourCounters.clear();
    }

    void increment() {
        this.myCounterHolder.add(1L);
    }

    public long getCount0() {
        return this.myCounterHolder.getValue(0);
    }

    public long getCount1() {
        return this.myCounterHolder.getValue(1);
    }

    public long getCount2() {
        return this.myCounterHolder.getValue(2);
    }

    public Date getLastModified() {
        long lastModified = this.myCounterHolder.getLastModified();
        return lastModified == 0L ? null : new Date(lastModified);
    }

    public String getName() {
        return this.myActionName;
    }

    public static Vars[] counters() {
        HashSet names = new HashSet(ourCounters.keySet());
        Object[] result = new Vars[names.size()];
        int i = 0;
        for (String counterName : names) {
            result[i++] = new Vars(counterName);
        }
        Arrays.sort(result);
        return result;
    }

    public static void reset() {
        ourCounters.clear();
    }

    public static void setTimeService(@NotNull TimeService timeService) {
        if (timeService == null) {
            Vars.$$$reportNull$$$0(0);
        }
        ourTimeService = timeService;
    }

    public static void dumpAsText() {
        for (Vars vars : Vars.counters()) {
            System.out.println(String.format("%5d: %s", vars.getCount0(), vars.getName()));
        }
        Vars.reset();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Vars that = (Vars)o;
        return this.myActionName.equals(that.myActionName);
    }

    public int hashCode() {
        return this.myActionName.hashCode();
    }

    @Override
    public int compareTo(Vars o) {
        return this.myActionName.compareTo(o.myActionName);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "timeService", "jetbrains/buildServer/util/Vars", "setTimeService"));
    }
}

