/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import java.lang.reflect.Method;
import java.util.concurrent.TimeUnit;
import jetbrains.buildServer.log.LogInitializer;
import jetbrains.buildServer.util.WatchDog;
import org.jetbrains.annotations.Nullable;

public abstract class WaitFor {
    private static final long DEFAULT_TIMEOUT_MS = TimeUnit.MINUTES.toMillis(2L);
    private long myPollIntervalMs = 3L;
    private boolean myConditionMet = false;

    protected WaitFor() {
        this(DEFAULT_TIMEOUT_MS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected WaitFor(@Nullable String optionalWatchDogName, long timeoutMs) {
        long started = System.currentTimeMillis();
        WatchDog watchDog = null;
        if (optionalWatchDogName != null) {
            watchDog = new WatchDog(optionalWatchDogName);
        }
        try {
            while (true) {
                if (this.condition()) {
                    this.myConditionMet = true;
                    return;
                }
                if (System.currentTimeMillis() - started >= timeoutMs) break;
                Thread.sleep(this.myPollIntervalMs);
            }
            if (LogInitializer.isUnitTest() && timeoutMs >= 1000L && !this.condition()) {
                this.dumpStack();
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            if (watchDog != null) {
                watchDog.stop();
            }
        }
    }

    protected void dumpStack() {
        try {
            Class<?> aClass = this.getClass().getClassLoader().loadClass("jetbrains.buildServer.BaseTestCase");
            Method method = aClass.getMethod("threadDump", new Class[0]);
            method.setAccessible(true);
            method.invoke(null, new Object[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        Thread.dumpStack();
    }

    protected WaitFor(long timeoutMs) {
        this(null, timeoutMs);
    }

    protected WaitFor(long timeoutMs, long pollIntervalMs) {
        this(null, timeoutMs);
        this.myPollIntervalMs = pollIntervalMs;
    }

    protected abstract boolean condition();

    public boolean isConditionMet() {
        return this.myConditionMet;
    }
}

