/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import java.util.concurrent.TimeUnit;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class WatchDog {
    @Deprecated
    @NonNls
    public static final Logger LOG = Logger.getLogger(WatchDog.class);
    @Deprecated
    public static final int SEC = 1000;
    private static final long MILLIS_IN_MINUTE = TimeUnit.MINUTES.toMillis(1L);
    private static final long MILLIS_IN_SECOND = TimeUnit.SECONDS.toMillis(1L);
    @Nullable
    private final String myName;
    @Nullable
    private final Logger myLogger;
    private final Priority myPriority;
    private final boolean myLogIntoStdOutOnNullLogger;
    @Nullable
    private final com.intellij.openapi.diagnostic.Logger myIdeaLogger;
    private long myStartedNano;

    public WatchDog() {
        this(null, null, (Priority)Level.DEBUG, false, null);
    }

    public WatchDog(@Nullable String name) {
        this(name, null, (Priority)Level.DEBUG, true, null);
    }

    public WatchDog(@Nullable String name, Logger logger) {
        this(name, logger, (Priority)Level.DEBUG, true, null);
    }

    public WatchDog(@Nullable String name, Logger logger, Priority logLevel) {
        this(name, logger, logLevel, true, null);
    }

    @Deprecated
    public WatchDog(@Nullable String name, Logger logger, Priority logLevel, boolean logIntoStdOutOnNullLogger) {
        this(name, logger, logLevel, logIntoStdOutOnNullLogger, null);
    }

    public WatchDog(@Nullable String name, com.intellij.openapi.diagnostic.Logger ideaLogger, boolean useDebugLevel) {
        this(name, null, (Priority)(useDebugLevel ? Level.DEBUG : Level.INFO), false, ideaLogger);
    }

    @NotNull
    public static WatchDog debug(@NotNull com.intellij.openapi.diagnostic.Logger ideaLogger) {
        if (ideaLogger == null) {
            WatchDog.$$$reportNull$$$0(0);
        }
        WatchDog watchDog = new WatchDog(null, null, (Priority)Level.DEBUG, false, ideaLogger);
        if (watchDog == null) {
            WatchDog.$$$reportNull$$$0(1);
        }
        return watchDog;
    }

    private WatchDog(@Nullable String name, @Nullable Logger logger, Priority priority, boolean logIntoStdOutOnNullLogger, @Nullable com.intellij.openapi.diagnostic.Logger ideaLogger) {
        this.myName = name;
        this.myLogger = logger;
        this.myPriority = priority;
        this.myLogIntoStdOutOnNullLogger = logIntoStdOutOnNullLogger;
        this.myIdeaLogger = ideaLogger;
        this.myStartedNano = System.nanoTime();
        if (name != null && name.length() > 0) {
            this.watch("start");
        }
    }

    public final void watchAndReset(String logMessage) {
        this.watch(logMessage);
        this.reset();
    }

    public final void watch(String logMessage) {
        long diffMillis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.myStartedNano);
        if (this.myLogger != null) {
            if (this.myLogger.isEnabledFor(this.myPriority)) {
                this.myLogger.log(this.myPriority, (Object)this.withNameAndDiff(logMessage, diffMillis));
            }
            return;
        }
        if (this.myIdeaLogger != null) {
            if (this.myPriority.isGreaterOrEqual((Priority)Level.INFO)) {
                this.myIdeaLogger.info(this.withNameAndDiff(logMessage, diffMillis));
            } else if (this.myIdeaLogger.isDebugEnabled()) {
                this.myIdeaLogger.debug(this.withNameAndDiff(logMessage, diffMillis));
            }
        }
        if (this.myLogIntoStdOutOnNullLogger) {
            System.out.println(this.withNameAndDiff(logMessage, diffMillis));
        }
    }

    public void reset() {
        this.myStartedNano = System.nanoTime();
    }

    @NotNull
    public String current() {
        String string = WatchDog.diffString(TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.myStartedNano));
        if (string == null) {
            WatchDog.$$$reportNull$$$0(2);
        }
        return string;
    }

    public final void stop() {
        this.watch("stopped");
    }

    public long getTimeMsecs() {
        return TimeUnit.NANOSECONDS.toMillis(this.getTimeNanosec());
    }

    public long getTimeNanosec() {
        return System.nanoTime() - this.myStartedNano;
    }

    @NotNull
    private String withNameAndDiff(String logMessage, long diffMillis) {
        String string = this.myName != null && this.myName.length() > 0 ? this.myName + ' ' + logMessage + ": " + WatchDog.diffString(diffMillis) : logMessage + ": " + WatchDog.diffString(diffMillis);
        if (string == null) {
            WatchDog.$$$reportNull$$$0(3);
        }
        return string;
    }

    @NotNull
    private static String diffString(long milliseconds) {
        long min = milliseconds / MILLIS_IN_MINUTE;
        long sec = (milliseconds - min * MILLIS_IN_MINUTE) / MILLIS_IN_SECOND;
        long msec = milliseconds % MILLIS_IN_SECOND;
        if (min >= 1L) {
            String string = min + " min " + sec + " sec " + msec + " msec";
            if (string == null) {
                WatchDog.$$$reportNull$$$0(4);
            }
            return string;
        }
        if (sec >= 1L) {
            String string = sec + " sec " + msec + " msec";
            if (string == null) {
                WatchDog.$$$reportNull$$$0(5);
            }
            return string;
        }
        String string = milliseconds + " msec";
        if (string == null) {
            WatchDog.$$$reportNull$$$0(6);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ideaLogger";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/util/WatchDog";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/util/WatchDog";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "debug";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "current";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "withNameAndDiff";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "diffString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "debug";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

