/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import java.io.CharArrayReader;
import java.io.IOException;
import java.io.InputStream;
import jetbrains.buildServer.serverSide.TeamCityProperties;
import jetbrains.buildServer.util.SimpleObjectPool;
import org.apache.xerces.util.XMLGrammarPoolImpl;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import org.jetbrains.annotations.NotNull;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XMLParser {
    private static final SimpleObjectPool<SAXBuilder> myValidatingSAXBuilder = new SimpleObjectPool<SAXBuilder>(new SimpleObjectPool.ObjectFactory<SAXBuilder>(){

        @Override
        @NotNull
        public SAXBuilder create() {
            SAXBuilder sAXBuilder = XMLParser.createSAXBuilder(true);
            if (sAXBuilder == null) {
                1.$$$reportNull$$$0(0);
            }
            return sAXBuilder;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/XMLParser$1", "create"));
        }
    }, 10);
    private static final SimpleObjectPool<SAXBuilder> myNonValidatingSAXBuilder = new SimpleObjectPool<SAXBuilder>(new SimpleObjectPool.ObjectFactory<SAXBuilder>(){

        @Override
        @NotNull
        public SAXBuilder create() {
            SAXBuilder sAXBuilder = XMLParser.createSAXBuilder(false);
            if (sAXBuilder == null) {
                2.$$$reportNull$$$0(0);
            }
            return sAXBuilder;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/XMLParser$2", "create"));
        }
    }, 10);

    @NotNull
    public static SAXBuilder createSAXBuilder(boolean validate) {
        SAXBuilder builder = new SAXBuilder(validate);
        builder.setFeature("http://xml.org/sax/features/external-general-entities", false);
        builder.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        builder.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        builder.setFeature("http://xml.org/sax/features/namespaces", true);
        builder.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
        builder.setFeature("http://apache.org/xml/features/validation/schema", validate);
        if (validate) {
            if (TeamCityProperties.getBooleanOrTrue("teamcity.xmlParser.cacheGrammars")) {
                builder.setProperty("http://apache.org/xml/properties/internal/grammar-pool", (Object)new XMLGrammarPoolImpl());
            }
            builder.setEntityResolver((EntityResolver)new SafeEntityResolver());
        } else {
            builder.setEntityResolver(new EntityResolver(){

                @Override
                public InputSource resolveEntity(String publicId, String systemId) {
                    return XMLParser.emptyInputSource();
                }
            });
        }
        SAXBuilder sAXBuilder = builder;
        if (sAXBuilder == null) {
            XMLParser.$$$reportNull$$$0(0);
        }
        return sAXBuilder;
    }

    @NotNull
    private static InputSource emptyInputSource() {
        InputSource inputSource = new InputSource(new CharArrayReader(new char[0]));
        if (inputSource == null) {
            XMLParser.$$$reportNull$$$0(1);
        }
        return inputSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static Element parseWithSAXBuilder(@NotNull ParserFunc parser, boolean validate) throws JDOMException, IOException {
        if (parser == null) {
            XMLParser.$$$reportNull$$$0(2);
        }
        SimpleObjectPool<SAXBuilder> buildersPool = validate ? myValidatingSAXBuilder : myNonValidatingSAXBuilder;
        SAXBuilder builder = buildersPool.getFromPool();
        Element element = parser.parse(builder);
        Element element2 = element;
        if (element2 == null) {
            XMLParser.$$$reportNull$$$0(3);
        }
        return element2;
        finally {
            buildersPool.returnInPool(builder);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/util/XMLParser";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parser";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createSAXBuilder";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "emptyInputSource";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/util/XMLParser";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "parseWithSAXBuilder";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "parseWithSAXBuilder";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class SafeEntityResolver
    extends DefaultHandler {
        @Override
        public InputSource resolveEntity(String publicId, String systemId) throws IOException, SAXException {
            InputStream schemaStream;
            String schemaFileName;
            int lastSlash = systemId.lastIndexOf(47);
            if (lastSlash != -1 && ((schemaFileName = systemId.substring(lastSlash + 1)).endsWith(".xsd") || schemaFileName.endsWith(".dtd")) && (schemaStream = this.getClass().getClassLoader().getResourceAsStream(schemaFileName)) != null) {
                return new InputSource(schemaStream);
            }
            if (TeamCityProperties.getBoolean("teamcity.xmlParser.allowFileSystemAccess")) {
                return super.resolveEntity(publicId, systemId);
            }
            return XMLParser.emptyInputSource();
        }
    }

    public static interface ParserFunc {
        @NotNull
        public Element parse(@NotNull SAXBuilder var1) throws JDOMException, IOException;
    }
}

