/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Pair;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import jetbrains.buildServer.util.FileUtil;
import jetbrains.buildServer.util.StringUtil;
import jetbrains.buildServer.util.XMLParser;
import org.jdom.Attribute;
import org.jdom.CDATA;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;
import org.jdom.xpath.XPath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

public final class XmlUtil {
    private static final Logger LOG = Logger.getInstance((String)XmlUtil.class.getName());
    public static final String PARAMETER_ELEMENT_NAME = "param";

    private XmlUtil() {
    }

    public static byte[] saveDocument(@NotNull Document document) throws IOException {
        if (document == null) {
            XmlUtil.$$$reportNull$$$0(0);
        }
        ByteArrayOutputStream content = new ByteArrayOutputStream();
        XmlUtil.saveDocument(document, content);
        return content.toByteArray();
    }

    public static void saveDocument(@NotNull Document document, @NotNull OutputStream os) throws IOException {
        if (document == null) {
            XmlUtil.$$$reportNull$$$0(1);
        }
        if (os == null) {
            XmlUtil.$$$reportNull$$$0(2);
        }
        XmlUtil.saveDocument(document, new OutputStreamWriter(os, StandardCharsets.UTF_8));
    }

    public static void saveDocument(@NotNull Document document, @NotNull Writer writer) throws IOException {
        if (document == null) {
            XmlUtil.$$$reportNull$$$0(3);
        }
        if (writer == null) {
            XmlUtil.$$$reportNull$$$0(4);
        }
        try {
            Format format = Format.getPrettyFormat();
            format.setLineSeparator(System.getProperty("line.separator"));
            format.setEncoding("UTF-8");
            new XMLOutputter(format).output(document, writer);
        }
        finally {
            writer.flush();
            writer.close();
        }
    }

    public static void saveElement(@NotNull Element element, @NotNull Writer writer) throws IOException {
        if (element == null) {
            XmlUtil.$$$reportNull$$$0(5);
        }
        if (writer == null) {
            XmlUtil.$$$reportNull$$$0(6);
        }
        try {
            Format format = Format.getPrettyFormat();
            format.setLineSeparator(System.getProperty("line.separator"));
            format.setEncoding("UTF-8");
            new XMLOutputter(format).output(element, writer);
        }
        finally {
            writer.flush();
            writer.close();
        }
    }

    public static boolean isSecureParameter(String propertyName) {
        return propertyName.startsWith("secure:");
    }

    public static Element writeParameter(@NotNull Element parentElement, String name, String value) {
        boolean multiline;
        if (parentElement == null) {
            XmlUtil.$$$reportNull$$$0(7);
        }
        String val = StringUtil.emptyIfNull(value);
        Element paramElement = new Element(PARAMETER_ELEMENT_NAME);
        parentElement.addContent((Content)paramElement);
        paramElement.setAttribute("name", name);
        boolean bl = multiline = value.indexOf(10) != -1;
        if (!multiline) {
            paramElement.setAttribute("value", val);
        } else if (value.contains("<![CDATA[")) {
            paramElement.addContent(val);
        } else {
            paramElement.addContent((Content)new CDATA(val));
        }
        return paramElement;
    }

    @NotNull
    public static Pair<String, String> readParameter(@NotNull Element paramElement) {
        if (paramElement == null) {
            XmlUtil.$$$reportNull$$$0(8);
        }
        String name = paramElement.getAttributeValue("name");
        String value = paramElement.getAttributeValue("value");
        if (value == null) {
            value = paramElement.getTextTrim();
        }
        if (value == null) {
            value = "";
        }
        Pair pair = new Pair((Object)name, (Object)StringUtil.emptyIfNull(value));
        if (pair == null) {
            XmlUtil.$$$reportNull$$$0(9);
        }
        return pair;
    }

    public static void writeParameters(@NotNull Element parentElement, @NotNull Map<String, String> params) {
        if (parentElement == null) {
            XmlUtil.$$$reportNull$$$0(10);
        }
        if (params == null) {
            XmlUtil.$$$reportNull$$$0(11);
        }
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        for (String key : keys) {
            String val = params.get(key);
            XmlUtil.writeParameter(parentElement, key, val);
        }
    }

    @NotNull
    public static Map<String, String> readParameters(@NotNull Element parametersElement) {
        if (parametersElement == null) {
            XmlUtil.$$$reportNull$$$0(12);
        }
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        List parametersElements = parametersElement.getChildren(PARAMETER_ELEMENT_NAME);
        for (Object obj : parametersElements) {
            Element parameter = (Element)obj;
            Pair<String, String> param = XmlUtil.readParameter(parameter);
            result.put((String)param.getFirst(), (String)param.getSecond());
        }
        LinkedHashMap<String, String> linkedHashMap = result;
        if (linkedHashMap == null) {
            XmlUtil.$$$reportNull$$$0(13);
        }
        return linkedHashMap;
    }

    public static String to_s(@NotNull Element el) {
        if (el == null) {
            XmlUtil.$$$reportNull$$$0(14);
        }
        StringWriter writer = new StringWriter();
        try {
            XmlUtil.saveElement(el, writer);
            return writer.toString();
        }
        catch (IOException e) {
            return null;
        }
    }

    public static String toString(@NotNull Element el) {
        if (el == null) {
            XmlUtil.$$$reportNull$$$0(15);
        }
        return XmlUtil.to_s(el);
    }

    public static String toString(@NotNull Document document) {
        if (document == null) {
            XmlUtil.$$$reportNull$$$0(16);
        }
        StringWriter writer = new StringWriter();
        try {
            XmlUtil.saveDocument(document, writer);
            return writer.toString();
        }
        catch (IOException e) {
            return null;
        }
    }

    public static Element from_s(String xmlString) {
        try {
            return FileUtil.parseDocument(new StringReader(xmlString), false);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public static String formatXml(@NotNull String xmlString) {
        if (xmlString == null) {
            XmlUtil.$$$reportNull$$$0(17);
        }
        String string = XmlUtil.to_s(XmlUtil.from_s(xmlString));
        if (string == null) {
            XmlUtil.$$$reportNull$$$0(18);
        }
        return string;
    }

    @Nullable
    public static Element selectElement(@NotNull Element element, @NotNull XPath xpath) {
        if (element == null) {
            XmlUtil.$$$reportNull$$$0(19);
        }
        if (xpath == null) {
            XmlUtil.$$$reportNull$$$0(20);
        }
        try {
            Object node = xpath.selectSingleNode((Object)element);
            return node != null ? (Element)node : null;
        }
        catch (JDOMException je) {
            throw new RuntimeException("Failed to get first element using XPath (" + xpath.toString() + "): " + je.getMessage(), je);
        }
    }

    @Nullable
    public static Element selectElement(@NotNull Element element, @NotNull String xpath) {
        if (element == null) {
            XmlUtil.$$$reportNull$$$0(21);
        }
        if (xpath == null) {
            XmlUtil.$$$reportNull$$$0(22);
        }
        XPath xp = XmlUtil.compileXPath(xpath);
        return XmlUtil.selectElement(element, xp);
    }

    @NotNull
    public static Element getElement(@NotNull Element element, @NotNull String xpath) throws NoSuchElementException {
        Element found;
        if (element == null) {
            XmlUtil.$$$reportNull$$$0(23);
        }
        if (xpath == null) {
            XmlUtil.$$$reportNull$$$0(24);
        }
        if ((found = XmlUtil.selectElement(element, xpath)) == null) {
            throw new NoSuchElementException("The given XML document has no element \"" + xpath + "\"");
        }
        Element element2 = found;
        if (element2 == null) {
            XmlUtil.$$$reportNull$$$0(25);
        }
        return element2;
    }

    @Nullable
    public static String selectValue(@NotNull Element element, @NotNull String xpath) {
        if (element == null) {
            XmlUtil.$$$reportNull$$$0(26);
        }
        if (xpath == null) {
            XmlUtil.$$$reportNull$$$0(27);
        }
        XPath xp = XmlUtil.compileXPath(xpath);
        return XmlUtil.selectValue(element, xp);
    }

    @Nullable
    public static String selectValue(@NotNull Element element, @NotNull XPath xpath) {
        if (element == null) {
            XmlUtil.$$$reportNull$$$0(28);
        }
        if (xpath == null) {
            XmlUtil.$$$reportNull$$$0(29);
        }
        try {
            Object node = xpath.selectSingleNode((Object)element);
            return node != null ? XmlUtil.getNodeValue(node) : null;
        }
        catch (JDOMException je) {
            throw new RuntimeException("Failed to get first value using XPath (" + xpath.toString() + "): " + je.getMessage(), je);
        }
    }

    @NotNull
    public static List<Element> selectElements(@NotNull Element element, @NotNull XPath xpath) {
        ArrayList<Element> arrayList;
        if (element == null) {
            XmlUtil.$$$reportNull$$$0(30);
        }
        if (xpath == null) {
            XmlUtil.$$$reportNull$$$0(31);
        }
        try {
            List nodes = xpath.selectNodes((Object)element);
            ArrayList<Element> elements = new ArrayList<Element>(nodes.size());
            for (Object node : nodes) {
                if (!(node instanceof Element)) continue;
                elements.add((Element)node);
            }
            arrayList = elements;
        }
        catch (JDOMException je) {
            throw new RuntimeException("Failed to select elements by XPath (" + xpath + "): " + je.getMessage(), je);
        }
        if (arrayList == null) {
            XmlUtil.$$$reportNull$$$0(32);
        }
        return arrayList;
    }

    @NotNull
    public static List<Element> selectElements(@NotNull Element element, @NotNull String xpath) {
        if (element == null) {
            XmlUtil.$$$reportNull$$$0(33);
        }
        if (xpath == null) {
            XmlUtil.$$$reportNull$$$0(34);
        }
        XPath xp = XmlUtil.compileXPath(xpath);
        List<Element> list = XmlUtil.selectElements(element, xp);
        if (list == null) {
            XmlUtil.$$$reportNull$$$0(35);
        }
        return list;
    }

    @NotNull
    public static <C extends Collection<String>> C collectValuesFromFileByXPath(@NotNull File xmlFile, @NotNull String xpath, @NotNull C collection) {
        if (xmlFile == null) {
            XmlUtil.$$$reportNull$$$0(36);
        }
        if (xpath == null) {
            XmlUtil.$$$reportNull$$$0(37);
        }
        if (collection == null) {
            XmlUtil.$$$reportNull$$$0(38);
        }
        XPath xp = XmlUtil.compileXPath(xpath);
        FileUtil.readXmlFile(xmlFile, rootElement -> {
            try {
                XmlUtil.collectValuesByXPath(rootElement, xp, collection);
            }
            catch (JDOMException je) {
                throw new RuntimeException("Failed to handle file \"" + xmlFile + "\" and select nodes \"" + xpath + "\": " + je.getMessage(), je);
            }
        });
        Collection c = collection;
        if (c == null) {
            XmlUtil.$$$reportNull$$$0(39);
        }
        return c;
    }

    @NotNull
    public static <C extends Collection<String>> C collectValuesByXPath(@NotNull Element element, @NotNull String xpath, @NotNull C collection) throws JDOMException {
        if (element == null) {
            XmlUtil.$$$reportNull$$$0(40);
        }
        if (xpath == null) {
            XmlUtil.$$$reportNull$$$0(41);
        }
        if (collection == null) {
            XmlUtil.$$$reportNull$$$0(42);
        }
        XPath xp = XmlUtil.compileXPath(xpath);
        C c = XmlUtil.collectValuesByXPath(element, xp, collection);
        if (c == null) {
            XmlUtil.$$$reportNull$$$0(43);
        }
        return c;
    }

    @NotNull
    public static <C extends Collection<String>> C collectValuesByXPath(@NotNull Element element, @NotNull XPath xpath, @NotNull C collection) throws JDOMException {
        if (element == null) {
            XmlUtil.$$$reportNull$$$0(44);
        }
        if (xpath == null) {
            XmlUtil.$$$reportNull$$$0(45);
        }
        if (collection == null) {
            XmlUtil.$$$reportNull$$$0(46);
        }
        for (Object node : xpath.selectNodes((Object)element)) {
            String value = XmlUtil.getNodeValue(node);
            if (value == null) continue;
            collection.add((String)value);
        }
        C c = collection;
        if (c == null) {
            XmlUtil.$$$reportNull$$$0(47);
        }
        return c;
    }

    @NotNull
    public static XPath compileXPath(String xpath) {
        XPath xp;
        try {
            xp = XPath.newInstance((String)xpath);
        }
        catch (JDOMException je) {
            throw new IllegalArgumentException("Invalid XPath \"" + xpath + "\": " + je.getMessage(), je);
        }
        XPath xPath = xp;
        if (xPath == null) {
            XmlUtil.$$$reportNull$$$0(48);
        }
        return xPath;
    }

    @Nullable
    private static String getNodeValue(@NotNull Object node) {
        String value;
        if (node == null) {
            XmlUtil.$$$reportNull$$$0(49);
        }
        if (node instanceof Attribute) {
            Attribute attr = (Attribute)node;
            value = attr.getValue();
        } else if (node instanceof Element) {
            Element elem = (Element)node;
            value = elem.getTextTrim();
        } else {
            value = node.toString().trim();
        }
        return value;
    }

    @NotNull
    public static Element addTextChild(@NotNull Element element, @NotNull String childName, @Nullable String childText) {
        if (element == null) {
            XmlUtil.$$$reportNull$$$0(50);
        }
        if (childName == null) {
            XmlUtil.$$$reportNull$$$0(51);
        }
        Element child = new Element(childName);
        if (childText != null) {
            child.setText(childText);
        }
        element.addContent((Content)child);
        Element element2 = child;
        if (element2 == null) {
            XmlUtil.$$$reportNull$$$0(52);
        }
        return element2;
    }

    @NotNull
    public static Element makeElement(@NotNull String name, String ... attributes) {
        if (name == null) {
            XmlUtil.$$$reportNull$$$0(53);
        }
        Element element = new Element(name);
        for (int i = 0; i < attributes.length; i += 2) {
            element.setAttribute(attributes[i], attributes[i + 1]);
        }
        Element element2 = element;
        if (element2 == null) {
            XmlUtil.$$$reportNull$$$0(54);
        }
        return element2;
    }

    @NotNull
    public static XMLReader createXMLReader() throws SAXException {
        XMLReader xMLReader = XmlUtil.createXMLReader(false);
        if (xMLReader == null) {
            XmlUtil.$$$reportNull$$$0(55);
        }
        return xMLReader;
    }

    @NotNull
    public static XMLReader createXMLReader(boolean validate) throws SAXException {
        XMLReader reader;
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser parser = factory.newSAXParser();
            reader = parser.getXMLReader();
        }
        catch (ParserConfigurationException e) {
            reader = XMLReaderFactory.createXMLReader();
        }
        XmlUtil.setSecurityFeatures(reader);
        XmlUtil.setValidationFeature(reader, validate);
        XmlUtil.setJavaEncodingFeature(reader);
        reader.setEntityResolver(new XMLParser.SafeEntityResolver());
        XMLReader xMLReader = reader;
        if (xMLReader == null) {
            XmlUtil.$$$reportNull$$$0(56);
        }
        return xMLReader;
    }

    protected static void setJavaEncodingFeature(XMLReader reader) {
        try {
            reader.setFeature("http://apache.org/xml/features/allow-java-encodings", true);
        }
        catch (Throwable e) {
            LOG.warnAndDebugDetails("Failed to configure XMLReader with 'allow-java-encoding' feature", e);
        }
    }

    protected static void setSecurityFeatures(@NotNull XMLReader reader) {
        if (reader == null) {
            XmlUtil.$$$reportNull$$$0(57);
        }
        try {
            reader.setFeature("http://xml.org/sax/features/external-general-entities", false);
            reader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            reader.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        }
        catch (SAXException e) {
            LOG.warnAndDebugDetails("Failed to configure XMLReader with all security features", (Throwable)e);
        }
    }

    protected static void setValidationFeature(@NotNull XMLReader reader, boolean validate) {
        if (reader == null) {
            XmlUtil.$$$reportNull$$$0(58);
        }
        try {
            reader.setFeature("http://xml.org/sax/features/namespaces", true);
            reader.setFeature("http://xml.org/sax/features/namespace-prefixes", true);
            reader.setFeature("http://xml.org/sax/features/validation", validate);
        }
        catch (Exception e) {
            LOG.warnAndDebugDetails("Failed to configure XMLReader with validation features (validation is '" + validate + "')", (Throwable)e);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: 
            case 13: 
            case 18: 
            case 25: 
            case 32: 
            case 35: 
            case 39: 
            case 43: 
            case 47: 
            case 48: 
            case 52: 
            case 54: 
            case 55: 
            case 56: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: 
            case 13: 
            case 18: 
            case 25: 
            case 32: 
            case 35: 
            case 39: 
            case 43: 
            case 47: 
            case 48: 
            case 52: 
            case 54: 
            case 55: 
            case 56: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "document";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "os";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "writer";
                break;
            }
            case 5: 
            case 19: 
            case 21: 
            case 23: 
            case 26: 
            case 28: 
            case 30: 
            case 33: 
            case 40: 
            case 44: 
            case 50: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentElement";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "paramElement";
                break;
            }
            case 9: 
            case 13: 
            case 18: 
            case 25: 
            case 32: 
            case 35: 
            case 39: 
            case 43: 
            case 47: 
            case 48: 
            case 52: 
            case 54: 
            case 55: 
            case 56: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/util/XmlUtil";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parametersElement";
                break;
            }
            case 14: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "el";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlString";
                break;
            }
            case 20: 
            case 22: 
            case 24: 
            case 27: 
            case 29: 
            case 31: 
            case 34: 
            case 37: 
            case 41: 
            case 45: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xpath";
                break;
            }
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "xmlFile";
                break;
            }
            case 38: 
            case 42: 
            case 46: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 49: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 51: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childName";
                break;
            }
            case 53: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 57: 
            case 58: {
                objectArray2 = objectArray3;
                objectArray3[0] = "reader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/util/XmlUtil";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "readParameter";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "readParameters";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "formatXml";
                break;
            }
            case 25: {
                objectArray = objectArray2;
                objectArray2[1] = "getElement";
                break;
            }
            case 32: 
            case 35: {
                objectArray = objectArray2;
                objectArray2[1] = "selectElements";
                break;
            }
            case 39: {
                objectArray = objectArray2;
                objectArray2[1] = "collectValuesFromFileByXPath";
                break;
            }
            case 43: 
            case 47: {
                objectArray = objectArray2;
                objectArray2[1] = "collectValuesByXPath";
                break;
            }
            case 48: {
                objectArray = objectArray2;
                objectArray2[1] = "compileXPath";
                break;
            }
            case 52: {
                objectArray = objectArray2;
                objectArray2[1] = "addTextChild";
                break;
            }
            case 54: {
                objectArray = objectArray2;
                objectArray2[1] = "makeElement";
                break;
            }
            case 55: 
            case 56: {
                objectArray = objectArray2;
                objectArray2[1] = "createXMLReader";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "saveDocument";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "saveElement";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "writeParameter";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "readParameter";
                break;
            }
            case 9: 
            case 13: 
            case 18: 
            case 25: 
            case 32: 
            case 35: 
            case 39: 
            case 43: 
            case 47: 
            case 48: 
            case 52: 
            case 54: 
            case 55: 
            case 56: {
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "writeParameters";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "readParameters";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "to_s";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "toString";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "formatXml";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "selectElement";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "getElement";
                break;
            }
            case 26: 
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "selectValue";
                break;
            }
            case 30: 
            case 31: 
            case 33: 
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "selectElements";
                break;
            }
            case 36: 
            case 37: 
            case 38: {
                objectArray = objectArray;
                objectArray[2] = "collectValuesFromFileByXPath";
                break;
            }
            case 40: 
            case 41: 
            case 42: 
            case 44: 
            case 45: 
            case 46: {
                objectArray = objectArray;
                objectArray[2] = "collectValuesByXPath";
                break;
            }
            case 49: {
                objectArray = objectArray;
                objectArray[2] = "getNodeValue";
                break;
            }
            case 50: 
            case 51: {
                objectArray = objectArray;
                objectArray[2] = "addTextChild";
                break;
            }
            case 53: {
                objectArray = objectArray;
                objectArray[2] = "makeElement";
                break;
            }
            case 57: {
                objectArray = objectArray;
                objectArray[2] = "setSecurityFeatures";
                break;
            }
            case 58: {
                objectArray = objectArray;
                objectArray[2] = "setValidationFeature";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: 
            case 13: 
            case 18: 
            case 25: 
            case 32: 
            case 35: 
            case 39: 
            case 43: 
            case 47: 
            case 48: 
            case 52: 
            case 54: 
            case 55: 
            case 56: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

