/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import jetbrains.buildServer.util.ArchiveUtil;
import jetbrains.buildServer.util.CollectionsUtil;
import jetbrains.buildServer.util.Predicate;

public class ZipSlipAwareZipFile
extends ZipFile {
    public ZipSlipAwareZipFile(String name) throws IOException {
        super(name);
    }

    public ZipSlipAwareZipFile(File file, int mode) throws IOException {
        super(file, mode);
    }

    public ZipSlipAwareZipFile(File file) throws ZipException, IOException {
        super(file);
    }

    @Override
    public ZipEntry getEntry(String name) {
        ZipEntry entry = super.getEntry(name);
        return this.isAllowed(entry) ? entry : null;
    }

    @Override
    public InputStream getInputStream(ZipEntry entry) throws IOException {
        if (!this.isAllowed(entry)) {
            throw new IOException("Opening entries outside root directory is prohibited");
        }
        return super.getInputStream(entry);
    }

    @Override
    public Enumeration<? extends ZipEntry> entries() {
        return new CollectionsUtil.FilteringEnumeration<ZipEntry>(super.entries(), new Predicate<ZipEntry>(){

            @Override
            public boolean apply(ZipEntry item) {
                return ZipSlipAwareZipFile.this.isAllowed(item);
            }
        });
    }

    private boolean isAllowed(ZipEntry entry) {
        return entry == null || ArchiveUtil.isNameAllowed(entry.getName());
    }
}

