/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util.executors;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import jetbrains.buildServer.util.NamedDaemonThreadFactory;
import jetbrains.buildServer.util.NamedThreadFactory;
import jetbrains.buildServer.util.executors.ScalingThreadPoolExecutor;
import jetbrains.buildServer.util.executors.TeamCityScheduledThreadPoolExecutor;
import jetbrains.buildServer.util.executors.TeamCityThreadPoolExecutor;
import org.jetbrains.annotations.NotNull;

public class ExecutorsFactory {
    @NotNull
    public static ExecutorService newFixedDaemonExecutor(@NotNull String threadNamePrefix, int poolSize) {
        if (threadNamePrefix == null) {
            ExecutorsFactory.$$$reportNull$$$0(0);
        }
        ExecutorService executorService = ExecutorsFactory.createFixedThreadPoolExecutor(new NamedDaemonThreadFactory(threadNamePrefix), poolSize);
        if (executorService == null) {
            ExecutorsFactory.$$$reportNull$$$0(1);
        }
        return executorService;
    }

    @NotNull
    public static ExecutorService newFixedDaemonExecutor(@NotNull String threadNamePrefix, int minPoolSize, int maxPoolSize, int maxQueueSize) {
        if (threadNamePrefix == null) {
            ExecutorsFactory.$$$reportNull$$$0(2);
        }
        ExecutorService executorService = ExecutorsFactory.createScalingThreadPoolExecutor(new NamedDaemonThreadFactory(threadNamePrefix), minPoolSize, maxPoolSize, maxQueueSize);
        if (executorService == null) {
            ExecutorsFactory.$$$reportNull$$$0(3);
        }
        return executorService;
    }

    @NotNull
    public static ExecutorService newFixedExecutor(@NotNull String threadNamePrefix, int poolSize) {
        if (threadNamePrefix == null) {
            ExecutorsFactory.$$$reportNull$$$0(4);
        }
        ExecutorService executorService = ExecutorsFactory.createFixedThreadPoolExecutor(new NamedThreadFactory(threadNamePrefix), poolSize);
        if (executorService == null) {
            ExecutorsFactory.$$$reportNull$$$0(5);
        }
        return executorService;
    }

    @NotNull
    public static ScheduledExecutorService newFixedScheduledDaemonExecutor(@NotNull String threadNamePrefix, int poolSize) {
        if (threadNamePrefix == null) {
            ExecutorsFactory.$$$reportNull$$$0(6);
        }
        TeamCityScheduledThreadPoolExecutor teamCityScheduledThreadPoolExecutor = new TeamCityScheduledThreadPoolExecutor(poolSize, new NamedDaemonThreadFactory(threadNamePrefix));
        if (teamCityScheduledThreadPoolExecutor == null) {
            ExecutorsFactory.$$$reportNull$$$0(7);
        }
        return teamCityScheduledThreadPoolExecutor;
    }

    @NotNull
    public static ScheduledExecutorService newFixedScheduledExecutor(@NotNull String threadNamePrefix, int poolSize) {
        if (threadNamePrefix == null) {
            ExecutorsFactory.$$$reportNull$$$0(8);
        }
        TeamCityScheduledThreadPoolExecutor teamCityScheduledThreadPoolExecutor = new TeamCityScheduledThreadPoolExecutor(poolSize, new NamedThreadFactory(threadNamePrefix));
        if (teamCityScheduledThreadPoolExecutor == null) {
            ExecutorsFactory.$$$reportNull$$$0(9);
        }
        return teamCityScheduledThreadPoolExecutor;
    }

    @NotNull
    public static ExecutorService newDaemonExecutor(@NotNull String threadNamePrefix) {
        if (threadNamePrefix == null) {
            ExecutorsFactory.$$$reportNull$$$0(10);
        }
        ExecutorService executorService = ExecutorsFactory.createThreadPoolExecutor(new NamedDaemonThreadFactory(threadNamePrefix));
        if (executorService == null) {
            ExecutorsFactory.$$$reportNull$$$0(11);
        }
        return executorService;
    }

    @NotNull
    public static ExecutorService newExecutor(@NotNull String threadNamePrefix) {
        if (threadNamePrefix == null) {
            ExecutorsFactory.$$$reportNull$$$0(12);
        }
        ExecutorService executorService = ExecutorsFactory.createThreadPoolExecutor(new NamedThreadFactory(threadNamePrefix));
        if (executorService == null) {
            ExecutorsFactory.$$$reportNull$$$0(13);
        }
        return executorService;
    }

    @NotNull
    public static ExecutorService newSingleThreadedExecutor(@NotNull String threadNamePrefix) {
        if (threadNamePrefix == null) {
            ExecutorsFactory.$$$reportNull$$$0(14);
        }
        ExecutorService executorService = ExecutorsFactory.createFixedThreadPoolExecutor(new NamedThreadFactory(threadNamePrefix), 1);
        if (executorService == null) {
            ExecutorsFactory.$$$reportNull$$$0(15);
        }
        return executorService;
    }

    @NotNull
    private static ExecutorService createFixedThreadPoolExecutor(@NotNull NamedThreadFactory threadFactory, int poolSize) {
        if (threadFactory == null) {
            ExecutorsFactory.$$$reportNull$$$0(16);
        }
        TeamCityThreadPoolExecutor teamCityThreadPoolExecutor = new TeamCityThreadPoolExecutor(poolSize, poolSize, 0L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(), threadFactory);
        if (teamCityThreadPoolExecutor == null) {
            ExecutorsFactory.$$$reportNull$$$0(17);
        }
        return teamCityThreadPoolExecutor;
    }

    @NotNull
    private static ExecutorService createScalingThreadPoolExecutor(@NotNull NamedThreadFactory threadFactory, int minPoolSize, int poolSize, int maxQueueSize) {
        if (threadFactory == null) {
            ExecutorsFactory.$$$reportNull$$$0(18);
        }
        ScalingThreadPoolExecutor scalingThreadPoolExecutor = new ScalingThreadPoolExecutor(minPoolSize, poolSize, maxQueueSize, 60L, TimeUnit.SECONDS, threadFactory);
        if (scalingThreadPoolExecutor == null) {
            ExecutorsFactory.$$$reportNull$$$0(19);
        }
        return scalingThreadPoolExecutor;
    }

    @NotNull
    private static ExecutorService createThreadPoolExecutor(@NotNull ThreadFactory threadFactory) {
        if (threadFactory == null) {
            ExecutorsFactory.$$$reportNull$$$0(20);
        }
        TeamCityThreadPoolExecutor teamCityThreadPoolExecutor = new TeamCityThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), threadFactory);
        if (teamCityThreadPoolExecutor == null) {
            ExecutorsFactory.$$$reportNull$$$0(21);
        }
        return teamCityThreadPoolExecutor;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threadNamePrefix";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/util/executors/ExecutorsFactory";
                break;
            }
            case 16: 
            case 18: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "threadFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/util/executors/ExecutorsFactory";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "newFixedDaemonExecutor";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "newFixedExecutor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "newFixedScheduledDaemonExecutor";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "newFixedScheduledExecutor";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "newDaemonExecutor";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "newExecutor";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "newSingleThreadedExecutor";
                break;
            }
            case 17: {
                objectArray = objectArray2;
                objectArray2[1] = "createFixedThreadPoolExecutor";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "createScalingThreadPoolExecutor";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "createThreadPoolExecutor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "newFixedDaemonExecutor";
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "newFixedExecutor";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "newFixedScheduledDaemonExecutor";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "newFixedScheduledExecutor";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "newDaemonExecutor";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "newExecutor";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "newSingleThreadedExecutor";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "createFixedThreadPoolExecutor";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "createScalingThreadPoolExecutor";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "createThreadPoolExecutor";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 11: 
            case 13: 
            case 15: 
            case 17: 
            case 19: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

