/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util.executors;

import com.intellij.openapi.diagnostic.Logger;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import jetbrains.buildServer.util.NamedThreadFactory;
import jetbrains.buildServer.util.executors.ExecutorServiceEx;
import jetbrains.buildServer.util.executors.TeamCityThreadPoolExecutor;
import org.jetbrains.annotations.NotNull;

public class ScalingThreadPoolExecutor
extends TeamCityThreadPoolExecutor
implements ExecutorServiceEx {
    private static final Logger LOG = Logger.getInstance((String)ScalingThreadPoolExecutor.class.getName());
    private final AtomicInteger myActiveCount = new AtomicInteger();

    public ScalingThreadPoolExecutor(int corePoolSize, int maximumPoolSize, int maximumQueueCapacity, long keepAliveTime, TimeUnit unit, NamedThreadFactory threadFactory) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, new ScalingQueue<Runnable>(maximumQueueCapacity), threadFactory, new ForceQueuePolicy());
        ((ScalingQueue)this.getQueue()).setExecutor(this);
    }

    @Override
    public int getActiveCount() {
        return this.myActiveCount.get();
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        super.beforeExecute(t, r);
        this.myActiveCount.incrementAndGet();
    }

    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        try {
            super.afterExecute(r, t);
        }
        finally {
            this.myActiveCount.decrementAndGet();
        }
    }

    @NotNull
    private static String describe(ThreadPoolExecutor executor) {
        String string = String.valueOf(executor.getThreadFactory()) + " {corePoolSize=" + executor.getCorePoolSize() + "; maxPoolSize=" + executor.getMaximumPoolSize() + "; activeCount=" + executor.getActiveCount() + "}";
        if (string == null) {
            ScalingThreadPoolExecutor.$$$reportNull$$$0(0);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/executors/ScalingThreadPoolExecutor", "describe"));
    }

    private static class ForceQueuePolicy
    implements RejectedExecutionHandler {
        private ForceQueuePolicy() {
        }

        @Override
        public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
            try {
                if (executor.isShutdown()) {
                    String message = "Unable to add task to queue because executor is already shut down: " + ScalingThreadPoolExecutor.describe(executor);
                    LOG.debug(message);
                    throw new RejectedExecutionException(message);
                }
                executor.getQueue().put(r);
            }
            catch (InterruptedException e) {
                throw new RejectedExecutionException(e);
            }
        }
    }

    private static class ScalingQueue<E>
    extends LinkedBlockingQueue<E> {
        private ThreadPoolExecutor myExecutor;

        ScalingQueue(int capacity) {
            super(capacity);
        }

        public void setExecutor(@NotNull ThreadPoolExecutor executor) {
            if (executor == null) {
                ScalingQueue.$$$reportNull$$$0(0);
            }
            this.myExecutor = executor;
        }

        @Override
        public void put(E o) {
            if (!super.offer(o)) {
                String message = "Unable to put new task into the queue because maximum capacity is exceeded. Current queue size: " + this.size() + ". Executor info: " + ScalingThreadPoolExecutor.describe(this.myExecutor);
                LOG.debug(message);
                throw new RejectedExecutionException(message);
            }
        }

        @Override
        public boolean offer(@NotNull E o) {
            int unfinishedTasks;
            if (o == null) {
                ScalingQueue.$$$reportNull$$$0(1);
            }
            return (unfinishedTasks = this.myExecutor.getActiveCount() + super.size()) < this.myExecutor.getPoolSize() && super.offer(o);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "executor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
            }
            objectArray2[1] = "jetbrains/buildServer/util/executors/ScalingThreadPoolExecutor$ScalingQueue";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setExecutor";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "offer";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

