/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util.executors;

import java.util.concurrent.Callable;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RunnableScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import jetbrains.buildServer.log.Loggable;
import jetbrains.buildServer.util.Disposable;
import jetbrains.buildServer.util.NamedThreadFactory;
import jetbrains.buildServer.util.executors.ExecutorServiceEx;
import jetbrains.buildServer.util.executors.MetadataFetcher;
import jetbrains.buildServer.util.executors.MetadataHolder;
import jetbrains.buildServer.util.executors.TaskMetadata;
import jetbrains.buildServer.util.executors.TeamCityThreadPoolExecutor;
import org.jetbrains.annotations.NotNull;

public class TeamCityScheduledThreadPoolExecutor
extends ScheduledThreadPoolExecutor
implements ExecutorServiceEx {
    private static final ThreadLocal<Disposable> ourThreadName = new ThreadLocal();

    public TeamCityScheduledThreadPoolExecutor(int corePoolSize, ThreadFactory threadFactory) {
        super(corePoolSize, threadFactory);
    }

    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        super.beforeExecute(t, r);
        Disposable newName = NamedThreadFactory.patchThreadName("Task: \"" + TeamCityThreadPoolExecutor.getName(r) + "\"");
        ourThreadName.set(newName);
    }

    @Override
    protected <V> RunnableScheduledFuture<V> decorateTask(Runnable runnable, RunnableScheduledFuture<V> task) {
        return new RunnableScheduledFutureWrapper<V>(task, TeamCityThreadPoolExecutor.getName(runnable), MetadataFetcher.fetchMetadata(runnable));
    }

    @Override
    protected <V> RunnableScheduledFuture<V> decorateTask(Callable<V> callable, RunnableScheduledFuture<V> task) {
        return new RunnableScheduledFutureWrapper<V>(task, TeamCityThreadPoolExecutor.getName(callable), MetadataFetcher.fetchMetadata(callable));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        try {
            super.afterExecute(r, t);
        }
        finally {
            Disposable newName = ourThreadName.get();
            if (newName != null) {
                newName.dispose();
            }
        }
    }

    @Override
    public int getQueuedTasksCount() {
        return this.getQueue().size();
    }

    public static class RunnableScheduledFutureWrapper<V>
    implements RunnableScheduledFuture<V>,
    Loggable,
    MetadataHolder {
        @NotNull
        private final RunnableScheduledFuture<V> myDelegate;
        @NotNull
        private final String myName;
        @NotNull
        private final TaskMetadata myMetadata;

        public RunnableScheduledFutureWrapper(@NotNull RunnableScheduledFuture<V> delegate, @NotNull String name, @NotNull TaskMetadata taskMetadata) {
            if (delegate == null) {
                RunnableScheduledFutureWrapper.$$$reportNull$$$0(0);
            }
            if (name == null) {
                RunnableScheduledFutureWrapper.$$$reportNull$$$0(1);
            }
            if (taskMetadata == null) {
                RunnableScheduledFutureWrapper.$$$reportNull$$$0(2);
            }
            this.myMetadata = taskMetadata;
            this.myDelegate = delegate;
            this.myName = name;
        }

        @Override
        public boolean isPeriodic() {
            return this.myDelegate.isPeriodic();
        }

        @Override
        public void run() {
            this.myDelegate.run();
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.myDelegate.cancel(mayInterruptIfRunning);
        }

        @Override
        public boolean isCancelled() {
            return this.myDelegate.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.myDelegate.isDone();
        }

        @Override
        public V get() throws InterruptedException, ExecutionException {
            return this.myDelegate.get();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public V get(long timeout, @NotNull TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
            void unit;
            if (timeUnit == null) {
                RunnableScheduledFutureWrapper.$$$reportNull$$$0(3);
            }
            return this.myDelegate.get(timeout, (TimeUnit)unit);
        }

        @Override
        public long getDelay(@NotNull TimeUnit unit) {
            if (unit == null) {
                RunnableScheduledFutureWrapper.$$$reportNull$$$0(4);
            }
            return this.myDelegate.getDelay(unit);
        }

        @Override
        public int compareTo(@NotNull Delayed o) {
            if (o == null) {
                RunnableScheduledFutureWrapper.$$$reportNull$$$0(5);
            }
            return this.myDelegate.compareTo(o);
        }

        @Override
        @NotNull
        public String describe(boolean verbose) {
            String string = this.myName;
            if (string == null) {
                RunnableScheduledFutureWrapper.$$$reportNull$$$0(6);
            }
            return string;
        }

        @Override
        @NotNull
        public TaskMetadata getMetadata() {
            TaskMetadata taskMetadata = this.myMetadata;
            if (taskMetadata == null) {
                RunnableScheduledFutureWrapper.$$$reportNull$$$0(7);
            }
            return taskMetadata;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 6: 
                case 7: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 6: 
                case 7: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegate";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "taskMetadata";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "unit";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "o";
                    break;
                }
                case 6: 
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "jetbrains/buildServer/util/executors/TeamCityScheduledThreadPoolExecutor$RunnableScheduledFutureWrapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "jetbrains/buildServer/util/executors/TeamCityScheduledThreadPoolExecutor$RunnableScheduledFutureWrapper";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "describe";
                    break;
                }
                case 7: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMetadata";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "get";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "getDelay";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "compareTo";
                    break;
                }
                case 6: 
                case 7: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 6: 
                case 7: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

