/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util.executors;

import com.intellij.openapi.diagnostic.Logger;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import jetbrains.buildServer.log.Loggable;
import jetbrains.buildServer.util.Disposable;
import jetbrains.buildServer.util.NamedThreadFactory;
import jetbrains.buildServer.util.executors.ExecutorServiceEx;
import jetbrains.buildServer.util.executors.MetadataFetcher;
import jetbrains.buildServer.util.executors.MetadataHolder;
import jetbrains.buildServer.util.executors.TaskMetadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TeamCityThreadPoolExecutor
extends ThreadPoolExecutor
implements ExecutorServiceEx {
    private static final Logger LOG = Logger.getInstance((String)TeamCityThreadPoolExecutor.class.getName());
    private static final ThreadLocal<Disposable> ourThreadName = new ThreadLocal();
    private boolean myPaused;
    private final ReentrantLock myPauseLock = new ReentrantLock();
    private final Condition myUnpauseCondition = this.myPauseLock.newCondition();

    public TeamCityThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory, RejectedExecutionHandler handler) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory, handler);
    }

    public TeamCityThreadPoolExecutor(int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
        super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void beforeExecute(Thread t, Runnable r) {
        super.beforeExecute(t, r);
        Disposable newName = NamedThreadFactory.patchThreadName("Task: \"" + TeamCityThreadPoolExecutor.getName(r) + "\"");
        ourThreadName.set(newName);
        this.myPauseLock.lock();
        try {
            while (this.myPaused) {
                this.myUnpauseCondition.await();
            }
        }
        catch (InterruptedException ie) {
            t.interrupt();
        }
        finally {
            this.myPauseLock.unlock();
        }
    }

    public void pause() {
        this.myPauseLock.lock();
        try {
            this.myPaused = true;
        }
        finally {
            this.myPauseLock.unlock();
        }
    }

    public void resume() {
        this.myPauseLock.lock();
        try {
            this.myPaused = false;
            this.myUnpauseCondition.signalAll();
        }
        finally {
            this.myPauseLock.unlock();
        }
    }

    public boolean isPaused() {
        return this.myPaused;
    }

    @Override
    public void shutdown() {
        this.resume();
        super.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void afterExecute(Runnable r, Throwable t) {
        try {
            super.afterExecute(r, t);
        }
        finally {
            Disposable newName;
            RunnableFutureWrapper rw;
            if (LOG.isDebugEnabled() && r instanceof RunnableFutureWrapper && (rw = (RunnableFutureWrapper)r).getError() != null) {
                LOG.debug("Executor task has finished with error, executor: " + this.getThreadFactory().toString() + ", thread name: " + Thread.currentThread().getName() + ", task details: " + rw.describe(false) + ", task class: " + rw.getTaskClassName() + ", error: " + rw.getError().toString(), rw.getError());
            }
            if ((newName = ourThreadName.get()) != null) {
                newName.dispose();
            }
        }
    }

    @NotNull
    public static String getName(@NotNull Object o) {
        if (o == null) {
            TeamCityThreadPoolExecutor.$$$reportNull$$$0(0);
        }
        if (o instanceof Loggable) {
            String string = ((Loggable)o).describe(false);
            if (string == null) {
                TeamCityThreadPoolExecutor.$$$reportNull$$$0(1);
            }
            return string;
        }
        String s = o.toString();
        String string = s == null ? "''" : s;
        if (string == null) {
            TeamCityThreadPoolExecutor.$$$reportNull$$$0(2);
        }
        return string;
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
        return new RunnableFutureWrapper<T>(runnable, value, MetadataFetcher.fetchMetadata(runnable));
    }

    @Override
    protected <T> RunnableFuture<T> newTaskFor(Callable<T> callable) {
        return new RunnableFutureWrapper<T>(callable, MetadataFetcher.fetchMetadata(callable));
    }

    @Override
    public int getQueuedTasksCount() {
        return this.getQueue().size();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/util/executors/TeamCityThreadPoolExecutor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/util/executors/TeamCityThreadPoolExecutor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getName";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class RunnableFutureWrapper<V>
    extends FutureTask<V>
    implements MetadataHolder,
    Loggable {
        @NotNull
        private final TaskMetadata myMetadata;
        private final String myTaskClassName;
        private Throwable myError;
        @NotNull
        private final String myTaskDescription;

        public RunnableFutureWrapper(@NotNull Callable<V> callable, @NotNull TaskMetadata metadata) {
            if (callable == null) {
                RunnableFutureWrapper.$$$reportNull$$$0(0);
            }
            if (metadata == null) {
                RunnableFutureWrapper.$$$reportNull$$$0(1);
            }
            super(callable);
            this.myTaskClassName = callable.getClass().getName();
            this.myMetadata = metadata;
            this.myTaskDescription = TeamCityThreadPoolExecutor.getName(callable);
        }

        public RunnableFutureWrapper(@NotNull Runnable runnable, V result, @NotNull TaskMetadata metadata) {
            if (runnable == null) {
                RunnableFutureWrapper.$$$reportNull$$$0(2);
            }
            if (metadata == null) {
                RunnableFutureWrapper.$$$reportNull$$$0(3);
            }
            super(runnable, result);
            this.myTaskClassName = runnable.getClass().getName();
            this.myMetadata = metadata;
            this.myTaskDescription = TeamCityThreadPoolExecutor.getName(runnable);
        }

        @Override
        @NotNull
        public TaskMetadata getMetadata() {
            TaskMetadata taskMetadata = this.myMetadata;
            if (taskMetadata == null) {
                RunnableFutureWrapper.$$$reportNull$$$0(4);
            }
            return taskMetadata;
        }

        @Override
        protected void setException(Throwable t) {
            super.setException(t);
            this.myError = t;
        }

        @Nullable
        public Throwable getError() {
            return this.myError;
        }

        @NotNull
        public String getTaskClassName() {
            String string = this.myTaskClassName;
            if (string == null) {
                RunnableFutureWrapper.$$$reportNull$$$0(5);
            }
            return string;
        }

        @Override
        @NotNull
        public String describe(boolean verbose) {
            String string = this.myTaskDescription;
            if (string == null) {
                RunnableFutureWrapper.$$$reportNull$$$0(6);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "callable";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "metadata";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "runnable";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "jetbrains/buildServer/util/executors/TeamCityThreadPoolExecutor$RunnableFutureWrapper";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "jetbrains/buildServer/util/executors/TeamCityThreadPoolExecutor$RunnableFutureWrapper";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getMetadata";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTaskClassName";
                    break;
                }
                case 6: {
                    objectArray = objectArray2;
                    objectArray2[1] = "describe";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

