/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util.fileLookup;

import java.io.File;
import java.io.FileFilter;
import java.util.Iterator;
import java.util.Stack;
import jetbrains.buildServer.util.FileUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileSystemIterator
implements Iterator<File> {
    @NotNull
    private final File myBaseFolder;
    @NotNull
    private final FileFilter myFilter;
    private final boolean myRelativePaths;
    @NotNull
    private final Stack<File> myUnprocessed;

    public FileSystemIterator(@NotNull File baseFolder, @Nullable FileFilter fileFilter, boolean relativePaths) {
        if (baseFolder == null) {
            FileSystemIterator.$$$reportNull$$$0(0);
        }
        this.myUnprocessed = new Stack();
        this.myBaseFolder = baseFolder;
        this.myFilter = fileFilter == null ? new FileFilter(){

            @Override
            public boolean accept(File pathname) {
                return true;
            }
        } : fileFilter;
        this.myRelativePaths = relativePaths;
        this.myUnprocessed.push(this.myBaseFolder);
    }

    @Override
    public boolean hasNext() {
        return !this.myUnprocessed.isEmpty();
    }

    @Override
    public File next() {
        if (!this.hasNext()) {
            throw new IllegalStateException("No more elements");
        }
        File next = this.myUnprocessed.pop();
        File[] children = next.listFiles(this.myFilter);
        if (children != null && children.length > 0) {
            for (File f : children) {
                this.myUnprocessed.push(f);
            }
        }
        return this.myRelativePaths ? new File(FileUtil.normalizeRelativePath(FileUtil.getRelativePath((File)this.myBaseFolder, (File)next))) : next;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Remove operation is not supported");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "baseFolder", "jetbrains/buildServer/util/fileLookup/FileSystemIterator", "<init>"));
    }
}

