/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util.fileLookup;

import java.io.File;
import java.io.FileFilter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import jetbrains.buildServer.util.FileUtil;
import jetbrains.buildServer.util.fileLookup.FileInfo;
import jetbrains.buildServer.util.fileLookup.FileSystemIterator;
import jetbrains.buildServer.util.fileLookup.MemorizingLookup;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MemorizingFileLookup
extends MemorizingLookup<FileInfo, File, File> {
    @NotNull
    private final File myBaseFolder;

    public MemorizingFileLookup(final @NotNull File baseFolder) {
        if (baseFolder == null) {
            MemorizingFileLookup.$$$reportNull$$$0(0);
        }
        super(new Iterable<File>(){

            @Override
            public Iterator<File> iterator() {
                return new FileSystemIterator(baseFolder, new FileFilter(){

                    @Override
                    public boolean accept(File file) {
                        return file.isDirectory();
                    }
                }, true);
            }
        });
        this.myBaseFolder = baseFolder;
    }

    @Override
    @Nullable
    protected File lookupInside(@NotNull File subdir, @NotNull FileInfo fileInfo) {
        String path;
        if (subdir == null) {
            MemorizingFileLookup.$$$reportNull$$$0(1);
        }
        if (fileInfo == null) {
            MemorizingFileLookup.$$$reportNull$$$0(2);
        }
        if (!(path = subdir.getPath()).endsWith(fileInfo.getParentPath())) {
            return null;
        }
        for (String name : fileInfo.getPossibleFileNames()) {
            File found = new File(new File(this.myBaseFolder, path), name);
            if (!found.isFile()) continue;
            return found;
        }
        return null;
    }

    @NotNull
    public FileInfo createFileInfo(@NotNull String filePath) {
        if (filePath == null) {
            MemorizingFileLookup.$$$reportNull$$$0(3);
        }
        FileInfo fileInfo = this.createFileInfo(new File(filePath));
        if (fileInfo == null) {
            MemorizingFileLookup.$$$reportNull$$$0(4);
        }
        return fileInfo;
    }

    @NotNull
    public FileInfo createFileInfo(@NotNull File file) {
        if (file == null) {
            MemorizingFileLookup.$$$reportNull$$$0(5);
        }
        FileInfo fileInfo = this.createFileInfo(file.getParentFile(), file.getName());
        if (fileInfo == null) {
            MemorizingFileLookup.$$$reportNull$$$0(6);
        }
        return fileInfo;
    }

    @NotNull
    public FileInfo createFileInfo(@Nullable File parentFile, @NotNull String fileName) {
        if (fileName == null) {
            MemorizingFileLookup.$$$reportNull$$$0(7);
        }
        FileInfo fileInfo = this.createFileInfo(parentFile, Arrays.asList(fileName));
        if (fileInfo == null) {
            MemorizingFileLookup.$$$reportNull$$$0(8);
        }
        return fileInfo;
    }

    @NotNull
    public FileInfo createFileInfo(@Nullable File parentFile, final @NotNull Collection<String> possibleFileNames) {
        if (possibleFileNames == null) {
            MemorizingFileLookup.$$$reportNull$$$0(9);
        }
        final String parentPath = parentFile == null || this.myBaseFolder.equals(parentFile) ? "" : (FileUtil.isAncestor(this.myBaseFolder, parentFile, false) ? FileUtil.getRelativePath((File)this.myBaseFolder, (File)parentFile) : parentFile.getPath());
        FileInfo fileInfo = new FileInfo(){

            @Override
            @NotNull
            public String getParentPath() {
                String string = parentPath;
                if (string == null) {
                    2.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Override
            @NotNull
            public Collection<String> getPossibleFileNames() {
                Collection collection = possibleFileNames;
                if (collection == null) {
                    2.$$$reportNull$$$0(1);
                }
                return collection;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "jetbrains/buildServer/util/fileLookup/MemorizingFileLookup$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getParentPath";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getPossibleFileNames";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
        if (fileInfo == null) {
            MemorizingFileLookup.$$$reportNull$$$0(10);
        }
        return fileInfo;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseFolder";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subdir";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileInfo";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/util/fileLookup/MemorizingFileLookup";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "possibleFileNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/util/fileLookup/MemorizingFileLookup";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "lookupInside";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createFileInfo";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

