/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util.fileLookup;

import java.util.Iterator;
import java.util.LinkedList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MemorizingLookup<K, V, P> {
    @NotNull
    private final Iterable<P> myWhere;
    @NotNull
    private final Iterator<P> myPlaceIterator;
    @NotNull
    private final LinkedList<P> myVisitedPlaces;

    protected MemorizingLookup(@NotNull Iterable<P> where) {
        if (where == null) {
            MemorizingLookup.$$$reportNull$$$0(0);
        }
        this.myVisitedPlaces = new LinkedList();
        this.myWhere = where;
        this.myPlaceIterator = where.iterator();
    }

    @Nullable
    public V lookup(@NotNull K key) {
        V found;
        if (key == null) {
            MemorizingLookup.$$$reportNull$$$0(1);
        }
        if ((found = this.lookupInVisited(key)) != null) {
            return found;
        }
        if (!this.hasNewPlaces()) {
            return null;
        }
        return this.lookupInNew(key);
    }

    @Nullable
    private V lookupInVisited(@NotNull K key) {
        if (key == null) {
            MemorizingLookup.$$$reportNull$$$0(2);
        }
        Iterator it = this.myVisitedPlaces.iterator();
        V found = null;
        Object where = null;
        while (it.hasNext()) {
            Object place = it.next();
            found = this.lookupInside(place, key);
            if (found == null) continue;
            where = place;
            it.remove();
            break;
        }
        if (where != null) {
            this.myVisitedPlaces.addFirst(where);
        }
        return found;
    }

    private boolean hasNewPlaces() {
        return this.myPlaceIterator.hasNext();
    }

    @Nullable
    private V lookupInNew(@NotNull K key) {
        if (key == null) {
            MemorizingLookup.$$$reportNull$$$0(3);
        }
        if (!this.hasNewPlaces()) {
            return null;
        }
        V found = null;
        while (this.myPlaceIterator.hasNext()) {
            P place = this.myPlaceIterator.next();
            found = this.lookupInside(place, key);
            if (found == null) {
                this.myVisitedPlaces.add(place);
                continue;
            }
            this.myVisitedPlaces.addFirst(place);
            break;
        }
        return found;
    }

    @Nullable
    public V lookupExhaustive(@NotNull K key) {
        P place;
        if (key == null) {
            MemorizingLookup.$$$reportNull$$$0(4);
        }
        V found = null;
        Iterator<P> iterator = this.myWhere.iterator();
        while (iterator.hasNext() && (found = (V)this.lookupInside(place = iterator.next(), key)) == null) {
        }
        return found;
    }

    @Nullable
    protected abstract V lookupInside(@NotNull P var1, @NotNull K var2);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "where";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        objectArray2[1] = "jetbrains/buildServer/util/fileLookup/MemorizingLookup";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "lookup";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "lookupInVisited";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "lookupInNew";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "lookupExhaustive";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

