/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util.fileLookup;

import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import jetbrains.buildServer.util.fileLookup.FileInfo;
import jetbrains.buildServer.util.fileLookup.MemorizingLookup;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MemorizingZipFileLookup
extends MemorizingLookup<FileInfo, String, ZipEntry> {
    @NotNull
    private final ZipFile myZip;

    public MemorizingZipFileLookup(final @NotNull ZipFile zip) {
        if (zip == null) {
            MemorizingZipFileLookup.$$$reportNull$$$0(0);
        }
        super(new Iterable<ZipEntry>(){
            @NotNull
            private final Enumeration<? extends ZipEntry> e;
            {
                this.e = zip.entries();
            }

            @Override
            public Iterator<ZipEntry> iterator() {
                return new Iterator<ZipEntry>(){
                    @Nullable
                    private ZipEntry myNext;

                    @Override
                    public boolean hasNext() {
                        if (this.myNext != null) {
                            return true;
                        }
                        while (e.hasMoreElements()) {
                            ZipEntry next = (ZipEntry)e.nextElement();
                            if (!next.isDirectory()) continue;
                            this.myNext = next;
                            break;
                        }
                        return this.myNext != null;
                    }

                    @Override
                    public ZipEntry next() {
                        if (!this.hasNext()) {
                            throw new IllegalStateException("No more elements");
                        }
                        ZipEntry next = this.myNext;
                        this.myNext = null;
                        return next;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Remove operation is not supported");
                    }
                };
            }
        });
        this.myZip = zip;
    }

    @Override
    @Nullable
    protected String lookupInside(@NotNull ZipEntry place, @NotNull FileInfo fileInfo) {
        String path;
        if (place == null) {
            MemorizingZipFileLookup.$$$reportNull$$$0(1);
        }
        if (fileInfo == null) {
            MemorizingZipFileLookup.$$$reportNull$$$0(2);
        }
        if ((path = place.getName()).endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        if (!path.endsWith(fileInfo.getParentPath())) {
            return null;
        }
        for (String name : fileInfo.getPossibleFileNames()) {
            String fileName = path + "/" + name;
            ZipEntry found = this.myZip.getEntry(fileName);
            if (found == null) continue;
            return this.myZip.getName() + ":" + fileName;
        }
        return null;
    }

    @NotNull
    public static FileInfo createFileInfo(@NotNull String filePath) {
        int slashIndex;
        if (filePath == null) {
            MemorizingZipFileLookup.$$$reportNull$$$0(3);
        }
        final String parentPath = (slashIndex = (filePath = filePath.replace("\\", "/")).lastIndexOf("/")) == -1 ? "" : filePath.substring(0, slashIndex);
        final List<String> possibleFileNames = Arrays.asList(slashIndex == -1 ? filePath : filePath.substring(slashIndex + 1));
        FileInfo fileInfo = new FileInfo(){

            @Override
            @NotNull
            public String getParentPath() {
                String string = parentPath;
                if (string == null) {
                    2.$$$reportNull$$$0(0);
                }
                return string;
            }

            @Override
            @NotNull
            public Collection<String> getPossibleFileNames() {
                Collection collection = possibleFileNames;
                if (collection == null) {
                    2.$$$reportNull$$$0(1);
                }
                return collection;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "jetbrains/buildServer/util/fileLookup/MemorizingZipFileLookup$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getParentPath";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getPossibleFileNames";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
        if (fileInfo == null) {
            MemorizingZipFileLookup.$$$reportNull$$$0(4);
        }
        return fileInfo;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "zip";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "fileInfo";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filePath";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/util/fileLookup/MemorizingZipFileLookup";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/util/fileLookup/MemorizingZipFileLookup";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "createFileInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "lookupInside";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createFileInfo";
                break;
            }
            case 4: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

