/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util.filters;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import jetbrains.buildServer.util.filters.Filter;
import org.jetbrains.annotations.NotNull;

public class FilterUtil {
    private FilterUtil() {
    }

    @NotNull
    public static <T> Filter<T> not(final @NotNull Filter<T> filter) {
        if (filter == null) {
            FilterUtil.$$$reportNull$$$0(0);
        }
        Filter filter2 = new Filter<T>(){

            @Override
            public boolean accept(@NotNull T data) {
                if (data == null) {
                    1.$$$reportNull$$$0(0);
                }
                return !filter.accept(data);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "jetbrains/buildServer/util/filters/FilterUtil$1", "accept"));
            }
        };
        if (filter2 == null) {
            FilterUtil.$$$reportNull$$$0(1);
        }
        return filter2;
    }

    @NotNull
    public static <T> Filter<T> and(final Filter<? super T> ... filters) {
        if (filters == null) {
            FilterUtil.$$$reportNull$$$0(2);
        }
        for (Filter<? super T> filter : filters) {
            if (filter != null) continue;
            throw new IllegalArgumentException("All specified filters must not be null");
        }
        Filter filter = new Filter<T>(){

            @Override
            public boolean accept(@NotNull T data) {
                if (data == null) {
                    2.$$$reportNull$$$0(0);
                }
                for (Filter filter : filters) {
                    if (filter.accept(data)) continue;
                    return false;
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "jetbrains/buildServer/util/filters/FilterUtil$2", "accept"));
            }
        };
        if (filter == null) {
            FilterUtil.$$$reportNull$$$0(3);
        }
        return filter;
    }

    public static <E, T extends Collection<? extends E>> T filterCollection(@NotNull T collection, @NotNull Filter<E> filter) {
        if (collection == null) {
            FilterUtil.$$$reportNull$$$0(4);
        }
        if (filter == null) {
            FilterUtil.$$$reportNull$$$0(5);
        }
        if (collection instanceof ArrayList) {
            return (T)FilterUtil.filterArrayList((ArrayList)collection, filter);
        }
        Iterator<E> it = collection.iterator();
        while (it.hasNext()) {
            E e = it.next();
            boolean accepted = e != null && filter.accept(e);
            if (accepted) continue;
            it.remove();
        }
        return collection;
    }

    @NotNull
    public static <E, T extends E> ArrayList<T> filterArrayList(@NotNull ArrayList<T> original, @NotNull Filter<E> filter) {
        if (original == null) {
            FilterUtil.$$$reportNull$$$0(6);
        }
        if (filter == null) {
            FilterUtil.$$$reportNull$$$0(7);
        }
        ArrayList<T> result = null;
        for (int i = 0; i < original.size(); ++i) {
            boolean accepted;
            T t = original.get(i);
            boolean bl = accepted = t != null && filter.accept(t);
            if (accepted) {
                if (result == null) continue;
                result.add(t);
                continue;
            }
            if (result != null) continue;
            result = new ArrayList<T>(original.size() - 1);
            result.addAll(original.subList(0, i));
        }
        if (result != null) {
            original.clear();
            original.addAll(result);
        }
        ArrayList<T> arrayList = original;
        if (arrayList == null) {
            FilterUtil.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @NotNull
    public static <Key, Value, T extends Map<Key, Value>> T filterMapByKey(@NotNull T map, @NotNull Filter<? super Key> filter) {
        if (map == null) {
            FilterUtil.$$$reportNull$$$0(9);
        }
        if (filter == null) {
            FilterUtil.$$$reportNull$$$0(10);
        }
        Iterator<Key> it = map.keySet().iterator();
        while (it.hasNext()) {
            Key key = it.next();
            if (filter.accept(key)) continue;
            it.remove();
        }
        T t = map;
        if (t == null) {
            FilterUtil.$$$reportNull$$$0(11);
        }
        return t;
    }

    public static <Key, Value, T extends Map<Key, Value>> T filterMapByValue(@NotNull T map, @NotNull Filter<Value> filter) {
        if (map == null) {
            FilterUtil.$$$reportNull$$$0(12);
        }
        if (filter == null) {
            FilterUtil.$$$reportNull$$$0(13);
        }
        Iterator<Key> it = map.keySet().iterator();
        while (it.hasNext()) {
            Key key = it.next();
            Value val = map.get(key);
            if (filter.accept(val)) continue;
            it.remove();
        }
        return map;
    }

    public static <Key, Value, Source extends Map<? extends Key, ? extends Value>, Target extends Map<? super Key, ? super Value>> Target filterMapByKeyAndCopy(@NotNull Source sourceMap, @NotNull Target targetMap, @NotNull Filter<? super Key> filter) {
        if (sourceMap == null) {
            FilterUtil.$$$reportNull$$$0(14);
        }
        if (targetMap == null) {
            FilterUtil.$$$reportNull$$$0(15);
        }
        if (filter == null) {
            FilterUtil.$$$reportNull$$$0(16);
        }
        for (Map.Entry<Key, Value> entry : sourceMap.entrySet()) {
            Key key = entry.getKey();
            if (!filter.accept(key)) continue;
            targetMap.put(key, entry.getValue());
        }
        return targetMap;
    }

    public static <C extends Collection<? super T>, T> C filterAndCopy(@NotNull Iterable<T> source, @NotNull C target, @NotNull Filter<? super T> filter) {
        if (source == null) {
            FilterUtil.$$$reportNull$$$0(17);
        }
        if (target == null) {
            FilterUtil.$$$reportNull$$$0(18);
        }
        if (filter == null) {
            FilterUtil.$$$reportNull$$$0(19);
        }
        for (T k : source) {
            if (!filter.accept(k)) continue;
            target.add(k);
        }
        return target;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 8: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 8: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 1: 
            case 3: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/util/filters/FilterUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filters";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "collection";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "original";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceMap";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetMap";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/util/filters/FilterUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "not";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "and";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "filterArrayList";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "filterMapByKey";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "not";
                break;
            }
            case 1: 
            case 3: 
            case 8: 
            case 11: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "and";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "filterCollection";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "filterArrayList";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "filterMapByKey";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "filterMapByValue";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "filterMapByKeyAndCopy";
                break;
            }
            case 17: 
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "filterAndCopy";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 3: 
            case 8: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

