/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util.impl;

import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.Nullable;

public abstract class Lazy<T> {
    private final AtomicReference myValue = new AtomicReference();
    private static final Object NULL_VALUE = new Object();

    @Nullable
    protected abstract T createValue();

    public T getValue() {
        Object val = this.myValue.get();
        if (val == NULL_VALUE) {
            return null;
        }
        if (val != null) {
            return (T)val;
        }
        T newVal = this.createValue();
        if (this.myValue.compareAndSet(null, newVal == null ? NULL_VALUE : newVal)) {
            return newVal;
        }
        return this.getValue();
    }

    public T getValueIfInitialized() {
        Object val = this.myValue.get();
        if (val == NULL_VALUE) {
            return null;
        }
        return (T)val;
    }

    public void resetValue() {
        this.myValue.set(null);
    }
}

