/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util.impl;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import jetbrains.buildServer.metrics.IntervalStatistic;
import jetbrains.buildServer.serverSide.TeamCityProperties;
import jetbrains.buildServer.util.TimeService;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;
import org.apache.log4j.spi.LoggingEvent;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TCLogStatistic {
    private static final Level MIN_LOG_LEVEL = Level.ERROR;
    private static volatile TCLogStatistic ourInstance;
    private final IntervalStatistic myStatistic;
    private final Level myMinLevel;
    private final AtomicReference<Long> myLastErrorTime;
    private final AtomicReference<String> myLogFileName;
    private final AtomicLong myFilePosition;
    private final Queue<String> myCaptureErrorMessages;
    @Nullable
    private volatile Layout myLayout;
    @Nullable
    private volatile String myAppenderName;
    private volatile int myMessageMaxLength;
    private volatile int myMessagesMaxCount;

    private TCLogStatistic(@NotNull IntervalStatistic statistic, @NotNull String logFileName, @NotNull Level minLevel, @Nullable String appenderName, @Nullable Layout layout, int messagesMaxCount, int messageMaxLength) {
        if (statistic == null) {
            TCLogStatistic.$$$reportNull$$$0(0);
        }
        if (logFileName == null) {
            TCLogStatistic.$$$reportNull$$$0(1);
        }
        if (minLevel == null) {
            TCLogStatistic.$$$reportNull$$$0(2);
        }
        this.myLastErrorTime = new AtomicReference();
        this.myLogFileName = new AtomicReference();
        this.myFilePosition = new AtomicLong(0L);
        this.myCaptureErrorMessages = new ConcurrentLinkedQueue<String>();
        this.myStatistic = statistic;
        this.myLogFileName.set(logFileName);
        this.myMinLevel = minLevel;
        this.myAppenderName = appenderName;
        this.myLayout = layout;
        this.myMessagesMaxCount = messagesMaxCount;
        this.myMessageMaxLength = messageMaxLength;
    }

    @Nullable
    public static TCLogStatistic init(@NotNull LoggingEvent event, @Nullable Layout layout, @Nullable String appenderName, @NotNull String logFileName, @NotNull TimeService timeService, @Nullable String periods) {
        if (event == null) {
            TCLogStatistic.$$$reportNull$$$0(3);
        }
        if (logFileName == null) {
            TCLogStatistic.$$$reportNull$$$0(4);
        }
        if (timeService == null) {
            TCLogStatistic.$$$reportNull$$$0(5);
        }
        if (event.getLevel().isGreaterOrEqual((Priority)MIN_LOG_LEVEL) && TeamCityProperties.isInitialized()) {
            String statisticAppenderName = TeamCityProperties.getProperty("teamcity.logs.errorsReport.appenderName", "");
            int messagesCount = TeamCityProperties.getInteger("teamcity.logs.errorsReport.capture.messagesCount", 10);
            messagesCount = messagesCount > -1 ? messagesCount : 10;
            int messageLength = TeamCityProperties.getInteger("teamcity.logs.errorsReport.capture.messageLength", 1024);
            int n = messageLength = messageLength > -1 ? messageLength : 1024;
            if (statisticAppenderName.equals(appenderName)) {
                if (ourInstance == null) {
                    ourInstance = new TCLogStatistic(new IntervalStatistic(timeService, periods), logFileName, MIN_LOG_LEVEL, statisticAppenderName, layout, messagesCount, messageLength);
                    return ourInstance;
                }
                return ourInstance.reInit(appenderName, messagesCount, messageLength, layout);
            }
        }
        return ourInstance;
    }

    public static void remove() {
        ourInstance = null;
    }

    private TCLogStatistic reInit(String appenderName, int messagesMaxCount, int messageMaxLength, Layout layout) {
        this.myAppenderName = appenderName;
        this.myMessageMaxLength = messageMaxLength;
        this.myMessagesMaxCount = messagesMaxCount;
        this.myLayout = layout;
        return this;
    }

    @Contract(value="null -> null; !null -> !null")
    @Nullable
    private String trimMessage(@Nullable String message) {
        if (message == null) {
            return null;
        }
        int maxLength = this.myMessageMaxLength;
        if (message.length() > maxLength) {
            message = message.substring(0, maxLength) + "...";
        }
        return message.replace("\n", " ");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(@Nullable String appenderName, @NotNull LoggingEvent event, @NotNull String logFileName, @NotNull Writer logWriter) {
        Long lastError;
        if (event == null) {
            TCLogStatistic.$$$reportNull$$$0(6);
        }
        if (logFileName == null) {
            TCLogStatistic.$$$reportNull$$$0(7);
        }
        if (logWriter == null) {
            TCLogStatistic.$$$reportNull$$$0(8);
        }
        if (appenderName == null || !appenderName.equals(this.myAppenderName) || !event.getLevel().isGreaterOrEqual((Priority)this.myMinLevel)) {
            return;
        }
        this.myStatistic.inc(event.timeStamp);
        Layout layout = this.myLayout;
        String errorMessage = this.trimMessage(layout != null ? layout.format(event) : event.getRenderedMessage());
        this.myCaptureErrorMessages.add(errorMessage);
        int count = this.myMessagesMaxCount;
        if (this.myCaptureErrorMessages.size() > count) {
            Queue<String> queue = this.myCaptureErrorMessages;
            synchronized (queue) {
                while (this.myCaptureErrorMessages.size() > count) {
                    this.myCaptureErrorMessages.remove();
                }
            }
        }
        while ((lastError = this.myLastErrorTime.get()) == null || lastError < event.timeStamp) {
            this.myLastErrorTime.compareAndSet(lastError, event.timeStamp);
        }
        if (!logFileName.equals(this.myLogFileName.get())) {
            this.myLogFileName.set(logFileName);
        }
        try {
            logWriter.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.myFilePosition.set(new File(logFileName).length());
    }

    @Nullable
    public String getLogFileName() {
        String dir = System.getProperty("teamcity_logs", "");
        String logFileName = this.myLogFileName.get();
        if (logFileName != null && logFileName.startsWith(dir)) {
            return logFileName.substring(dir.length());
        }
        return logFileName;
    }

    @Nullable
    public List<String> getCaptureErrorMessages() {
        ArrayList<String> result = new ArrayList<String>(this.myCaptureErrorMessages);
        Collections.reverse(result);
        return Collections.unmodifiableList(result);
    }

    @NotNull
    public IntervalStatistic getStatistic() {
        IntervalStatistic intervalStatistic = this.myStatistic;
        if (intervalStatistic == null) {
            TCLogStatistic.$$$reportNull$$$0(9);
        }
        return intervalStatistic;
    }

    @Nullable
    public Date getLastErrorTime() {
        Long lastError = this.myLastErrorTime.get();
        if (lastError == null) {
            return null;
        }
        return new Date(lastError);
    }

    public void rollOver(@Nullable String appenderName, @NotNull String logFileName, int maxBackupIndex) {
        if (logFileName == null) {
            TCLogStatistic.$$$reportNull$$$0(10);
        }
        if (appenderName == null || !appenderName.equals(this.myAppenderName)) {
            return;
        }
        int index = 0;
        String lastLogFileName = this.myLogFileName.get();
        if (lastLogFileName == null) {
            return;
        }
        if (!lastLogFileName.startsWith(logFileName)) {
            return;
        }
        if (!logFileName.equals(lastLogFileName)) {
            index = Integer.parseInt(lastLogFileName.substring(logFileName.length() + 1));
        }
        if (index + 1 > maxBackupIndex) {
            this.myLogFileName.compareAndSet(lastLogFileName, null);
        } else {
            this.myLogFileName.compareAndSet(lastLogFileName, logFileName + "." + (index + 1));
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "statistic";
                break;
            }
            case 1: 
            case 4: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logFileName";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "minLevel";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "timeService";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "logWriter";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/util/impl/TCLogStatistic";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/util/impl/TCLogStatistic";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatistic";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "init";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 9: {
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "rollOver";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

