/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util.pathMatcher;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import jetbrains.buildServer.util.pathMatcher.DirectoryScanner;
import jetbrains.buildServer.util.pathMatcher.RuleType;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AntPatternFileCollector {
    private static final Logger LOG = Logger.getLogger(AntPatternFileCollector.class);
    private static final Iterator<File> EMPTY_ITERATOR = new Iterator<File>(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public File next() {
            return null;
        }

        @Override
        public void remove() {
        }
    };

    public static List<File> scanDir(@NotNull File baseDir, @NotNull String[] includeRules, @NotNull String[] excludeRules, @Nullable ScanOption[] options) {
        if (baseDir == null) {
            AntPatternFileCollector.$$$reportNull$$$0(0);
        }
        if (includeRules == null) {
            AntPatternFileCollector.$$$reportNull$$$0(1);
        }
        if (excludeRules == null) {
            AntPatternFileCollector.$$$reportNull$$$0(2);
        }
        return AntPatternFileCollector.scanDir(baseDir, AntPatternFileCollector.mergePatterns(includeRules, excludeRules), options);
    }

    @NotNull
    private static String[] mergePatterns(@NotNull String[] includeRules, @NotNull String[] excludeRules) {
        if (includeRules == null) {
            AntPatternFileCollector.$$$reportNull$$$0(3);
        }
        if (excludeRules == null) {
            AntPatternFileCollector.$$$reportNull$$$0(4);
        }
        String[] rules = new String[includeRules.length + excludeRules.length];
        for (int i = 0; i < excludeRules.length; ++i) {
            rules[i] = String.format("%s:%s", RuleType.EXCLUDE.getPrefix(), excludeRules[i]);
        }
        System.arraycopy(includeRules, 0, rules, excludeRules.length, includeRules.length);
        if (rules == null) {
            AntPatternFileCollector.$$$reportNull$$$0(5);
        }
        return rules;
    }

    public static List<File> scanDir(@NotNull File baseDir, @NotNull String[] rules, @Nullable ScanOption[] options) {
        if (baseDir == null) {
            AntPatternFileCollector.$$$reportNull$$$0(6);
        }
        if (rules == null) {
            AntPatternFileCollector.$$$reportNull$$$0(7);
        }
        if (!baseDir.exists()) {
            LOG.warn((Object)String.format("baseDir %s does not exist", baseDir.getAbsolutePath()));
            return Collections.emptyList();
        }
        if (!baseDir.isDirectory()) {
            LOG.warn((Object)String.format("baseDir %s is not a directory", baseDir.getAbsolutePath()));
            return Collections.emptyList();
        }
        DirectoryScanner scanner = new DirectoryScanner(baseDir, rules, options);
        scanner.scan();
        ArrayList<File> files = new ArrayList<File>(scanner.getIncludedFiles());
        Collections.sort(files);
        return files;
    }

    public static Iterator<File> scanDirIteratively(@NotNull File baseDir, @NotNull String[] rules, @Nullable ScanOption[] options) {
        if (baseDir == null) {
            AntPatternFileCollector.$$$reportNull$$$0(8);
        }
        if (rules == null) {
            AntPatternFileCollector.$$$reportNull$$$0(9);
        }
        if (!baseDir.exists()) {
            LOG.warn((Object)String.format("baseDir %s does not exist", baseDir.getAbsolutePath()));
            return EMPTY_ITERATOR;
        }
        if (!baseDir.isDirectory()) {
            LOG.warn((Object)String.format("baseDir %s is not a directory", baseDir.getAbsolutePath()));
            return EMPTY_ITERATOR;
        }
        DirectoryScanner scanner = new DirectoryScanner(baseDir, rules, options);
        scanner.setScanIteratively(true);
        return scanner.iterator();
    }

    @Nullable
    public static String validate(@NotNull File baseDir, @NotNull String[] includePatterns, @NotNull String[] excludePatterns, ScanOption ... options) {
        if (baseDir == null) {
            AntPatternFileCollector.$$$reportNull$$$0(10);
        }
        if (includePatterns == null) {
            AntPatternFileCollector.$$$reportNull$$$0(11);
        }
        if (excludePatterns == null) {
            AntPatternFileCollector.$$$reportNull$$$0(12);
        }
        try {
            new DirectoryScanner(baseDir, AntPatternFileCollector.mergePatterns(includePatterns, excludePatterns), options);
        }
        catch (Exception ex) {
            return ex.getMessage();
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "includeRules";
                break;
            }
            case 2: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludeRules";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/util/pathMatcher/AntPatternFileCollector";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rules";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "includePatterns";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "excludePatterns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/util/pathMatcher/AntPatternFileCollector";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "mergePatterns";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "scanDir";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "mergePatterns";
                break;
            }
            case 5: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "scanDirIteratively";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "validate";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static enum ScanOption {
        PRIORITIZE_EXCLUDES,
        USE_RULE_STRICTNESS,
        INCLUDE_ALL_IF_NO_RULES,
        ALLOW_EXTERNAL_SCAN,
        NOT_FOLLOW_SYMLINK_DIRS,
        MATCH_DIRECTORIES,
        SCAN_ITERATIVELY;

    }
}

