/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util.pathMatcher;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.SystemInfo;
import java.io.File;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jetbrains.buildServer.util.FileUtil;
import jetbrains.buildServer.util.pathMatcher.AntPatternFileCollector;
import jetbrains.buildServer.util.pathMatcher.RuleType;
import jetbrains.buildServer.util.pathMatcher.SearchPattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DirectoryScanner
implements Iterable<File> {
    private static final SearchPattern INCLUDE_ALL_PATTERN = SearchPattern.patternFromString("+:**");
    private static final Pattern UNC_PATH_PATTERN = Pattern.compile("(\\\\\\\\[^\\\\]+\\\\[^\\\\]+)(\\\\[^\\\\]*)*");
    private static final Pattern WINDOWS_DISKFILE_PATTERN = Pattern.compile("([a-zA-Z]):.*");
    private final Set<File> myIncludedFiles;
    private final Queue<File> myNotReturnedFiles;
    private Queue<ScanDirState> myScanDirStates;
    private final Map<File, List<SearchPattern>> mySearchPatternsByDir;
    private File myBaseDir;
    private final boolean myPrioritizeExcludes;
    private final boolean myStrictRulesApplyFirst;
    private final boolean myIncludeAllIfNoRules;
    private final boolean myAllowExternalScan;
    private final boolean myMatchDirectories;
    private boolean myScanIteratively;
    private boolean myIterativeScanStarted;
    private boolean myIterativeScanComplete;
    private static final Comparator<String> FILENAMES_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            assert (o1 != null);
            assert (o2 != null);
            return SystemInfo.isFileSystemCaseSensitive ? o1.compareTo(o2) : o1.compareToIgnoreCase(o2);
        }
    };
    private final Iterator<File> myIterator;
    private final boolean myNotFollowSymlinkDirs;

    DirectoryScanner(@NotNull File baseDir, @NotNull String[] patternStrings, @Nullable AntPatternFileCollector.ScanOption[] options) {
        if (baseDir == null) {
            DirectoryScanner.$$$reportNull$$$0(0);
        }
        if (patternStrings == null) {
            DirectoryScanner.$$$reportNull$$$0(1);
        }
        this.myIncludedFiles = new HashSet<File>();
        this.myNotReturnedFiles = new ArrayDeque<File>();
        this.myScanDirStates = new ArrayDeque<ScanDirState>();
        this.mySearchPatternsByDir = new HashMap<File, List<SearchPattern>>();
        this.myIterativeScanStarted = false;
        this.myIterativeScanComplete = false;
        this.myIterator = new Iterator<File>(){

            @Override
            public boolean hasNext() {
                if (DirectoryScanner.this.myIterativeScanComplete) {
                    return false;
                }
                if (DirectoryScanner.this.myNotReturnedFiles.size() > 0) {
                    return true;
                }
                return DirectoryScanner.this.pollForNextFiles();
            }

            @Override
            public File next() {
                if (DirectoryScanner.this.myNotReturnedFiles.peek() == null) {
                    DirectoryScanner.this.pollForNextFiles();
                }
                return (File)DirectoryScanner.this.myNotReturnedFiles.poll();
            }

            @Override
            public void remove() {
            }
        };
        this.myBaseDir = DirectoryScanner.normalizeBaseDir(baseDir);
        HashSet<AntPatternFileCollector.ScanOption> optionsSet = new HashSet<AntPatternFileCollector.ScanOption>();
        if (options != null) {
            optionsSet.addAll(Arrays.asList(options));
        }
        this.myAllowExternalScan = optionsSet.contains((Object)AntPatternFileCollector.ScanOption.ALLOW_EXTERNAL_SCAN);
        this.myPrioritizeExcludes = optionsSet.contains((Object)AntPatternFileCollector.ScanOption.PRIORITIZE_EXCLUDES);
        this.myStrictRulesApplyFirst = optionsSet.contains((Object)AntPatternFileCollector.ScanOption.USE_RULE_STRICTNESS);
        this.myIncludeAllIfNoRules = optionsSet.contains((Object)AntPatternFileCollector.ScanOption.INCLUDE_ALL_IF_NO_RULES);
        this.myNotFollowSymlinkDirs = optionsSet.contains((Object)AntPatternFileCollector.ScanOption.NOT_FOLLOW_SYMLINK_DIRS);
        this.myMatchDirectories = optionsSet.contains((Object)AntPatternFileCollector.ScanOption.MATCH_DIRECTORIES);
        ArrayList<SearchPattern> patternList = new ArrayList<SearchPattern>();
        for (String s : patternStrings) {
            SearchPattern pattern = SearchPattern.patternFromString(s);
            if (pattern == null) continue;
            patternList.add(pattern);
        }
        this.normalizePatterns(patternList);
    }

    public void setScanIteratively(boolean scanIteratively) {
        this.myScanIteratively = scanIteratively;
    }

    void scan() {
        this.myIterativeScanStarted = true;
        this.myIncludedFiles.clear();
        for (Map.Entry<File, List<SearchPattern>> entry : this.mySearchPatternsByDir.entrySet()) {
            ArrayList<SearchPattern.PatternPart> patternParts = new ArrayList<SearchPattern.PatternPart>();
            for (SearchPattern searchPattern : entry.getValue()) {
                patternParts.add(searchPattern.getInitialState());
            }
            this.scanDir(entry.getKey(), new ArrayList<String>(), patternParts);
        }
    }

    Set<File> getIncludedFiles() {
        if (this.myScanIteratively) {
            while (!this.myIterativeScanComplete) {
                this.myIterator.next();
            }
        }
        return this.myIncludedFiles;
    }

    private static File normalizeBaseDir(@NotNull File baseDir) {
        if (baseDir == null) {
            DirectoryScanner.$$$reportNull$$$0(2);
        }
        if (UNC_PATH_PATTERN.matcher(baseDir.getPath()).matches()) {
            return baseDir;
        }
        return new File(new File(baseDir.getPath()).toURI().normalize());
    }

    private void normalizePatterns(List<SearchPattern> searchPatterns) {
        boolean containsAbsolute = false;
        int outsideLevel = 0;
        for (SearchPattern sp : searchPatterns) {
            if (sp.isIsAbsolute()) {
                containsAbsolute = true;
            }
            outsideLevel = Math.max(outsideLevel, sp.getOutsideLevel());
        }
        if (!this.myAllowExternalScan && outsideLevel > 0) {
            throw new IllegalStateException("External scan (outside of basedir) is not allowed. base dir: " + this.myBaseDir.getAbsolutePath() + ", search patterns: " + searchPatterns.toString());
        }
        this.processOutsideLevel(searchPatterns, outsideLevel);
        HashMap<String, File> roots = new HashMap<String, File>();
        HashMap rules = new HashMap();
        String baseDirRoot = this.getRoot(this.myBaseDir.getAbsolutePath());
        roots.put(baseDirRoot, this.myBaseDir);
        rules.put(baseDirRoot, new ArrayList());
        for (SearchPattern searchPattern : searchPatterns) {
            File baseDirCandidate;
            String absolutePath = searchPattern.isIsAbsolute() ? searchPattern.getFullPatternString() : new File(this.myBaseDir, searchPattern.getFullPatternString()).getAbsolutePath();
            String rootName = this.getRoot(absolutePath);
            if (rootName == null) continue;
            if (!roots.containsKey(rootName)) {
                baseDirCandidate = this.getBaseDirCandidate(new File(absolutePath));
                if (baseDirCandidate == null) continue;
                roots.put(rootName, baseDirCandidate);
                rules.put(rootName, new ArrayList());
            } else {
                baseDirCandidate = (File)roots.get(rootName);
                baseDirCandidate = FileUtil.getCommonParentFile(new File(absolutePath), baseDirCandidate);
                roots.put(rootName, baseDirCandidate);
            }
            ((List)rules.get(rootName)).add(SearchPattern.patternFromString(String.format("%s:%s", searchPattern.getRuleType().getPrefix(), absolutePath)));
        }
        for (String string : rules.keySet()) {
            List patterns = (List)rules.get(string);
            File baseDir = (File)roots.get(string);
            ArrayList<SearchPattern> relativePatterns = new ArrayList<SearchPattern>(rules.size());
            for (SearchPattern sp : patterns) {
                relativePatterns.add(SearchPattern.patternFromString(String.format("%s:%s", sp.getRuleType().getPrefix(), FileUtil.getRelativePath((File)baseDir, (File)new File(sp.getFullPatternString())))));
            }
            this.mySearchPatternsByDir.put(baseDir, relativePatterns);
        }
        for (Map.Entry entry : this.mySearchPatternsByDir.entrySet()) {
            List<SearchPattern> sortedList;
            List srcList = (List)entry.getValue();
            List list = sortedList = this.myPrioritizeExcludes || this.myStrictRulesApplyFirst ? new ArrayList(((List)entry.getValue()).size()) : srcList;
            if (this.myPrioritizeExcludes) {
                this.populatePatternsList(srcList, sortedList, new Condition<SearchPattern>(){

                    public boolean value(SearchPattern searchPattern) {
                        return searchPattern.getRuleType() == RuleType.EXCLUDE;
                    }
                });
                this.populatePatternsList(srcList, sortedList, new Condition<SearchPattern>(){

                    public boolean value(SearchPattern searchPattern) {
                        return searchPattern.getRuleType() == RuleType.INCLUDE;
                    }
                });
            } else if (this.myStrictRulesApplyFirst) {
                this.populatePatternsList(srcList, sortedList, (Condition<SearchPattern>)Condition.TRUE);
            }
            boolean noIncludes = true;
            for (SearchPattern searchPattern : sortedList) {
                if (searchPattern.getRuleType() != RuleType.INCLUDE) continue;
                noIncludes = false;
                break;
            }
            if (this.myIncludeAllIfNoRules && sortedList.size() == 0 || noIncludes && sortedList.size() > 0) {
                sortedList.add(INCLUDE_ALL_PATTERN);
            }
            while (sortedList.size() > 0 && sortedList.get(sortedList.size() - 1).getRuleType() == RuleType.EXCLUDE) {
                sortedList.remove(sortedList.size() - 1);
            }
            entry.setValue(sortedList);
        }
        if (!this.myAllowExternalScan) {
            for (File file : this.mySearchPatternsByDir.keySet()) {
                if (FileUtil.isAncestor(this.myBaseDir.getAbsoluteFile(), file.getAbsoluteFile(), false)) continue;
                throw new IllegalStateException(String.format("External scan (outside of basedir) is not allowed. Base dir: %s, suggested baseDir: %s, search patterns: %s", this.myBaseDir.getAbsolutePath(), file.getAbsolutePath(), searchPatterns.toString()));
            }
        }
    }

    private void processOutsideLevel(List<SearchPattern> searchPatterns, int outsideLevel) {
        if (outsideLevel == 0) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < outsideLevel; ++i) {
            builder.insert(0, File.separator).insert(0, this.myBaseDir.getName());
            File parentFile = FileUtil.getParentFile((File)this.myBaseDir);
            if (parentFile == null) {
                throw new IllegalStateException("outsideLevel > folderLevel!");
            }
            this.myBaseDir = parentFile;
        }
        String path2add = builder.toString();
        ArrayList<SearchPattern> updatedPatterns = new ArrayList<SearchPattern>(searchPatterns.size());
        for (SearchPattern sp : searchPatterns) {
            if (!sp.isIsAbsolute()) {
                String newPath = FileUtil.normalizeRelativePath(path2add + sp.getFullPatternString());
                updatedPatterns.add(SearchPattern.patternFromString(String.format("%s:%s", sp.getRuleType().getPrefix(), newPath)));
                continue;
            }
            updatedPatterns.add(sp);
        }
        searchPatterns.clear();
        searchPatterns.addAll(updatedPatterns);
    }

    private String getRoot(String absolutePath) {
        if (SystemInfo.isUnix) {
            return "/";
        }
        if (WINDOWS_DISKFILE_PATTERN.matcher(absolutePath).matches()) {
            return absolutePath.substring(0, 1);
        }
        Matcher uncPathMatcher = UNC_PATH_PATTERN.matcher(absolutePath);
        if (uncPathMatcher.matches()) {
            return uncPathMatcher.group(1);
        }
        return null;
    }

    private File getBaseDirCandidate(File patternFile) {
        while (patternFile != null && (patternFile.getAbsolutePath().contains("*") || patternFile.getAbsolutePath().contains("?") || !patternFile.isDirectory())) {
            patternFile = patternFile.getParentFile();
        }
        return patternFile;
    }

    private void populatePatternsList(List<SearchPattern> patterns, List<SearchPattern> populateList, Condition<SearchPattern> condition) {
        for (SearchPattern pattern : patterns) {
            if (pattern == null || "".equals(pattern.getFullPatternString()) || populateList.contains(pattern) || !condition.value((Object)pattern)) continue;
            if (this.myStrictRulesApplyFirst) {
                this.addRuleWithPriority(pattern, populateList);
                continue;
            }
            populateList.add(pattern);
        }
    }

    private void addRuleWithPriority(SearchPattern pattern, List<SearchPattern> populateList) {
        int insertPosition = -1;
        int currentIdx = 0;
        for (SearchPattern nextPattern : populateList) {
            if (pattern.isSubPatternOf(nextPattern)) {
                insertPosition = currentIdx;
                break;
            }
            ++currentIdx;
        }
        if (insertPosition > -1) {
            populateList.add(insertPosition, pattern);
        } else {
            populateList.add(pattern);
        }
    }

    private void scanDir(File directory, List<String> currentPath, List<SearchPattern.PatternPart> searchRules) {
        if (this.myScanIteratively && this.myNotReturnedFiles.size() > 0) {
            this.myScanDirStates.add(new ScanDirState(directory, new ArrayList<String>(currentPath), new ArrayList<SearchPattern.PatternPart>(searchRules)));
            return;
        }
        if (searchRules.size() == 0) {
            return;
        }
        boolean requireListing = false;
        boolean precise = true;
        for (SearchPattern.PatternPart searchRule : searchRules) {
            if (searchRule.getCurrentPiece().contains("*") || searchRule.getCurrentPiece().contains("?")) {
                requireListing = true;
                precise = false;
                break;
            }
            if (!searchRule.containsWildcard()) continue;
            precise = false;
        }
        if (precise) {
            for (SearchPattern.PatternPart rule : searchRules) {
                File file = new File(directory, rule.getPatternString());
                if (!file.exists() || !file.isFile() && !this.myMatchDirectories) continue;
                this.processMatchedFile(file, rule.getRuleType());
            }
            return;
        }
        LinkedHashMap<File, List<SearchPattern.PatternPart>> directoriesToProcess = new LinkedHashMap<File, List<SearchPattern.PatternPart>>();
        if (requireListing) {
            this.processDirectoryContent(directory, currentPath, searchRules, directoriesToProcess);
        } else {
            this.processRules(directory, currentPath, searchRules, directoriesToProcess);
        }
        for (Map.Entry entry : directoriesToProcess.entrySet()) {
            if (this.myNotFollowSymlinkDirs && FileUtil.isSymlink((File)entry.getKey())) continue;
            currentPath.add(((File)entry.getKey()).getName());
            this.scanDir((File)entry.getKey(), currentPath, (List)entry.getValue());
            currentPath.remove(currentPath.size() - 1);
        }
    }

    private void processRules(File directory, List<String> currentPath, List<SearchPattern.PatternPart> searchRules, Map<File, List<SearchPattern.PatternPart>> directoriesToProcess) {
        ArrayList<String> entriesProcessed = new ArrayList<String>();
        for (SearchPattern.PatternPart rule : searchRules) {
            File fileDir;
            String filename = rule.getCurrentPiece();
            if (entriesProcessed.contains(filename) || !(fileDir = new File(directory, filename)).exists()) continue;
            if (fileDir.isDirectory()) {
                if (rule.isExhausted()) {
                    if (!this.myMatchDirectories || !rule.matches(currentPath)) continue;
                    this.processMatchedFile(fileDir, rule.getRuleType());
                    break;
                }
                if (this.myMatchDirectories && rule.matches(currentPath)) {
                    this.processMatchedFile(fileDir, rule.getRuleType());
                }
                if (!directoriesToProcess.containsKey(fileDir)) {
                    directoriesToProcess.put(fileDir, new ArrayList());
                }
                if (rule.matchesAllInside(fileDir.getName())) {
                    entriesProcessed.add(filename);
                    if (rule.getRuleType() == RuleType.EXCLUDE) continue;
                    directoriesToProcess.get(fileDir).add(rule.getNextState());
                    continue;
                }
                directoriesToProcess.get(fileDir).add(rule.getNextState());
                continue;
            }
            if (!fileDir.isFile() || !rule.matches(currentPath, fileDir.getName())) continue;
            this.processMatchedFile(fileDir, rule.getRuleType());
            entriesProcessed.add(filename);
        }
    }

    private void processDirectoryContent(File directory, List<String> currentPath, List<SearchPattern.PatternPart> searchRules, Map<File, List<SearchPattern.PatternPart>> directoriesToProcess) {
        String[] directoryContent = directory.list();
        if (directoryContent == null) {
            return;
        }
        Arrays.sort(directoryContent, FILENAMES_COMPARATOR);
        block0: for (String filename : directoryContent) {
            for (SearchPattern.PatternPart rule : searchRules) {
                if (!rule.find(filename)) continue;
                File fileDir = new File(directory, filename);
                if (fileDir.isDirectory()) {
                    if (rule.isExhausted()) continue;
                    if (!directoriesToProcess.containsKey(fileDir)) {
                        directoriesToProcess.put(fileDir, new ArrayList());
                    }
                    if (this.myMatchDirectories && rule.matches(currentPath, filename)) {
                        this.processMatchedFile(fileDir, rule.getRuleType());
                    }
                    if (rule.matchesAllInside(filename)) {
                        if (rule.getRuleType() != RuleType.INCLUDE) continue block0;
                        directoriesToProcess.get(fileDir).add(rule.getNextState());
                        if (!this.myMatchDirectories || !rule.matches(currentPath)) continue block0;
                        this.processMatchedFile(fileDir, rule.getRuleType());
                        continue block0;
                    }
                    directoriesToProcess.get(fileDir).add(rule.getNextState());
                    continue;
                }
                if (!fileDir.isFile() || !rule.matches(currentPath, filename)) continue;
                this.processMatchedFile(fileDir, rule.getRuleType());
                continue block0;
            }
        }
    }

    private void processMatchedFile(File file, RuleType ruleType) {
        if (ruleType == RuleType.INCLUDE) {
            if (this.myScanIteratively && !this.myIncludedFiles.contains(file)) {
                this.myNotReturnedFiles.add(file);
            }
            this.myIncludedFiles.add(file);
        }
    }

    @Override
    @NotNull
    public Iterator<File> iterator() {
        Iterator<File> iterator = this.myIterator;
        if (iterator == null) {
            DirectoryScanner.$$$reportNull$$$0(3);
        }
        return iterator;
    }

    private boolean pollForNextFiles() {
        if (!this.myIterativeScanStarted) {
            this.scan();
        }
        while (this.myNotReturnedFiles.size() == 0) {
            ScanDirState dirState = this.myScanDirStates.poll();
            if (dirState == null) {
                this.myIterativeScanComplete = true;
                return false;
            }
            this.scanDir(dirState.directory, dirState.currentPath, dirState.searchRules);
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseDir";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patternStrings";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/util/pathMatcher/DirectoryScanner";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/util/pathMatcher/DirectoryScanner";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "iterator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "normalizeBaseDir";
                break;
            }
            case 3: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class ScanDirState {
        final File directory;
        final List<String> currentPath;
        final List<SearchPattern.PatternPart> searchRules;

        public ScanDirState(File directory, List<String> currentPath, List<SearchPattern.PatternPart> searchRules) {
            this.directory = directory;
            this.currentPath = currentPath;
            this.searchRules = searchRules;
        }
    }
}

