/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util.pathMatcher;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jetbrains.buildServer.util.pathMatcher.AntPatternTreeMatcher;
import jetbrains.buildServer.util.pathMatcher.PathNode;
import jetbrains.buildServer.util.pathMatcher.PathNodeUtils;
import jetbrains.buildServer.util.pathMatcher.RuleType;
import jetbrains.buildServer.util.pathMatcher.SearchPattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class NodeScanner<T extends PathNode<T>> {
    private final Set<T> myIncludedNodes;
    private final List<SearchPattern> myPatternList;
    private final boolean myLeafsOnly;
    private final AntPatternTreeMatcher.SearchCallback<T> mySearchCallback;
    private boolean myContinueSearch;

    NodeScanner(@NotNull Collection<String> patternStrings, @Nullable AntPatternTreeMatcher.SearchCallback<T> searchCallback, AntPatternTreeMatcher.ScanOption ... scanOptions) {
        if (patternStrings == null) {
            NodeScanner.$$$reportNull$$$0(0);
        }
        this.myIncludedNodes = new HashSet<T>();
        this.myPatternList = new ArrayList<SearchPattern>();
        this.mySearchCallback = searchCallback;
        boolean leafsOnly = false;
        for (AntPatternTreeMatcher.ScanOption option : scanOptions) {
            switch (option) {
                case LEAFS_ONLY: {
                    leafsOnly = true;
                }
            }
        }
        this.myLeafsOnly = leafsOnly;
        for (String s : patternStrings) {
            SearchPattern pattern = SearchPattern.patternFromString(s);
            if (pattern == null) continue;
            this.myPatternList.add(pattern);
        }
    }

    void scan(@NotNull T baseNode) {
        if (baseNode == null) {
            NodeScanner.$$$reportNull$$$0(1);
        }
        this.myIncludedNodes.clear();
        this.myContinueSearch = true;
        ArrayList<SearchPattern.PatternPart> patternParts = new ArrayList<SearchPattern.PatternPart>();
        for (SearchPattern searchPattern : this.myPatternList) {
            patternParts.add(searchPattern.getInitialState());
        }
        this.scanNode(baseNode, new ArrayList<String>(), patternParts);
    }

    Set<T> getIncludedNodes() {
        return this.myIncludedNodes;
    }

    private void scanNode(T node, List<String> currentPath, List<SearchPattern.PatternPart> searchRules) {
        if (!this.myContinueSearch) {
            return;
        }
        if (searchRules.size() == 0) {
            return;
        }
        boolean requireListing = false;
        boolean precise = true;
        for (SearchPattern.PatternPart searchRule : searchRules) {
            if (searchRule.getCurrentPiece().contains("*") || searchRule.getCurrentPiece().contains("?")) {
                requireListing = true;
                precise = false;
                break;
            }
            if (!searchRule.containsWildcard()) continue;
            precise = false;
        }
        if (precise) {
            for (SearchPattern.PatternPart rule : searchRules) {
                T matchedNode = PathNodeUtils.createFromParentPath(node, rule.getPathParts());
                if (matchedNode == null || this.processMatchedNode(matchedNode, rule.getRuleType())) continue;
                return;
            }
            return;
        }
        HashMap nodesToProcess = new HashMap();
        if (requireListing) {
            this.processNodeContent(node, currentPath, searchRules, nodesToProcess);
        } else {
            this.processRules(node, currentPath, searchRules, nodesToProcess);
        }
        for (Map.Entry entry : nodesToProcess.entrySet()) {
            currentPath.add(((PathNode)entry.getKey()).getName());
            this.scanNode((PathNode)entry.getKey(), currentPath, (List)entry.getValue());
            currentPath.remove(currentPath.size() - 1);
        }
    }

    private void processRules(T node, List<String> currentPath, List<SearchPattern.PatternPart> searchRules, Map<T, List<SearchPattern.PatternPart>> nodesToProcess) {
        if (!this.myContinueSearch) {
            return;
        }
        ArrayList<String> entriesProcessed = new ArrayList<String>();
        for (SearchPattern.PatternPart rule : searchRules) {
            T childNode;
            String pathPart = rule.getCurrentPiece();
            if (entriesProcessed.contains(pathPart) || (childNode = PathNodeUtils.getChild(node, pathPart)) == null) continue;
            if (PathNodeUtils.hasChildren(childNode)) {
                if (rule.isExhausted()) {
                    if (this.processMatchedNode(childNode, rule.getRuleType())) continue;
                    return;
                }
                if (!nodesToProcess.containsKey(childNode)) {
                    nodesToProcess.put(childNode, new ArrayList());
                }
                if (rule.matchesAllInside(childNode.getName())) {
                    entriesProcessed.add(pathPart);
                    if (rule.getRuleType() == RuleType.EXCLUDE) continue;
                    nodesToProcess.get(childNode).add(rule.getNextState());
                    continue;
                }
                nodesToProcess.get(childNode).add(rule.getNextState());
                continue;
            }
            if (!rule.matches(currentPath, childNode.getName())) continue;
            if (!this.processMatchedNode(childNode, rule.getRuleType())) {
                return;
            }
            entriesProcessed.add(pathPart);
        }
    }

    private void processNodeContent(T node, List<String> currentPath, List<SearchPattern.PatternPart> searchRules, Map<T, List<SearchPattern.PatternPart>> nodesToProcess) {
        Iterable nodeChildIterable;
        if (!this.myContinueSearch) {
            return;
        }
        for (SearchPattern.PatternPart rule : searchRules) {
            if (!rule.matches(currentPath)) continue;
            if (this.processMatchedNode(node, rule.getRuleType())) break;
            return;
        }
        if ((nodeChildIterable = node.getChildren()) == null) {
            return;
        }
        block1: for (PathNode childNode : nodeChildIterable) {
            for (SearchPattern.PatternPart rule : searchRules) {
                if (!rule.find(childNode.getName())) continue;
                if (PathNodeUtils.hasChildren(childNode)) {
                    if (rule.isExhausted()) {
                        if (this.processMatchedNode(childNode, rule.getRuleType())) continue;
                        return;
                    }
                    if (!nodesToProcess.containsKey(childNode)) {
                        nodesToProcess.put(childNode, new ArrayList());
                    }
                    if (rule.matchesAllInside(childNode.getName())) {
                        if (rule.getRuleType() != RuleType.INCLUDE) continue block1;
                        nodesToProcess.get(childNode).add(rule.getNextState());
                        continue block1;
                    }
                    nodesToProcess.get(childNode).add(rule.getNextState());
                    continue;
                }
                boolean matches = rule.matches(currentPath, childNode.getName());
                if (!matches) continue;
                if (this.processMatchedNode(childNode, rule.getRuleType())) continue block1;
                return;
            }
        }
    }

    private boolean processMatchedNode(T node, RuleType ruleType) {
        if (node.getChildren() != null && this.myLeafsOnly) {
            return this.myContinueSearch;
        }
        if (ruleType == RuleType.INCLUDE) {
            this.myIncludedNodes.add(node);
            if (this.mySearchCallback != null && !this.mySearchCallback.nodeMatched(node)) {
                this.myContinueSearch = false;
            }
        }
        return this.myContinueSearch;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "patternStrings";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "baseNode";
                break;
            }
        }
        objectArray2[1] = "jetbrains/buildServer/util/pathMatcher/NodeScanner";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "scan";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

