/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util.pathMatcher;

import com.intellij.openapi.util.SystemInfo;
import jetbrains.buildServer.util.pathMatcher.PathNode;
import jetbrains.buildServer.util.pathMatcher.PathNodeEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PathNodeUtils {
    @NotNull
    public static String getFullPath(@NotNull PathNodeEx pathNode) {
        if (pathNode == null) {
            PathNodeUtils.$$$reportNull$$$0(0);
        }
        StringBuilder path = new StringBuilder();
        while (pathNode != null) {
            path.insert(0, pathNode.getName()).insert(0, "/");
            pathNode = pathNode.getParent();
        }
        String string = path.substring(1);
        if (string == null) {
            PathNodeUtils.$$$reportNull$$$0(1);
        }
        return string;
    }

    @Nullable
    public static <T extends PathNode<T>> T createFromParentPath(@NotNull T parent, @NotNull Iterable<String> pathParts) {
        if (parent == null) {
            PathNodeUtils.$$$reportNull$$$0(2);
        }
        if (pathParts == null) {
            PathNodeUtils.$$$reportNull$$$0(3);
        }
        for (String pathPart : pathParts) {
            Iterable<T> children = parent.getChildren();
            if (children == null) {
                return null;
            }
            boolean found = false;
            for (PathNode node : children) {
                if (!(SystemInfo.isFileSystemCaseSensitive ? pathPart.equals(node.getName()) : pathPart.equalsIgnoreCase(node.getName()))) continue;
                parent = node;
                found = true;
                break;
            }
            if (found) continue;
            return null;
        }
        return parent;
    }

    public static boolean hasChildren(@NotNull PathNode node) {
        if (node == null) {
            PathNodeUtils.$$$reportNull$$$0(4);
        }
        return node.getChildren() != null;
    }

    @Nullable
    public static <T extends PathNode<T>> T getChild(@NotNull T node, @NotNull String childName) {
        if (node == null) {
            PathNodeUtils.$$$reportNull$$$0(5);
        }
        if (childName == null) {
            PathNodeUtils.$$$reportNull$$$0(6);
        }
        if (node.getChildren() == null) {
            return null;
        }
        if (node instanceof PathNodeEx) {
            return ((PathNodeEx)node).getChild(childName);
        }
        for (PathNode childNode : node.getChildren()) {
            if (!childName.equals(childNode.getName())) continue;
            return (T)childNode;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathNode";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/util/pathMatcher/PathNodeUtils";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pathParts";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/util/pathMatcher/PathNodeUtils";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFullPath";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFullPath";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createFromParentPath";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "hasChildren";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getChild";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

