/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util.pathMatcher;

import com.intellij.openapi.util.SystemInfo;
import java.io.File;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jetbrains.buildServer.util.pathMatcher.RuleType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SearchPattern {
    private static final String DEEP_TREE_MATCH = "**";
    private static final String UPPER_DIR = "..";
    private static final Pattern RULE_PATTERN = Pattern.compile("((?:[+-]):)?(.+)");
    private static final String SPLIT_PATTERN = SystemInfo.isWindows ? "[/\\\\]" : "[/]";
    private final String myFullPatternString;
    private final String[] myPatternTokens;
    private final RuleType myRuleType;
    private int myFirstDeepTreeIdx = -1;
    private int myLastDeepTreeIdx = -1;
    private boolean myIsAbsolute = false;
    private int myOutsideLevel = 0;

    @Nullable
    public static SearchPattern patternFromString(String patternString) {
        Matcher matcher = RULE_PATTERN.matcher(patternString);
        if (matcher.matches()) {
            RuleType type = RuleType.getRuleType(matcher.group(1));
            return new SearchPattern(type, matcher.group(2));
        }
        return null;
    }

    public static boolean wildcardMatch(@NotNull String dirOrSubpattern, @NotNull String pattern) {
        int firstStarIdx;
        if (dirOrSubpattern == null) {
            SearchPattern.$$$reportNull$$$0(0);
        }
        if (pattern == null) {
            SearchPattern.$$$reportNull$$$0(1);
        }
        if ((firstStarIdx = pattern.indexOf(42)) == -1) {
            return pattern.length() == dirOrSubpattern.length() && SearchPattern.matchSubstrings(pattern, 0, dirOrSubpattern, 0, pattern.length());
        }
        if (!SearchPattern.matchSubstrings(pattern, 0, dirOrSubpattern, 0, firstStarIdx)) {
            return false;
        }
        int lastStarIdx = pattern.lastIndexOf(42);
        int suffixLength = pattern.length() - lastStarIdx - 1;
        if (suffixLength > dirOrSubpattern.length()) {
            return false;
        }
        if (dirOrSubpattern.length() - suffixLength - firstStarIdx < 0) {
            return false;
        }
        if (!SearchPattern.matchSubstrings(pattern, pattern.length() - suffixLength, dirOrSubpattern, dirOrSubpattern.length() - suffixLength, suffixLength)) {
            return false;
        }
        return SearchPattern.wildcardMatchInternal(pattern.substring(firstStarIdx, lastStarIdx + 1), dirOrSubpattern.substring(firstStarIdx, dirOrSubpattern.length() - (pattern.length() - lastStarIdx) + 1));
    }

    private SearchPattern(RuleType ruleType, String patternString) {
        this.myRuleType = ruleType;
        String normalizedPattern = SearchPattern.normalizePatternString(patternString);
        StringBuilder builder = new StringBuilder();
        String prevPiece = null;
        int currentPosition = 0;
        ArrayDeque<String> pathPieces = new ArrayDeque<String>();
        for (String piece : normalizedPattern.split(SPLIT_PATTERN)) {
            List<String> normalizedPieces = SearchPattern.normalizePiece(piece);
            for (String normalizedPiece : normalizedPieces) {
                if (DEEP_TREE_MATCH.equals(normalizedPiece) && DEEP_TREE_MATCH.equals(prevPiece)) continue;
                if (UPPER_DIR.equals(normalizedPiece)) {
                    String peekLast = (String)pathPieces.peekLast();
                    if (peekLast != null && !UPPER_DIR.equals(peekLast)) {
                        if (!DEEP_TREE_MATCH.equals(peekLast)) {
                            pathPieces.pollLast();
                        }
                    } else {
                        pathPieces.add(normalizedPiece);
                        ++this.myOutsideLevel;
                    }
                } else {
                    pathPieces.add(normalizedPiece);
                }
                prevPiece = normalizedPiece;
            }
        }
        for (String pathPiece : pathPieces) {
            if (DEEP_TREE_MATCH.equals(pathPiece)) {
                if (this.myFirstDeepTreeIdx == -1) {
                    this.myFirstDeepTreeIdx = currentPosition;
                }
                this.myLastDeepTreeIdx = currentPosition;
            }
            builder.append(File.separatorChar).append(pathPiece);
            ++currentPosition;
        }
        String string = this.myFullPatternString = builder.length() > 0 ? builder.substring(1) : "";
        if (new File(this.myFullPatternString).isAbsolute()) {
            this.myIsAbsolute = true;
        }
        this.myPatternTokens = pathPieces.toArray(new String[pathPieces.size()]);
    }

    private static String normalizePatternString(String patternString) {
        String normalizedPattern = patternString;
        if (SystemInfo.isWindows) {
            normalizedPattern = patternString.replace('/', File.separatorChar);
        }
        if (normalizedPattern.endsWith(File.separator)) {
            normalizedPattern = normalizedPattern + DEEP_TREE_MATCH;
        }
        return normalizedPattern;
    }

    private static List<String> normalizePiece(String piece) {
        if (piece == null) {
            throw new NullPointerException("Piece is null");
        }
        StringBuilder resultBuilder = new StringBuilder(piece);
        SearchPattern.replaceAllInternal(resultBuilder, "***", DEEP_TREE_MATCH);
        if (DEEP_TREE_MATCH.equals(piece)) {
            return Collections.singletonList(DEEP_TREE_MATCH);
        }
        ArrayList<String> actualRetval = new ArrayList<String>();
        int doubleStarIdx = resultBuilder.indexOf(DEEP_TREE_MATCH);
        if (doubleStarIdx == 0) {
            actualRetval.add(DEEP_TREE_MATCH);
            actualRetval.addAll(SearchPattern.normalizePiece(resultBuilder.substring(1)));
        } else if (doubleStarIdx > 0) {
            actualRetval.addAll(SearchPattern.normalizePiece(resultBuilder.substring(0, doubleStarIdx) + "*"));
            actualRetval.add(DEEP_TREE_MATCH);
            if (doubleStarIdx < piece.length() - 2) {
                actualRetval.addAll(SearchPattern.normalizePiece("*" + resultBuilder.substring(doubleStarIdx + 2)));
            }
        } else {
            SearchPattern.replaceAllInternal(resultBuilder, "*?", "?*");
            SearchPattern.replaceAllInternal(resultBuilder, DEEP_TREE_MATCH, "*");
            actualRetval.add(resultBuilder.toString());
        }
        return actualRetval;
    }

    private static void replaceAllInternal(@NotNull StringBuilder builder, @NotNull String searchString, @NotNull String replaceString) {
        int pos;
        if (builder == null) {
            SearchPattern.$$$reportNull$$$0(2);
        }
        if (searchString == null) {
            SearchPattern.$$$reportNull$$$0(3);
        }
        if (replaceString == null) {
            SearchPattern.$$$reportNull$$$0(4);
        }
        while ((pos = builder.indexOf(searchString)) >= 0) {
            builder.replace(pos, pos + searchString.length(), replaceString);
        }
    }

    private static boolean wildcardMatchInternal(@NotNull String pattern, @NotNull String subpattern) {
        if (pattern == null) {
            SearchPattern.$$$reportNull$$$0(5);
        }
        if (subpattern == null) {
            SearchPattern.$$$reportNull$$$0(6);
        }
        if ("*".equals(pattern)) {
            return true;
        }
        int nextStarPatternIdx = pattern.indexOf(42, 1);
        for (int i = 0; i < subpattern.length() - (nextStarPatternIdx - 2); ++i) {
            if (!SearchPattern.matchSubstrings(pattern, 1, subpattern, i, nextStarPatternIdx - 1)) continue;
            return SearchPattern.wildcardMatchInternal(pattern.substring(nextStarPatternIdx), subpattern.substring(i + nextStarPatternIdx - 1));
        }
        return false;
    }

    private static boolean matchSubstrings(String pattern, int patternStartIdx, String subpattern, int subpatternStartIdx, int length) {
        if (subpattern.length() < length + subpatternStartIdx) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            char subChar = subpattern.charAt(subpatternStartIdx + i);
            char patChar = pattern.charAt(patternStartIdx + i);
            if (subChar == '*') {
                return false;
            }
            if (SearchPattern.equalOnSystem(patChar, subChar) || patChar == '?') continue;
            return false;
        }
        return true;
    }

    private static boolean equalOnSystem(char ch1, char ch2) {
        return SystemInfo.isFileSystemCaseSensitive ? ch1 == ch2 : Character.toLowerCase(ch1) == Character.toLowerCase(ch2);
    }

    boolean isIsAbsolute() {
        return this.myIsAbsolute;
    }

    int getOutsideLevel() {
        return this.myOutsideLevel;
    }

    private boolean matches(List<String> tokenizedPath) {
        if (this.myFirstDeepTreeIdx == -1) {
            return tokenizedPath.size() == this.myPatternTokens.length && this.matchSubdirectories(0, tokenizedPath, 0, this.myPatternTokens.length);
        }
        if (!this.matchSubdirectories(0, tokenizedPath, 0, this.myFirstDeepTreeIdx)) {
            return false;
        }
        int suffixLength = this.myPatternTokens.length - this.myLastDeepTreeIdx - 1;
        if (suffixLength > tokenizedPath.size()) {
            return false;
        }
        if (!this.matchSubdirectories(this.myLastDeepTreeIdx + 1, tokenizedPath, tokenizedPath.size() - suffixLength, suffixLength)) {
            return false;
        }
        if (this.myFirstDeepTreeIdx > tokenizedPath.size() - (this.myPatternTokens.length - this.myLastDeepTreeIdx) + 1) {
            return false;
        }
        List<String> sublist = tokenizedPath.subList(this.myFirstDeepTreeIdx, tokenizedPath.size() - (this.myPatternTokens.length - this.myLastDeepTreeIdx) + 1);
        return this.matchesInternal(this.myFirstDeepTreeIdx, this.myLastDeepTreeIdx, sublist);
    }

    private boolean matchesInternal(int patternIdxStart, int patternIdxEnd, List<String> tokenizedPath) {
        if (patternIdxStart == patternIdxEnd) {
            return DEEP_TREE_MATCH.equals(this.myPatternTokens[patternIdxStart]);
        }
        int nextDeepTreeMatch = this.getNextDeepTreeIdx(patternIdxStart + 1);
        for (int i = 0; i < tokenizedPath.size() - (nextDeepTreeMatch - patternIdxStart - 2); ++i) {
            if (!this.matchSubdirectories(patternIdxStart + 1, tokenizedPath, i, nextDeepTreeMatch - patternIdxStart - 1)) continue;
            List<String> sublist = tokenizedPath.subList(i + (nextDeepTreeMatch - patternIdxStart - 1), tokenizedPath.size() - (i + (nextDeepTreeMatch - patternIdxStart - 1)) + (i + (nextDeepTreeMatch - patternIdxStart - 1)));
            return this.matchesInternal(nextDeepTreeMatch, patternIdxEnd, sublist);
        }
        return false;
    }

    private int getNextDeepTreeIdx(int startIdx) {
        for (int i = startIdx; i < this.myPatternTokens.length; ++i) {
            if (!DEEP_TREE_MATCH.equals(this.myPatternTokens[i])) continue;
            return i;
        }
        return -1;
    }

    private boolean matchSubdirectories(int patternStartIdx, List<String> tokenizedPath, int piecesStartIdx, int length) {
        if (tokenizedPath.size() < length + piecesStartIdx) {
            return false;
        }
        for (int i = 0; i < length; ++i) {
            String patternDir = this.myPatternTokens[patternStartIdx + i];
            String pathDir = tokenizedPath.get(piecesStartIdx + i);
            if (DEEP_TREE_MATCH.equals(pathDir)) {
                return false;
            }
            if (SearchPattern.wildcardMatch(pathDir, patternDir)) continue;
            return false;
        }
        return true;
    }

    public String getFullPatternString() {
        return this.myFullPatternString;
    }

    public String[] getFullPatternPath() {
        return this.myPatternTokens;
    }

    public RuleType getRuleType() {
        return this.myRuleType;
    }

    public int hashCode() {
        return this.myFullPatternString.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj instanceof SearchPattern) {
            SearchPattern sp = (SearchPattern)obj;
            return sp.myFullPatternString.equals(this.myFullPatternString);
        }
        return false;
    }

    public String toString() {
        return String.format("%s:%s", this.myRuleType.getPrefix(), this.myFullPatternString);
    }

    public boolean isSubPatternOf(SearchPattern widePattern) {
        return widePattern.matches(Arrays.asList(this.myPatternTokens));
    }

    public PatternPart getInitialState() {
        return new PatternPart(0);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dirOrSubpattern";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "builder";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "searchString";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "replaceString";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "subpattern";
                break;
            }
        }
        objectArray2[1] = "jetbrains/buildServer/util/pathMatcher/SearchPattern";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "wildcardMatch";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "replaceAllInternal";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "wildcardMatchInternal";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    public class PatternPart {
        private final int myCurrentPieceIdx;
        private final String myPatternString;
        private final List<String> myPathParts;
        private boolean myContainsWildcard = false;
        private boolean myExhausted = false;
        private final boolean myIsDeepTree;

        private PatternPart(int currentPieceIdx) {
            int i;
            this.myCurrentPieceIdx = currentPieceIdx;
            StringBuilder builder = new StringBuilder();
            for (i = currentPieceIdx; i < SearchPattern.this.myPatternTokens.length; ++i) {
                builder.append(File.separatorChar).append(SearchPattern.this.myPatternTokens[i]);
            }
            this.myPatternString = builder.substring(1);
            this.myPathParts = new ArrayList<String>();
            for (i = currentPieceIdx; i < SearchPattern.this.myPatternTokens.length; ++i) {
                this.myPathParts.add(SearchPattern.this.myPatternTokens[i]);
                if (!SearchPattern.this.myPatternTokens[i].contains("?") && !SearchPattern.this.myPatternTokens[i].contains("*")) continue;
                this.myContainsWildcard = true;
            }
            this.myExhausted = currentPieceIdx == SearchPattern.this.myPatternTokens.length - 1 && !SearchPattern.DEEP_TREE_MATCH.equals(SearchPattern.this.myPatternTokens[currentPieceIdx]);
            this.myIsDeepTree = this.myPathParts.size() == 1 && SearchPattern.DEEP_TREE_MATCH.equals(this.myPathParts.get(0));
        }

        public String getPatternString() {
            return this.myPatternString;
        }

        public Iterable<String> getPathParts() {
            return this.myPathParts;
        }

        public boolean containsWildcard() {
            return this.myContainsWildcard;
        }

        public boolean isExhausted() {
            return this.myExhausted;
        }

        public String getCurrentPiece() {
            if (SearchPattern.this.myPatternTokens.length == 0) {
                return "";
            }
            return SearchPattern.this.myPatternTokens[this.myCurrentPieceIdx];
        }

        public boolean matches(@NotNull List<String> path) {
            if (path == null) {
                PatternPart.$$$reportNull$$$0(0);
            }
            return SearchPattern.this.matches(path);
        }

        public boolean matches(@NotNull List<String> path, @NotNull String lastPathPart) {
            if (path == null) {
                PatternPart.$$$reportNull$$$0(1);
            }
            if (lastPathPart == null) {
                PatternPart.$$$reportNull$$$0(2);
            }
            path.add(lastPathPart);
            boolean matches = SearchPattern.this.matches(path);
            path.remove(path.size() - 1);
            return matches;
        }

        public boolean find(String filename) {
            return SearchPattern.DEEP_TREE_MATCH.equals(this.getCurrentPiece()) || SearchPattern.wildcardMatch(filename, this.getCurrentPiece());
        }

        public boolean matchesAllInside(@NotNull String folderName) {
            if (folderName == null) {
                PatternPart.$$$reportNull$$$0(3);
            }
            if (this.myIsDeepTree) {
                return true;
            }
            if (this.myPathParts.size() == 2) {
                return folderName.equals(this.myPathParts.get(0)) && this.myPathParts.get(1).equals(SearchPattern.DEEP_TREE_MATCH);
            }
            return false;
        }

        public PatternPart getNextState() {
            if (SearchPattern.DEEP_TREE_MATCH.equals(this.getCurrentPiece())) {
                return this;
            }
            if (this.myCurrentPieceIdx < SearchPattern.this.myPatternTokens.length - 1) {
                return new PatternPart(this.myCurrentPieceIdx + 1);
            }
            throw new IllegalStateException("Wrong current piece");
        }

        public RuleType getRuleType() {
            return SearchPattern.this.myRuleType;
        }

        boolean isAbsolute() {
            return SearchPattern.this.isIsAbsolute();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lastPathPart";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "folderName";
                    break;
                }
            }
            objectArray2[1] = "jetbrains/buildServer/util/pathMatcher/SearchPattern$PatternPart";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "matches";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "matchesAllInside";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

