/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util.positioning;

import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import jetbrains.buildServer.util.filters.Filter;
import jetbrains.buildServer.util.positioning.PluginAwareComparison;
import jetbrains.buildServer.util.positioning.PositionAware;
import jetbrains.buildServer.util.positioning.PositionAwareSortedCollection;
import jetbrains.buildServer.util.positioning.PositionConstraint;
import org.jetbrains.annotations.NotNull;

public class PositionAwareCollection<T> {
    private final Object LOCK;
    private final PluginAwareComparison myComparison;
    private final AtomicReference<List<T>> mySortedExtensions;
    private final PositionAwareSortedCollection<T> myPositions;

    public PositionAwareCollection() {
        this(PluginAwareComparison.BY_REF);
    }

    public PositionAwareCollection(@NotNull PluginAwareComparison comparison) {
        if (comparison == null) {
            PositionAwareCollection.$$$reportNull$$$0(0);
        }
        this.LOCK = new Object();
        this.mySortedExtensions = new AtomicReference();
        this.myPositions = new PositionAwareSortedCollection();
        this.myComparison = comparison;
    }

    private void resetCache() {
        this.mySortedExtensions.set(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isEmpty() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.myPositions.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.LOCK;
        synchronized (object) {
            this.myPositions.clear();
            this.resetCache();
        }
    }

    public void add(@NotNull T item, @NotNull PositionAware positionAware) {
        if (item == null) {
            PositionAwareCollection.$$$reportNull$$$0(1);
        }
        if (positionAware == null) {
            PositionAwareCollection.$$$reportNull$$$0(2);
        }
        this.add(item, positionAware.getOrderId(), positionAware.getConstraint());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(@NotNull T item, @NotNull String id, @NotNull PositionConstraint constraint) {
        if (item == null) {
            PositionAwareCollection.$$$reportNull$$$0(3);
        }
        if (id == null) {
            PositionAwareCollection.$$$reportNull$$$0(4);
        }
        if (constraint == null) {
            PositionAwareCollection.$$$reportNull$$$0(5);
        }
        Object object = this.LOCK;
        synchronized (object) {
            this.remove(item);
            this.myPositions.add(item, id, constraint);
            this.resetCache();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean remove(final @NotNull T item) {
        if (item == null) {
            PositionAwareCollection.$$$reportNull$$$0(6);
        }
        Object object = this.LOCK;
        synchronized (object) {
            boolean result = this.myPositions.removeWhere(new Filter<T>(){

                @Override
                public boolean accept(@NotNull T data) {
                    if (data == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return PositionAwareCollection.this.myComparison.equal(data, item);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "jetbrains/buildServer/util/positioning/PositionAwareCollection$1", "accept"));
                }
            });
            this.resetCache();
            return result;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<T> getAllSorted() {
        List<T> result = this.mySortedExtensions.get();
        if (result == null) {
            Object object = this.LOCK;
            synchronized (object) {
                result = this.mySortedExtensions.get();
                if (result == null) {
                    List<T> resort = this.myPositions.getSorted();
                    this.mySortedExtensions.set(resort);
                    result = resort;
                }
            }
        }
        List<T> list = Collections.unmodifiableList(result);
        if (list == null) {
            PositionAwareCollection.$$$reportNull$$$0(7);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 7: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 7: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "comparison";
                break;
            }
            case 1: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "positionAware";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraint";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/util/positioning/PositionAwareCollection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/util/positioning/PositionAwareCollection";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllSorted";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 7: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 7: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

