/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util.positioning;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.Function;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jetbrains.buildServer.dataStructures.MultiMapToSet;
import jetbrains.buildServer.util.StringUtil;
import jetbrains.buildServer.util.filters.Filter;
import jetbrains.buildServer.util.positioning.PositionConstraint;
import org.jetbrains.annotations.NotNull;

public class PositionAwareSortedCollection<T> {
    private static final Logger LOG = Logger.getInstance((String)PositionAwareSortedCollection.class.getName());
    private final List<Node<T>> myFirstNodes = new ArrayList<Node<T>>();
    private final List<Node<T>> myLastNodes = new ArrayList<Node<T>>();
    private final List<Node<T>> myNodes = new ArrayList<Node<T>>();
    private final MultiMapToSet<String, String> myBeforeConstraints = new MultiMapToSet();
    private final MultiMapToSet<String, String> myAfterConstraints = new MultiMapToSet();
    private final Set<String> myIds = new HashSet<String>();
    private final Set<String> myNotExisting = new HashSet<String>();
    private final Function<Node<T>, String> NODE_TO_STRING = new Function<Node<T>, String>(){

        public String fun(Node<T> node) {
            return node.getId();
        }
    };

    public void add(@NotNull T item, @NotNull String id, @NotNull PositionConstraint constraint) {
        if (item == null) {
            PositionAwareSortedCollection.$$$reportNull$$$0(0);
        }
        if (id == null) {
            PositionAwareSortedCollection.$$$reportNull$$$0(1);
        }
        if (constraint == null) {
            PositionAwareSortedCollection.$$$reportNull$$$0(2);
        }
        Node<T> node = new Node<T>(item, id);
        this.myIds.add(id);
        this.myNotExisting.remove(id);
        if (constraint.isFirst()) {
            this.myFirstNodes.add(node);
        } else if (constraint.isLast()) {
            this.myLastNodes.add(node);
        } else {
            this.myNodes.add(node);
        }
        for (String s : constraint.getBefore()) {
            this.myAfterConstraints.add(id, s);
            if (this.myIds.contains(s)) continue;
            this.myNotExisting.add(s);
        }
        for (String s : constraint.getAfter()) {
            this.myBeforeConstraints.add(id, s);
            if (this.myIds.contains(s)) continue;
            this.myNotExisting.add(s);
        }
    }

    public boolean remove(@NotNull T item) {
        if (item == null) {
            PositionAwareSortedCollection.$$$reportNull$$$0(3);
        }
        String id2Clean = null;
        for (List nodes : Arrays.asList(this.myNodes, this.myFirstNodes, this.myLastNodes)) {
            int idx = -1;
            for (int i = 0; i < nodes.size(); ++i) {
                Node node = (Node)nodes.get(i);
                if (node.getItem() != item) continue;
                idx = i;
                id2Clean = node.getId();
                break;
            }
            if (idx == -1) continue;
            nodes.remove(idx);
        }
        if (id2Clean != null) {
            this.cleanupId(id2Clean);
        }
        return id2Clean != null;
    }

    public boolean removeWhere(@NotNull Filter<T> filter) {
        if (filter == null) {
            PositionAwareSortedCollection.$$$reportNull$$$0(4);
        }
        HashSet<String> removedIds = new HashSet<String>();
        for (Collection collection : Arrays.asList(this.myNodes, this.myFirstNodes, this.myLastNodes)) {
            Iterator it = collection.iterator();
            while (it.hasNext()) {
                Node node = (Node)it.next();
                if (!filter.accept(node.getItem())) continue;
                it.remove();
                removedIds.add(node.getId());
            }
        }
        for (String string : removedIds) {
            this.cleanupId(string);
        }
        return removedIds.size() > 0;
    }

    private void cleanupId(String id) {
        this.myIds.remove(id);
        this.myAfterConstraints.removeKey(id);
        this.myBeforeConstraints.removeKey(id);
    }

    public boolean isEmpty() {
        return this.myIds.isEmpty();
    }

    public int size() {
        return this.myLastNodes.size() + this.myFirstNodes.size() + this.myNodes.size();
    }

    public void clear() {
        this.myFirstNodes.clear();
        this.myLastNodes.clear();
        this.myNodes.clear();
        this.myIds.clear();
        this.myBeforeConstraints.clear();
        this.myAfterConstraints.clear();
    }

    private MultiMapToSet<String, String> getCombinedBeforeMap() {
        MultiMapToSet<String, String> retval = new MultiMapToSet<String, String>();
        for (Map.Entry entry : this.myBeforeConstraints.entrySet()) {
            retval.addAll((String)entry.getKey(), (Collection)entry.getValue());
        }
        for (Map.Entry entry : this.myAfterConstraints.entrySet()) {
            String key = (String)entry.getKey();
            for (String val : (Set)entry.getValue()) {
                retval.add(val, key);
            }
        }
        return retval;
    }

    @NotNull
    public List<T> getSorted() {
        if (this.isEmpty()) {
            List list = Collections.emptyList();
            if (list == null) {
                PositionAwareSortedCollection.$$$reportNull$$$0(5);
            }
            return list;
        }
        HashSet<String> added = new HashSet<String>(3 * this.size() + this.myNotExisting.size() * 2);
        added.addAll(this.myNotExisting);
        MultiMapToSet<String, String> combinedBeforeMap = this.getCombinedBeforeMap();
        this.myFirstNodes.addAll(this.processNodes(this.myFirstNodes, added, combinedBeforeMap));
        this.myNodes.addAll(this.processNodes(this.myNodes, added, combinedBeforeMap));
        this.myLastNodes.addAll(this.processNodes(this.myLastNodes, added, combinedBeforeMap));
        List<T> list = this.createResultCollection();
        if (list == null) {
            PositionAwareSortedCollection.$$$reportNull$$$0(6);
        }
        return list;
    }

    private List<Node<T>> processNodes(@NotNull List<Node<T>> nodes, @NotNull Set<String> added, @NotNull MultiMapToSet<String, String> combinedBeforeMap) {
        if (nodes == null) {
            PositionAwareSortedCollection.$$$reportNull$$$0(7);
        }
        if (added == null) {
            PositionAwareSortedCollection.$$$reportNull$$$0(8);
        }
        if (combinedBeforeMap == null) {
            PositionAwareSortedCollection.$$$reportNull$$$0(9);
        }
        ArrayList<Node<T>> result = new ArrayList<Node<T>>(nodes.size());
        while (!nodes.isEmpty()) {
            boolean mayContinue = false;
            Iterator<Node<T>> it = nodes.iterator();
            while (it.hasNext()) {
                Node<T> node = it.next();
                if (!added.containsAll(combinedBeforeMap.getValues(node.getId()))) continue;
                it.remove();
                this.addNodeToResult(result, added, node);
                mayContinue = true;
                break;
            }
            if (mayContinue || nodes.size() <= 0) continue;
            LOG.warn("Dependency cycle detected among ordered items: " + this.nodesToString(nodes) + ", order is unpredictable");
            Node<T> node = nodes.remove(0);
            this.addNodeToResult(result, added, node);
        }
        return result;
    }

    private String nodesToString(List<Node<T>> nodes) {
        if (nodes.isEmpty()) {
            return "<empty>";
        }
        return StringUtil.join(nodes, this.NODE_TO_STRING, (String)", ");
    }

    @NotNull
    private List<T> createResultCollection() {
        ArrayList items = new ArrayList(this.size());
        for (Collection collection : Arrays.asList(this.myFirstNodes, this.myNodes, this.myLastNodes)) {
            for (Node node : collection) {
                items.add(node.getItem());
            }
        }
        ArrayList arrayList = items;
        if (arrayList == null) {
            PositionAwareSortedCollection.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    private void addNodeToResult(@NotNull Collection<Node<T>> result, @NotNull Set<String> added, @NotNull Node<T> node) {
        if (result == null) {
            PositionAwareSortedCollection.$$$reportNull$$$0(11);
        }
        if (added == null) {
            PositionAwareSortedCollection.$$$reportNull$$$0(12);
        }
        if (node == null) {
            PositionAwareSortedCollection.$$$reportNull$$$0(13);
        }
        added.add(node.getId());
        result.add(node);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 5: 
            case 6: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 5: 
            case 6: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "id";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "constraint";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "filter";
                break;
            }
            case 5: 
            case 6: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/util/positioning/PositionAwareSortedCollection";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "nodes";
                break;
            }
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "added";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "combinedBeforeMap";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/util/positioning/PositionAwareSortedCollection";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSorted";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "createResultCollection";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "add";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "remove";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "removeWhere";
                break;
            }
            case 5: 
            case 6: 
            case 10: {
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "processNodes";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "addNodeToResult";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 5: 
            case 6: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class Node<T> {
        private final String myId;
        private final T myItem;

        public Node(@NotNull T item, @NotNull String id) {
            if (item == null) {
                Node.$$$reportNull$$$0(0);
            }
            if (id == null) {
                Node.$$$reportNull$$$0(1);
            }
            this.myItem = item;
            this.myId = id;
        }

        @NotNull
        public T getItem() {
            T t = this.myItem;
            if (t == null) {
                Node.$$$reportNull$$$0(2);
            }
            return t;
        }

        @NotNull
        public String getId() {
            String string = this.myId;
            if (string == null) {
                Node.$$$reportNull$$$0(3);
            }
            return string;
        }

        public String toString() {
            return "Node{myId='" + this.myId + '\'' + '}';
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: 
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: 
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "item";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "id";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "jetbrains/buildServer/util/positioning/PositionAwareSortedCollection$Node";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "jetbrains/buildServer/util/positioning/PositionAwareSortedCollection$Node";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getItem";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getId";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: 
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

