/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util.positioning;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class PositionConstraint {
    public static final PositionConstraint UNDEFINED = new PositionConstraint(){

        @Override
        public String toString() {
            return "undefined";
        }

        @Override
        public int compareTo(String id) {
            return 0;
        }
    };
    private static final PositionConstraint FIRST = new PositionConstraint(){

        @Override
        public int compareTo(String id) {
            return Integer.MIN_VALUE;
        }

        @Override
        public String toString() {
            return "first";
        }
    };
    private static final PositionConstraint LAST = new PositionConstraint(){

        @Override
        public int compareTo(String id) {
            return Integer.MAX_VALUE;
        }

        @Override
        public String toString() {
            return "last";
        }
    };

    @NotNull
    public static PositionConstraint first() {
        PositionConstraint positionConstraint = FIRST;
        if (positionConstraint == null) {
            PositionConstraint.$$$reportNull$$$0(0);
        }
        return positionConstraint;
    }

    @NotNull
    public static PositionConstraint last() {
        PositionConstraint positionConstraint = LAST;
        if (positionConstraint == null) {
            PositionConstraint.$$$reportNull$$$0(1);
        }
        return positionConstraint;
    }

    public boolean isFirst() {
        return this == FIRST;
    }

    public boolean isLast() {
        return this == LAST;
    }

    @NotNull
    public Collection<String> getBefore() {
        List<String> list = Collections.emptyList();
        if (list == null) {
            PositionConstraint.$$$reportNull$$$0(2);
        }
        return list;
    }

    @NotNull
    public Collection<String> getAfter() {
        List<String> list = Collections.emptyList();
        if (list == null) {
            PositionConstraint.$$$reportNull$$$0(3);
        }
        return list;
    }

    @NotNull
    public static PositionConstraint before(final String ... ids) {
        if (ids == null) {
            PositionConstraint.$$$reportNull$$$0(4);
        }
        final HashSet<String> idSet = new HashSet<String>(Arrays.asList(ids));
        PositionConstraint positionConstraint = new PositionConstraint(){

            @Override
            public int compareTo(String id) {
                if (idSet.contains(id)) {
                    return -1;
                }
                return 0;
            }

            @Override
            public String toString() {
                return "before: " + Arrays.asList(ids);
            }

            @Override
            @NotNull
            public Collection<String> getBefore() {
                Set set = idSet;
                if (set == null) {
                    1.$$$reportNull$$$0(0);
                }
                return set;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/positioning/PositionConstraint$1", "getBefore"));
            }
        };
        if (positionConstraint == null) {
            PositionConstraint.$$$reportNull$$$0(5);
        }
        return positionConstraint;
    }

    @NotNull
    public static PositionConstraint after(final String ... ids) {
        if (ids == null) {
            PositionConstraint.$$$reportNull$$$0(6);
        }
        final HashSet<String> idSet = new HashSet<String>(Arrays.asList(ids));
        PositionConstraint positionConstraint = new PositionConstraint(){

            @Override
            public int compareTo(String id) {
                if (idSet.contains(id)) {
                    return 1;
                }
                return 0;
            }

            @Override
            public String toString() {
                return "after: " + Arrays.asList(ids);
            }

            @Override
            @NotNull
            public Collection<String> getAfter() {
                Set set = idSet;
                if (set == null) {
                    2.$$$reportNull$$$0(0);
                }
                return set;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "jetbrains/buildServer/util/positioning/PositionConstraint$2", "getAfter"));
            }
        };
        if (positionConstraint == null) {
            PositionConstraint.$$$reportNull$$$0(7);
        }
        return positionConstraint;
    }

    @NotNull
    public static PositionConstraint between(@NotNull Collection<String> afterIds, @NotNull Collection<String> beforeIds) {
        if (afterIds == null) {
            PositionConstraint.$$$reportNull$$$0(8);
        }
        if (beforeIds == null) {
            PositionConstraint.$$$reportNull$$$0(9);
        }
        final PositionConstraint beforePos = PositionConstraint.before(beforeIds.toArray(new String[beforeIds.size()]));
        final PositionConstraint afterPos = PositionConstraint.after(afterIds.toArray(new String[afterIds.size()]));
        PositionConstraint positionConstraint = new PositionConstraint(){

            @Override
            public String toString() {
                return beforePos.toString() + " and " + afterPos.toString();
            }

            @Override
            public int compareTo(String id) {
                int res = beforePos.compareTo(id);
                if (res != 0) {
                    return res;
                }
                return afterPos.compareTo(id);
            }

            @Override
            @NotNull
            public Collection<String> getAfter() {
                Collection<String> collection = afterPos.getAfter();
                if (collection == null) {
                    3.$$$reportNull$$$0(0);
                }
                return collection;
            }

            @Override
            @NotNull
            public Collection<String> getBefore() {
                Collection<String> collection = beforePos.getBefore();
                if (collection == null) {
                    3.$$$reportNull$$$0(1);
                }
                return collection;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[2];
                objectArray2[0] = "jetbrains/buildServer/util/positioning/PositionConstraint$3";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getAfter";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getBefore";
                        break;
                    }
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
            }
        };
        if (positionConstraint == null) {
            PositionConstraint.$$$reportNull$$$0(10);
        }
        return positionConstraint;
    }

    public abstract String toString();

    public abstract int compareTo(String var1);

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/util/positioning/PositionConstraint";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ids";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "afterIds";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beforeIds";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "first";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "last";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getBefore";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getAfter";
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/util/positioning/PositionConstraint";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "before";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "after";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "between";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "before";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "after";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "between";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 4: 
            case 6: 
            case 8: 
            case 9: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

