/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util.regex;

import com.intellij.openapi.diagnostic.Logger;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jetbrains.buildServer.serverSide.TeamCityProperties;
import jetbrains.buildServer.util.Dates;
import jetbrains.buildServer.util.StringUtil;
import jetbrains.buildServer.util.TimePrinter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class MatcherUtil {
    private static final Logger LOG = Logger.getInstance((String)MatcherUtil.class.getName());
    public static final String REGEX_MATCHING_TIMEOUT_MS = "teamcity.regex.matching.timeout.ms";
    public static final int DEFAULT_REGEX_MATCHING_TIMEOUT_MS = 20000;

    @Nullable
    public static String find(@NotNull String input, @NotNull String regex, int timeout) throws MatchingException {
        if (input == null) {
            MatcherUtil.$$$reportNull$$$0(0);
        }
        if (regex == null) {
            MatcherUtil.$$$reportNull$$$0(1);
        }
        return MatcherUtil.find(input, Pattern.compile(regex), timeout);
    }

    @Nullable
    public static String find(@NotNull String input, @NotNull Pattern pattern, int timeout) throws MatchingException {
        if (input == null) {
            MatcherUtil.$$$reportNull$$$0(2);
        }
        if (pattern == null) {
            MatcherUtil.$$$reportNull$$$0(3);
        }
        Matcher matcher = MatcherUtil.createMatcherWithTimeout(input, pattern, timeout);
        try {
            return matcher.find() ? matcher.group() : null;
        }
        catch (StackOverflowError e) {
            throw MatcherUtil.handleStackOverflowError(e, input, pattern.pattern());
        }
    }

    @Nullable
    public static String find(@NotNull String input, @NotNull Pattern pattern) throws MatchingException {
        int timeout;
        if (input == null) {
            MatcherUtil.$$$reportNull$$$0(4);
        }
        if (pattern == null) {
            MatcherUtil.$$$reportNull$$$0(5);
        }
        if ((timeout = TeamCityProperties.getInteger(REGEX_MATCHING_TIMEOUT_MS, 20000)) < 0) {
            Matcher matcher = pattern.matcher(input);
            return matcher.find() ? matcher.group() : null;
        }
        return MatcherUtil.find(input, pattern, timeout);
    }

    @Nullable
    public static String find(@NotNull String input, @NotNull String regex) throws MatchingException {
        if (input == null) {
            MatcherUtil.$$$reportNull$$$0(6);
        }
        if (regex == null) {
            MatcherUtil.$$$reportNull$$$0(7);
        }
        return MatcherUtil.find(input, Pattern.compile(regex));
    }

    public static boolean matches(@NotNull String input, @NotNull String regex, int timeout) throws MatchingException {
        if (input == null) {
            MatcherUtil.$$$reportNull$$$0(8);
        }
        if (regex == null) {
            MatcherUtil.$$$reportNull$$$0(9);
        }
        Matcher matcher = MatcherUtil.createMatcherWithTimeout(input, Pattern.compile(regex), timeout);
        try {
            return matcher.matches();
        }
        catch (StackOverflowError e) {
            throw MatcherUtil.handleStackOverflowError(e, input, regex);
        }
    }

    private static MatchingException handleStackOverflowError(@NotNull StackOverflowError e, @NotNull String input, @NotNull String regex) {
        if (e == null) {
            MatcherUtil.$$$reportNull$$$0(10);
        }
        if (input == null) {
            MatcherUtil.$$$reportNull$$$0(11);
        }
        if (regex == null) {
            MatcherUtil.$$$reportNull$$$0(12);
        }
        String format = "Matching '%s' against regular expression '" + regex + "' failed causing a deep recursion and " + (e.getMessage() == null ? e.getClass().getName() : e.getMessage()) + ". Please try to simplify the regular expression";
        LOG.debug(String.format(format, input));
        return new MatchingException(String.format(format, StringUtil.truncateStringValueWithDotsAtCenter(input, 50)));
    }

    @NotNull
    private static Matcher createMatcherWithTimeout(@NotNull String input, @NotNull Pattern pattern, int timeout) {
        if (input == null) {
            MatcherUtil.$$$reportNull$$$0(13);
        }
        if (pattern == null) {
            MatcherUtil.$$$reportNull$$$0(14);
        }
        Matcher matcher = pattern.matcher(new TimeoutRegexCharSequence(input, timeout, input, pattern.pattern()));
        if (matcher == null) {
            MatcherUtil.$$$reportNull$$$0(15);
        }
        return matcher;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "input";
                break;
            }
            case 1: 
            case 7: 
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "regex";
                break;
            }
            case 3: 
            case 5: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pattern";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jetbrains/buildServer/util/regex/MatcherUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "jetbrains/buildServer/util/regex/MatcherUtil";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "createMatcherWithTimeout";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "find";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "matches";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "handleStackOverflowError";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "createMatcherWithTimeout";
                break;
            }
            case 15: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    public static class MatchingException
    extends RuntimeException {
        public MatchingException(@NotNull String msg) {
            if (msg == null) {
                MatchingException.$$$reportNull$$$0(0);
            }
            super(msg);
        }

        public MatchingException(@NotNull String msg, @NotNull Throwable cause) {
            if (msg == null) {
                MatchingException.$$$reportNull$$$0(1);
            }
            if (cause == null) {
                MatchingException.$$$reportNull$$$0(2);
            }
            super(msg, cause);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "msg";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[0] = "cause";
                    break;
                }
            }
            objectArray[1] = "jetbrains/buildServer/util/regex/MatcherUtil$MatchingException";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static class TimeoutRegexCharSequence
    implements CharSequence {
        @NotNull
        private final CharSequence delegate;
        private final long timeout;
        private final long timeoutTime;
        @NotNull
        private final String input;
        @NotNull
        private final String pattern;
        private int counter;

        /*
         * WARNING - void declaration
         */
        public TimeoutRegexCharSequence(@NotNull CharSequence delegate, long timeout, @NotNull String input, @NotNull String string) {
            void pattern;
            if (delegate == null) {
                TimeoutRegexCharSequence.$$$reportNull$$$0(0);
            }
            if (input == null) {
                TimeoutRegexCharSequence.$$$reportNull$$$0(1);
            }
            if (string == null) {
                TimeoutRegexCharSequence.$$$reportNull$$$0(2);
            }
            this.counter = 0;
            this.delegate = delegate;
            this.timeout = timeout;
            this.timeoutTime = System.nanoTime() + TimeUnit.MILLISECONDS.toNanos(timeout);
            this.input = input;
            this.pattern = pattern;
        }

        @Override
        public char charAt(int index) {
            if (this.counter % 1000 == 0 && System.nanoTime() > this.timeoutTime) {
                return this.handleTimeout();
            }
            ++this.counter;
            return this.delegate.charAt(index);
        }

        private char handleTimeout() {
            String format = "Regular expression '" + this.pattern + "' matching is interrupted after " + this.getTimeoutString() + " on '%s': regular expression is considered too time-consuming, please try to simplify it";
            LOG.debug(String.format(format, this.input));
            throw new MatchingException(String.format(format, StringUtil.truncateStringValueWithDotsAtCenter(this.input, 50)));
        }

        @NotNull
        private String getTimeoutString() {
            String string = TimePrinter.createSecondsFormatter(false).formatTime(this.timeout / Dates.ONE_SECOND);
            if (string == null) {
                TimeoutRegexCharSequence.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Override
        public int length() {
            return this.delegate.length();
        }

        @Override
        public CharSequence subSequence(int start, int end) {
            return new TimeoutRegexCharSequence(this.delegate.subSequence(start, end), this.timeout, this.input, this.pattern);
        }

        @Override
        @NotNull
        public String toString() {
            String string = this.delegate.toString();
            if (string == null) {
                TimeoutRegexCharSequence.$$$reportNull$$$0(4);
            }
            return string;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: 
                case 4: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: 
                case 4: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "delegate";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "input";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "pattern";
                    break;
                }
                case 3: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "jetbrains/buildServer/util/regex/MatcherUtil$TimeoutRegexCharSequence";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "jetbrains/buildServer/util/regex/MatcherUtil$TimeoutRegexCharSequence";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getTimeoutString";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "toString";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: 
                case 4: {
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: 
                case 4: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

