/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.util.ssl;

import com.intellij.openapi.diagnostic.Logger;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import jetbrains.buildServer.util.ssl.AggregateSSLTrustManager;
import org.jetbrains.annotations.Nullable;

public class SSLContextUtil {
    private static final Logger LOG = Logger.getInstance((String)SSLContextUtil.class.getName());

    private SSLContextUtil() {
        throw new IllegalStateException();
    }

    @Nullable
    public static SSLContext createUserSSLContext(@Nullable KeyStore trustStore) {
        try {
            X509TrustManager defaultTrustManager = SSLContextUtil.createTrustManager(SSLContextUtil.getDefaultTrustStore());
            X509TrustManager trustManager = trustStore == null ? defaultTrustManager : new AggregateSSLTrustManager(defaultTrustManager, SSLContextUtil.createTrustManager(trustStore));
            SSLContext context = SSLContext.getInstance("TLS");
            context.init(SSLContextUtil.getKeyManagers(), new TrustManager[]{trustManager}, new SecureRandom());
            return context;
        }
        catch (GeneralSecurityException e) {
            LOG.warn("Can't create UserSSLContext");
            return null;
        }
    }

    public static X509TrustManager createTrustManager(@Nullable KeyStore trustStore) throws NoSuchAlgorithmException, KeyStoreException {
        TrustManagerFactory manager = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        manager.init(trustStore);
        return (X509TrustManager)manager.getTrustManagers()[0];
    }

    @Nullable
    public static KeyManagerFactory getDefaultKeyManagerFactoryEx() throws KeyStoreException, IOException, UnrecoverableKeyException, NoSuchAlgorithmException, CertificateException {
        String password = System.getProperty("javax.net.ssl.keyStorePassword");
        KeyStore ks = SSLContextUtil.getStore(System.getProperty("javax.net.ssl.keyStore"), password, System.getProperty("javax.net.ssl.keyStoreType"));
        if (ks == null) {
            return null;
        }
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        keyManagerFactory.init(ks, password != null ? password.toCharArray() : null);
        return keyManagerFactory;
    }

    @Nullable
    public static KeyManagerFactory getDefaultKeyManagerFactory() {
        try {
            return SSLContextUtil.getDefaultKeyManagerFactoryEx();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static KeyStore getDefaultTrustStore() {
        try {
            return SSLContextUtil.getStore(System.getProperty("javax.net.ssl.trustStore"), System.getProperty("javax.net.ssl.trustStorePassword"), System.getProperty("javax.net.ssl.trustStoreType"));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Nullable
    private static KeyManager[] getKeyManagers() {
        KeyManagerFactory factory = SSLContextUtil.getDefaultKeyManagerFactory();
        return factory != null ? factory.getKeyManagers() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static KeyStore getStore(@Nullable String store, @Nullable String password, @Nullable String type) throws KeyStoreException, IOException, CertificateException, NoSuchAlgorithmException {
        if (store == null) {
            return null;
        }
        KeyStore ks = KeyStore.getInstance(type != null ? type : KeyStore.getDefaultType());
        try (FileInputStream stream = new FileInputStream(store);){
            ks.load(stream, password != null ? password.toCharArray() : null);
        }
        return ks;
    }
}

